/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.io.metadata;

import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.io.CacheTag;
import org.apache.hadoop.hive.common.io.DataCache;
import org.apache.hadoop.hive.common.io.DiskRangeList;
import org.apache.hadoop.hive.llap.cache.EvictionDispatcher;
import org.apache.hadoop.hive.llap.cache.LlapCacheableBuffer;
import org.apache.hadoop.hive.ql.io.SyntheticFileId;
import org.apache.hadoop.hive.ql.io.orc.encoded.IncompleteCb;
import org.apache.hadoop.hive.ql.util.IncrementalObjectSizeEstimator;

public class OrcFileEstimateErrors
extends LlapCacheableBuffer {
    private final Object fileKey;
    private int estimatedMemUsage;
    private final ConcurrentHashMap<Long, Integer> cache = new ConcurrentHashMap();
    private static final HashMap<Class<?>, IncrementalObjectSizeEstimator.ObjectEstimator> SIZE_ESTIMATORS = IncrementalObjectSizeEstimator.createEstimators((Object)OrcFileEstimateErrors.createDummy(new SyntheticFileId(new Path("/"), 0L, 0L)));
    private static final IncrementalObjectSizeEstimator.ObjectEstimator SIZE_ESTIMATOR = SIZE_ESTIMATORS.get(OrcFileEstimateErrors.class);

    public OrcFileEstimateErrors(Object fileKey) {
        this.fileKey = fileKey;
    }

    public void addError(long offset, int length, long baseOffset) {
        Long key = offset + baseOffset;
        Integer existingLength = this.cache.get(key);
        if (existingLength != null && existingLength >= length) {
            return;
        }
        Integer value = length;
        while ((existingLength = this.cache.putIfAbsent(key, value)) != null && existingLength < length) {
            this.cache.remove(key, existingLength);
        }
        return;
    }

    public DiskRangeList getIncompleteCbs(DiskRangeList ranges, long baseOffset, DataCache.BooleanRef gotAllData) {
        DiskRangeList prev = ranges.prev;
        if (prev == null) {
            prev = new DiskRangeList.MutateHelper(ranges);
        }
        DiskRangeList current = ranges;
        gotAllData.value = true;
        while (current != null) {
            DiskRangeList check = current;
            current = current.next;
            if (check.hasData()) continue;
            Integer badLength = this.cache.get(check.getOffset() + baseOffset);
            if (badLength == null || badLength < check.getLength()) {
                gotAllData.value = false;
                continue;
            }
            check.replaceSelfWith((DiskRangeList)new IncompleteCb(check.getOffset(), check.getEnd()));
        }
        return prev.next;
    }

    public Object getFileKey() {
        return this.fileKey;
    }

    public long estimateMemoryUsage() {
        this.estimatedMemUsage = 10 * SIZE_ESTIMATOR.estimate((Object)this, SIZE_ESTIMATORS);
        return this.estimatedMemUsage;
    }

    private static OrcFileEstimateErrors createDummy(Object fileKey) {
        OrcFileEstimateErrors dummy = new OrcFileEstimateErrors(fileKey);
        dummy.addError(0L, 0, 0L);
        return dummy;
    }

    @Override
    protected int invalidate() {
        return 0;
    }

    @Override
    public long getMemoryUsage() {
        return this.estimatedMemUsage;
    }

    @Override
    public void notifyEvicted(EvictionDispatcher evictionDispatcher) {
        evictionDispatcher.notifyEvicted(this);
    }

    @Override
    protected boolean isLocked() {
        return false;
    }

    @Override
    public CacheTag getTag() {
        return CacheTag.build((String)"OrcEstimates");
    }
}

