/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.extra.chrono;

import java.io.Serializable;
import java.time.Clock;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoPeriod;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalQuery;
import java.time.temporal.TemporalUnit;
import java.time.temporal.ValueRange;
import java.util.Objects;
import org.threeten.extra.chrono.AbstractDate;
import org.threeten.extra.chrono.HybridChronology;
import org.threeten.extra.chrono.JulianDate;
import org.threeten.extra.chrono.JulianEra;

public final class HybridDate
extends AbstractDate
implements ChronoLocalDate,
Serializable {
    private static final long serialVersionUID = -9626278512674L;
    private final LocalDate isoDate;
    private final transient JulianDate julianDate;

    public static HybridDate now() {
        return HybridDate.now(Clock.systemDefaultZone());
    }

    public static HybridDate now(ZoneId zone) {
        return HybridDate.now(Clock.system(zone));
    }

    public static HybridDate now(Clock clock) {
        return new HybridDate(LocalDate.now(clock));
    }

    public static HybridDate of(int prolepticYear, int month, int dayOfMonth) {
        return HybridDate.create(prolepticYear, month, dayOfMonth);
    }

    public static HybridDate from(TemporalAccessor temporal) {
        if (temporal instanceof HybridDate) {
            return (HybridDate)temporal;
        }
        return new HybridDate(LocalDate.from(temporal));
    }

    static HybridDate ofYearDay(int prolepticYear, int dayOfYear) {
        if (prolepticYear < 1582 || prolepticYear == 1582 && dayOfYear <= 246) {
            JulianDate julian = JulianDate.ofYearDay(prolepticYear, dayOfYear);
            return new HybridDate(julian);
        }
        if (prolepticYear == 1582) {
            LocalDate iso = LocalDate.ofYearDay(prolepticYear, dayOfYear + 10);
            return new HybridDate(iso);
        }
        LocalDate iso = LocalDate.ofYearDay(prolepticYear, dayOfYear);
        return new HybridDate(iso);
    }

    static HybridDate ofEpochDay(long epochDay) {
        return new HybridDate(LocalDate.ofEpochDay(epochDay));
    }

    static HybridDate create(int prolepticYear, int month, int dayOfMonth) {
        if (prolepticYear < 1582) {
            JulianDate julian = JulianDate.of(prolepticYear, month, dayOfMonth);
            return new HybridDate(julian);
        }
        LocalDate iso = LocalDate.of(prolepticYear, month, dayOfMonth);
        if (iso.isBefore(HybridChronology.CUTOVER)) {
            JulianDate julian = JulianDate.of(prolepticYear, month, dayOfMonth);
            return new HybridDate(julian);
        }
        return new HybridDate(iso);
    }

    HybridDate(LocalDate isoDate) {
        Objects.requireNonNull(isoDate, "isoDate");
        this.isoDate = isoDate;
        this.julianDate = isoDate.isBefore(HybridChronology.CUTOVER) ? JulianDate.from(isoDate) : null;
    }

    HybridDate(JulianDate julianDate) {
        Objects.requireNonNull(julianDate, "julianDate");
        this.isoDate = LocalDate.from(julianDate);
        this.julianDate = this.isoDate.isBefore(HybridChronology.CUTOVER) ? julianDate : null;
    }

    private Object readResolve() {
        return new HybridDate(this.isoDate);
    }

    private boolean isCutoverYear() {
        return this.isoDate.getYear() == 1582 && this.isoDate.getDayOfYear() > 10;
    }

    private boolean isCutoverMonth() {
        return this.isoDate.getYear() == 1582 && this.isoDate.getMonthValue() == 9 && this.isoDate.getDayOfMonth() > 10;
    }

    @Override
    int getAlignedDayOfWeekInMonth() {
        if (this.isCutoverMonth() && this.julianDate == null) {
            return (this.getDayOfMonth() - 1 - 10) % this.lengthOfWeek() + 1;
        }
        return super.getAlignedDayOfWeekInMonth();
    }

    @Override
    int getAlignedWeekOfMonth() {
        if (this.isCutoverMonth() && this.julianDate == null) {
            return (this.getDayOfMonth() - 1 - 10) / this.lengthOfWeek() + 1;
        }
        return super.getAlignedWeekOfMonth();
    }

    @Override
    int getProlepticYear() {
        return this.julianDate != null ? this.julianDate.getProlepticYear() : this.isoDate.getYear();
    }

    @Override
    int getMonth() {
        return this.julianDate != null ? this.julianDate.getMonth() : this.isoDate.getMonthValue();
    }

    @Override
    int getDayOfMonth() {
        return this.julianDate != null ? this.julianDate.getDayOfMonth() : this.isoDate.getDayOfMonth();
    }

    @Override
    int getDayOfYear() {
        if (this.julianDate != null) {
            return this.julianDate.getDayOfYear();
        }
        if (this.isoDate.getYear() == 1582) {
            return this.isoDate.getDayOfYear() - 10;
        }
        return this.isoDate.getDayOfYear();
    }

    @Override
    public ValueRange rangeChrono(ChronoField field) {
        switch (field) {
            case DAY_OF_MONTH: {
                if (this.isCutoverMonth()) {
                    return ValueRange.of(1L, 30L);
                }
                return ValueRange.of(1L, this.lengthOfMonth());
            }
            case DAY_OF_YEAR: {
                return ValueRange.of(1L, this.lengthOfYear());
            }
            case ALIGNED_WEEK_OF_MONTH: {
                return this.rangeAlignedWeekOfMonth();
            }
            case ALIGNED_WEEK_OF_YEAR: {
                if (this.isCutoverYear()) {
                    return ValueRange.of(1L, 51L);
                }
                return ChronoField.ALIGNED_WEEK_OF_YEAR.range();
            }
        }
        return this.getChronology().range(field);
    }

    @Override
    ValueRange rangeAlignedWeekOfMonth() {
        if (this.isCutoverMonth()) {
            return ValueRange.of(1L, 3L);
        }
        return ValueRange.of(1L, this.getMonth() == 2 && !this.isLeapYear() ? 4L : 5L);
    }

    @Override
    HybridDate resolvePrevious(int year, int month, int dayOfMonth) {
        switch (month) {
            case 2: {
                dayOfMonth = Math.min(dayOfMonth, this.getChronology().isLeapYear(year) ? 29 : 28);
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                dayOfMonth = Math.min(dayOfMonth, 30);
                break;
            }
        }
        return HybridDate.create(year, month, dayOfMonth);
    }

    @Override
    public HybridChronology getChronology() {
        return HybridChronology.INSTANCE;
    }

    @Override
    public JulianEra getEra() {
        return this.getProlepticYear() >= 1 ? JulianEra.AD : JulianEra.BC;
    }

    @Override
    public int lengthOfMonth() {
        if (this.isCutoverMonth()) {
            return 19;
        }
        return this.julianDate != null ? this.julianDate.lengthOfMonth() : this.isoDate.lengthOfMonth();
    }

    @Override
    public int lengthOfYear() {
        if (this.isCutoverYear()) {
            return 355;
        }
        return this.julianDate != null ? this.julianDate.lengthOfYear() : this.isoDate.lengthOfYear();
    }

    @Override
    public HybridDate with(TemporalAdjuster adjuster) {
        return (HybridDate)adjuster.adjustInto(this);
    }

    @Override
    public HybridDate with(TemporalField field, long newValue) {
        return (HybridDate)super.with(field, newValue);
    }

    @Override
    public HybridDate plus(TemporalAmount amount) {
        return (HybridDate)amount.addTo(this);
    }

    @Override
    public HybridDate plus(long amountToAdd, TemporalUnit unit) {
        return (HybridDate)super.plus(amountToAdd, unit);
    }

    @Override
    public HybridDate minus(TemporalAmount amount) {
        return (HybridDate)amount.subtractFrom(this);
    }

    @Override
    public HybridDate minus(long amountToSubtract, TemporalUnit unit) {
        return amountToSubtract == Long.MIN_VALUE ? this.plus(Long.MAX_VALUE, unit).plus(1L, unit) : this.plus(-amountToSubtract, unit);
    }

    public ChronoLocalDateTime<HybridDate> atTime(LocalTime localTime) {
        return super.atTime(localTime);
    }

    @Override
    public long until(Temporal endExclusive, TemporalUnit unit) {
        return super.until(HybridDate.from(endExclusive), unit);
    }

    @Override
    public ChronoPeriod until(ChronoLocalDate endDateExclusive) {
        AbstractDate calcDate;
        HybridDate end = HybridDate.from(endDateExclusive);
        long totalMonths = end.getProlepticMonth() - this.getProlepticMonth();
        int days = end.getDayOfMonth() - this.getDayOfMonth();
        if (totalMonths == 0L && this.isCutoverMonth()) {
            if (this.julianDate != null && end.julianDate == null) {
                days -= 10;
            } else if (this.julianDate == null && end.julianDate != null) {
                days += 10;
            }
        } else if (totalMonths > 0L) {
            if (this.julianDate != null && end.julianDate == null) {
                calcDate = this.plusMonths(totalMonths);
                days = (int)(end.toEpochDay() - calcDate.toEpochDay());
            }
            if (days < 0) {
                calcDate = this.plusMonths(--totalMonths);
                days = (int)(end.toEpochDay() - calcDate.toEpochDay());
            }
        } else if (totalMonths < 0L && days > 0) {
            calcDate = this.plusMonths(++totalMonths);
            days = (int)(end.toEpochDay() - calcDate.toEpochDay());
        }
        int years = Math.toIntExact(totalMonths / (long)this.lengthOfYearInMonths());
        int months = (int)(totalMonths % (long)this.lengthOfYearInMonths());
        return this.getChronology().period(years, months, days);
    }

    @Override
    public long toEpochDay() {
        return this.isoDate.toEpochDay();
    }

    @Override
    public <R> R query(TemporalQuery<R> query) {
        if (query == TemporalQueries.localDate()) {
            return (R)this.isoDate;
        }
        return super.query(query);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof HybridDate) {
            HybridDate otherDate = (HybridDate)obj;
            return this.isoDate.equals(otherDate.isoDate);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getChronology().getId().hashCode() ^ this.isoDate.hashCode();
    }
}

