/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.LogUtils;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.common.cli.CommonCliOptions;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.TransactionalValidationListener;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.TableValidWriteIds;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.utils.HiveStrictManagedUtils;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.util.CloseableThreadLocal;
import org.apache.hadoop.hive.ql.util.NamedForkJoinWorkerThreadFactory;
import org.apache.hadoop.hive.ql.util.UpgradeTool;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveStrictManagedMigration {
    private static final Logger LOG = LoggerFactory.getLogger(HiveStrictManagedMigration.class);
    private final HiveConf conf;
    private final RunOptions runOptions;
    private final boolean createExternalDirsForDbs;
    private final Path targetPath;
    private final HadoopShims.HdfsEncryptionShim encryptionShim;
    private final HadoopShims.HdfsErasureCodingShim ecShim;
    private final String ownerName;
    private final String groupName;
    private final FsPermission dirPerms;
    private final FsPermission filePerms;
    private CloseableThreadLocal<HiveMetaStoreClient> hms;
    private ThreadLocal<Warehouse> wh;
    private ThreadLocal<Warehouse> oldWh;
    private CloseableThreadLocal<HiveUpdater> hiveUpdater;
    private AtomicBoolean failuresEncountered;
    private AtomicBoolean failedValidationChecks;
    private static final Map<String, String> convertToExternalTableProps = new HashMap<String, String>();
    private static final Map<String, String> convertToAcidTableProps = new HashMap<String, String>();
    private static final Map<String, String> convertToMMTableProps = new HashMap<String, String>();
    @VisibleForTesting
    static HiveConf hiveConf;
    @VisibleForTesting
    static String scheme;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        RunOptions runOptions;
        try {
            Options opts = HiveStrictManagedMigration.createOptions();
            CommandLine cli = new GnuParser().parse(opts, args);
            if (cli.hasOption('h')) {
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp(HiveStrictManagedMigration.class.getName(), opts);
                return;
            }
            runOptions = HiveStrictManagedMigration.createRunOptions(cli);
        }
        catch (Exception err) {
            throw new Exception("Error processing options", err);
        }
        int rc = 0;
        HiveStrictManagedMigration migration = null;
        try {
            HiveConf conf = hiveConf == null ? new HiveConf() : hiveConf;
            WarehouseRootCheckResult warehouseRootCheckResult = HiveStrictManagedMigration.checkOldWarehouseRoot(runOptions, conf);
            runOptions.setShouldModifyManagedTableLocation(warehouseRootCheckResult.shouldModifyManagedTableLocation);
            runOptions.setShouldMoveExternal(warehouseRootCheckResult.shouldMoveExternal);
            boolean createExternalDirsForDbs = HiveStrictManagedMigration.checkExternalWarehouseDir(conf);
            OwnerPermsOptions ownerPermsOptions = HiveStrictManagedMigration.checkOwnerPermsOptions(runOptions, conf);
            migration = new HiveStrictManagedMigration(conf, runOptions, createExternalDirsForDbs, ownerPermsOptions, warehouseRootCheckResult);
            migration.run();
        }
        catch (Exception err) {
            LOG.error("Failed with error", (Throwable)err);
            rc = -1;
        }
        finally {
            if (migration != null) {
                migration.cleanup();
            }
        }
        if (hiveConf == null) {
            System.exit(rc);
        }
    }

    static Options createOptions() {
        Options result = new Options();
        OptionBuilder.withValueSeparator();
        OptionBuilder.hasArgs((int)2);
        OptionBuilder.withArgName((String)"property=value");
        OptionBuilder.withLongOpt((String)"hiveconf");
        OptionBuilder.withDescription((String)"Use value for given property");
        result.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"dryRun");
        OptionBuilder.withDescription((String)"Show what migration actions would be taken without actually running commands");
        result.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"dbRegex");
        OptionBuilder.withDescription((String)"Regular expression to match database names on which this tool will be run");
        OptionBuilder.hasArg();
        result.addOption(OptionBuilder.create((char)'d'));
        OptionBuilder.withLongOpt((String)"tableRegex");
        OptionBuilder.withDescription((String)"Regular expression to match table names on which this tool will be run");
        OptionBuilder.hasArg();
        result.addOption(OptionBuilder.create((char)'t'));
        OptionBuilder.withLongOpt((String)"oldWarehouseRoot");
        OptionBuilder.withDescription((String)"Location of the previous warehouse root");
        OptionBuilder.hasArg();
        result.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"migrationOption");
        OptionBuilder.withDescription((String)"Table migration option (automatic|external|managed|validate|none)");
        OptionBuilder.hasArg();
        result.addOption(OptionBuilder.create((char)'m'));
        OptionBuilder.withLongOpt((String)"shouldModifyManagedTableLocation");
        OptionBuilder.withDescription((String)"Whether managed tables should have their data moved from the old warehouse path to the current warehouse path");
        result.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"shouldModifyManagedTableOwner");
        OptionBuilder.withDescription((String)"Whether managed tables should have their directory owners changed to the hive user");
        result.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"shouldModifyManagedTablePermissions");
        OptionBuilder.withDescription((String)"Whether managed tables should have their directory permissions changed to conform to strict managed tables mode");
        result.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"modifyManagedTables");
        OptionBuilder.withDescription((String)"This setting enables the shouldModifyManagedTableLocation, shouldModifyManagedTableOwner, shouldModifyManagedTablePermissions options");
        result.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"shouldMoveExternal");
        OptionBuilder.withDescription((String)"Whether tables living in the old warehouse path should have their data moved to the default external location. Applicable only if migrationOption = external");
        result.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"help");
        OptionBuilder.withDescription((String)"print help message");
        result.addOption(OptionBuilder.create((char)'h'));
        OptionBuilder.withLongOpt((String)"tablePoolSize");
        OptionBuilder.withDescription((String)"Number of threads to process tables.");
        OptionBuilder.hasArg();
        result.addOption(OptionBuilder.create((String)"tn"));
        OptionBuilder.withLongOpt((String)"tableType");
        OptionBuilder.withDescription((String)String.format("Table type to match tables on which this tool will be run. Possible values: %s Default: all tables", Arrays.stream(TableType.values()).map(Enum::name).collect(Collectors.joining("|"))));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"table type");
        result.addOption(OptionBuilder.create((String)"tt"));
        return result;
    }

    static RunOptions createRunOptions(CommandLine cli) throws Exception {
        int tablePoolSize;
        Properties confProps = cli.getOptionProperties("hiveconf");
        for (String propKey : confProps.stringPropertyNames()) {
            LOG.info("Setting {}={}", (Object)propKey, (Object)confProps.getProperty(propKey));
            if (propKey.equalsIgnoreCase("hive.root.logger")) {
                CommonCliOptions.splitAndSetLogger(propKey, confProps);
                continue;
            }
            System.setProperty(propKey, confProps.getProperty(propKey));
        }
        LogUtils.initHiveLog4j();
        String dbRegex = cli.getOptionValue("dbRegex", ".*");
        String tableRegex = cli.getOptionValue("tableRegex", ".*");
        TableMigrationOption migrationOption = TableMigrationOption.valueOf(cli.getOptionValue("migrationOption", "none").toUpperCase());
        boolean shouldModifyManagedTableLocation = cli.hasOption("shouldModifyManagedTableLocation");
        boolean shouldModifyManagedTableOwner = cli.hasOption("shouldModifyManagedTableOwner");
        boolean shouldModifyManagedTablePermissions = cli.hasOption("shouldModifyManagedTablePermissions");
        if (cli.hasOption("modifyManagedTables")) {
            shouldModifyManagedTableLocation = true;
            shouldModifyManagedTableOwner = true;
            shouldModifyManagedTablePermissions = true;
        }
        String oldWarehouseRoot = cli.getOptionValue("oldWarehouseRoot");
        boolean shouldMoveExternal = cli.hasOption("shouldMoveExternal");
        if (shouldMoveExternal && !migrationOption.equals((Object)TableMigrationOption.EXTERNAL)) {
            throw new IllegalArgumentException("Please select external as migration option, it is required for shouldMoveExternal option.");
        }
        if (shouldModifyManagedTableLocation && shouldMoveExternal) {
            throw new IllegalArgumentException("Options shouldModifyManagedTableLocation and shouldMoveExternal cannot be used at the same time. Migration with move option on  managed tables either ends up with them remaining managed or converted to external, but can't be both.");
        }
        boolean dryRun = cli.hasOption("dryRun");
        String tableTypeText = cli.getOptionValue("tableType");
        int defaultPoolSize = Runtime.getRuntime().availableProcessors();
        if (defaultPoolSize < 1) {
            defaultPoolSize = 1;
        }
        if ((tablePoolSize = HiveStrictManagedMigration.getIntOptionValue(cli, "tablePoolSize", defaultPoolSize)) < 1) {
            throw new IllegalArgumentException("Please specify a positive integer option value for tablePoolSize");
        }
        RunOptions runOpts = new RunOptions(dbRegex, tableRegex, oldWarehouseRoot, migrationOption, confProps, shouldModifyManagedTableLocation, shouldModifyManagedTableOwner, shouldModifyManagedTablePermissions, shouldMoveExternal, dryRun, tableTypeText == null ? null : TableType.valueOf(tableTypeText), tablePoolSize);
        return runOpts;
    }

    private static int getIntOptionValue(CommandLine commandLine, String optionName, int defaultValue) {
        if (commandLine.hasOption(optionName)) {
            try {
                return Integer.parseInt(commandLine.getOptionValue(optionName));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Please specify a positive integer option value for " + optionName, e);
            }
        }
        return defaultValue;
    }

    HiveStrictManagedMigration(HiveConf conf, RunOptions runOptions, boolean createExternalDirsForDbs, OwnerPermsOptions ownerPermsOptions, WarehouseRootCheckResult warehouseRootCheckResult) {
        this.conf = conf;
        this.runOptions = runOptions;
        this.createExternalDirsForDbs = createExternalDirsForDbs;
        this.ownerName = ownerPermsOptions.ownerName;
        this.groupName = ownerPermsOptions.groupName;
        this.dirPerms = ownerPermsOptions.dirPerms;
        this.filePerms = ownerPermsOptions.filePerms;
        this.targetPath = warehouseRootCheckResult.targetPath;
        this.encryptionShim = warehouseRootCheckResult.encryptionShim;
        this.ecShim = warehouseRootCheckResult.ecShim;
        if (runOptions.confProps != null) {
            for (String propKey : runOptions.confProps.stringPropertyNames()) {
                this.conf.set(propKey, runOptions.confProps.getProperty(propKey));
            }
        }
        this.hms = new CloseableThreadLocal<HiveMetaStoreClient>(() -> {
            try {
                HiveMetaStoreClient hiveMetaStoreClient = new HiveMetaStoreClient(conf);
                if (hiveConf != null) {
                    SessionState ss = SessionState.start(conf);
                    ss.applyAuthorizationPolicy();
                }
                return hiveMetaStoreClient;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, runOptions.tablePoolSize);
        this.wh = ThreadLocal.withInitial(() -> {
            try {
                return new Warehouse(conf);
            }
            catch (MetaException e) {
                throw new RuntimeException(e);
            }
        });
        if (runOptions.shouldModifyManagedTableLocation || runOptions.shouldMoveExternal) {
            Configuration oldConf = new Configuration((Configuration)conf);
            HiveConf.setVar(oldConf, HiveConf.ConfVars.METASTOREWAREHOUSE, runOptions.oldWarehouseRoot);
            this.oldWh = ThreadLocal.withInitial(() -> {
                try {
                    return new Warehouse(oldConf);
                }
                catch (MetaException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        this.hiveUpdater = new CloseableThreadLocal<HiveUpdater>(() -> {
            try {
                return new HiveUpdater(conf, true);
            }
            catch (HiveException e) {
                throw new RuntimeException(e);
            }
        }, runOptions.tablePoolSize);
        this.failuresEncountered = new AtomicBoolean(false);
        this.failedValidationChecks = new AtomicBoolean(false);
    }

    void run() throws Exception {
        LOG.info("Starting with {}", (Object)this.runOptions);
        List<String> databases = this.hms.get().getDatabases(this.runOptions.dbRegex);
        LOG.info("Found {} databases", (Object)databases.size());
        ForkJoinPool tablePool = new ForkJoinPool(this.runOptions.tablePoolSize, new NamedForkJoinWorkerThreadFactory("Table-"), this.getUncaughtExceptionHandler(), false);
        databases.forEach(dbName -> this.processDatabase((String)dbName, tablePool));
        LOG.info("Done processing databases.");
        if (this.failuresEncountered.get()) {
            throw new HiveException("One or more failures encountered during processing.");
        }
        if (this.failedValidationChecks.get()) {
            throw new HiveException("One or more tables failed validation checks for strict managed table mode.");
        }
    }

    private Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return (t, e) -> LOG.error(String.format("Thread %s exited with error", t.getName()), e);
    }

    static WarehouseRootCheckResult checkOldWarehouseRoot(RunOptions runOptions, HiveConf conf) throws IOException {
        boolean shouldModifyManagedTableLocation = runOptions.shouldModifyManagedTableLocation;
        boolean shouldMoveExternal = runOptions.shouldMoveExternal;
        Path targetPath = null;
        HadoopShims.HdfsEncryptionShim encryptionShim = null;
        HadoopShims.HdfsErasureCodingShim ecShim = null;
        if (shouldMoveExternal && !HiveStrictManagedMigration.checkExternalWarehouseDir(conf)) {
            LOG.info("External warehouse path not specified/empty. Disabling shouldMoveExternal");
            shouldMoveExternal = false;
        }
        if (shouldModifyManagedTableLocation || shouldMoveExternal) {
            if (runOptions.oldWarehouseRoot == null) {
                LOG.info("oldWarehouseRoot is not specified. Disabling shouldModifyManagedTableLocation and shouldMoveExternal");
                shouldModifyManagedTableLocation = false;
                shouldMoveExternal = false;
            } else {
                String currentPathString;
                String string = currentPathString = shouldModifyManagedTableLocation ? HiveConf.getVar(conf, HiveConf.ConfVars.METASTOREWAREHOUSE) : HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_METASTORE_WAREHOUSE_EXTERNAL);
                if (HiveStrictManagedMigration.arePathsEqual(conf, runOptions.oldWarehouseRoot, currentPathString)) {
                    LOG.info("oldWarehouseRoot is the same as the target path {}. Disabling shouldModifyManagedTableLocation and shouldMoveExternal", (Object)runOptions.oldWarehouseRoot);
                    shouldModifyManagedTableLocation = false;
                    shouldMoveExternal = false;
                } else {
                    Path oldWhRootPath = new Path(runOptions.oldWarehouseRoot);
                    targetPath = new Path(currentPathString);
                    FileSystem oldWhRootFs = oldWhRootPath.getFileSystem((Configuration)conf);
                    FileSystem curWhRootFs = targetPath.getFileSystem((Configuration)conf);
                    oldWhRootPath = oldWhRootFs.makeQualified(oldWhRootPath);
                    targetPath = curWhRootFs.makeQualified(targetPath);
                    if (!FileUtils.equalsFileSystem(oldWhRootFs, curWhRootFs)) {
                        LOG.info("oldWarehouseRoot {} has a different FS than the target path {}. Disabling shouldModifyManagedTableLocation and shouldMoveExternal", (Object)runOptions.oldWarehouseRoot, (Object)currentPathString);
                        shouldModifyManagedTableLocation = false;
                        shouldMoveExternal = false;
                    } else if (!HiveStrictManagedMigration.isHdfs(oldWhRootFs)) {
                        LOG.info("Warehouse is using non-HDFS FileSystem {}. Disabling shouldModifyManagedTableLocation andshouldMoveExternal", (Object)oldWhRootFs.getUri());
                        shouldModifyManagedTableLocation = false;
                        shouldMoveExternal = false;
                    } else {
                        encryptionShim = ShimLoader.getHadoopShims().createHdfsEncryptionShim(oldWhRootFs, conf);
                        if (!HiveStrictManagedMigration.hasEquivalentEncryption(encryptionShim, oldWhRootPath, targetPath)) {
                            LOG.info("oldWarehouseRoot {} and target path {} have different encryption zones. Disabling shouldModifyManagedTableLocation and shouldMoveExternal", (Object)oldWhRootPath, (Object)targetPath);
                            shouldModifyManagedTableLocation = false;
                            shouldMoveExternal = false;
                        } else {
                            ecShim = ShimLoader.getHadoopShims().createHdfsErasureCodingShim(oldWhRootFs, conf);
                            if (!HiveStrictManagedMigration.hasEquivalentErasureCodingPolicy(ecShim, oldWhRootPath, targetPath)) {
                                LOG.info("oldWarehouseRoot {} and target path {} have different erasure coding policies. Disabling shouldModifyManagedTableLocation and shouldMoveExternal", (Object)oldWhRootPath, (Object)targetPath);
                                shouldModifyManagedTableLocation = false;
                                shouldMoveExternal = false;
                            }
                        }
                    }
                }
            }
        }
        return new WarehouseRootCheckResult(shouldModifyManagedTableLocation, shouldMoveExternal, targetPath, encryptionShim, ecShim);
    }

    static OwnerPermsOptions checkOwnerPermsOptions(RunOptions runOptions, HiveConf conf) {
        String ownerName = null;
        String groupName = null;
        FsPermission dirPerms = null;
        FsPermission filePerms = null;
        if (runOptions.shouldModifyManagedTableOwner) {
            ownerName = conf.get("strict.managed.tables.migration.owner", "hive");
            groupName = conf.get("strict.managed.tables.migration.group", null);
        }
        if (runOptions.shouldModifyManagedTablePermissions) {
            String filePermsString;
            String dirPermsString = conf.get("strict.managed.tables.migration.dir.permissions", "700");
            if (dirPermsString != null) {
                dirPerms = new FsPermission(dirPermsString);
            }
            if ((filePermsString = conf.get("strict.managed.tables.migration.file.permissions", "700")) != null) {
                filePerms = new FsPermission(filePermsString);
            }
        }
        return new OwnerPermsOptions(ownerName, groupName, dirPerms, filePerms);
    }

    static boolean checkExternalWarehouseDir(HiveConf conf) {
        String externalWarehouseDir = conf.getVar(HiveConf.ConfVars.HIVE_METASTORE_WAREHOUSE_EXTERNAL);
        return externalWarehouseDir != null && !externalWarehouseDir.isEmpty();
    }

    void processDatabase(String dbName, ForkJoinPool tablePool) {
        try {
            boolean errorsInThisDb;
            List<String> tableNames;
            boolean modifyLocation;
            LOG.info("Processing database {}", (Object)dbName);
            Database dbObj = this.hms.get().getDatabase(dbName);
            if (this.createExternalDirsForDbs) {
                this.createExternalDbDir(dbObj);
            }
            if (modifyLocation = this.shouldModifyDatabaseLocation(dbObj)) {
                Path newDefaultDbLocation = this.getDefaultDbPathManagedOrExternal(dbName);
                LOG.info("Changing location of database {} to {}", (Object)dbName, (Object)newDefaultDbLocation);
                if (!this.runOptions.dryRun) {
                    FileSystem fs = newDefaultDbLocation.getFileSystem((Configuration)this.conf);
                    FileUtils.mkdir(fs, newDefaultDbLocation, this.conf);
                    HiveStrictManagedMigration.checkAndSetFileOwnerPermissions(fs, newDefaultDbLocation, this.ownerName, this.groupName, this.dirPerms, null, this.runOptions.dryRun, false);
                }
            }
            if (this.runOptions.tableType == null) {
                tableNames = this.hms.get().getTables(dbName, this.runOptions.tableRegex);
                LOG.debug("found {} tables in {}", (Object)tableNames.size(), (Object)dbName);
            } else {
                tableNames = this.hms.get().getTables(dbName, this.runOptions.tableRegex, this.runOptions.tableType);
                LOG.debug("found {} {}s in {}", new Object[]{tableNames.size(), this.runOptions.tableType.name(), dbName});
            }
            boolean bl = errorsInThisDb = (Boolean)((ForkJoinTask)tablePool.submit(() -> tableNames.parallelStream().map(tableName -> this.processTable(dbObj, (String)tableName, modifyLocation)).reduce(true, (aBoolean, aBoolean2) -> aBoolean != false && aBoolean2 != false))).get() == false;
            if (errorsInThisDb) {
                this.failuresEncountered.set(true);
            }
            if (modifyLocation) {
                if (errorsInThisDb) {
                    LOG.error("Not updating database location for {} since an error was encountered. The migration must be run again for this database.", (Object)dbObj.getName());
                } else if (!this.runOptions.dryRun) {
                    Path newDefaultDbLocation = this.getDefaultDbPathManagedOrExternal(dbName);
                    this.hiveUpdater.get().updateDbLocation(dbObj, newDefaultDbLocation);
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.info("Cancel processing " + dbName, (Throwable)e);
        }
        catch (IOException | ExecutionException | HiveException | TException ex) {
            LOG.error("Error processing database " + dbName, (Throwable)ex);
            this.failuresEncountered.set(true);
        }
    }

    private Path getDefaultDbPathManagedOrExternal(String dbName) throws MetaException {
        return this.runOptions.shouldMoveExternal ? this.wh.get().getDefaultExternalDatabasePath(dbName) : this.wh.get().getDefaultDatabasePath(dbName);
    }

    public static boolean migrateTable(org.apache.hadoop.hive.metastore.api.Table tableObj, TableType tableType, TableMigrationOption migrationOption, boolean dryRun, HiveUpdater hiveUpdater, IMetaStoreClient hms, Configuration conf) throws HiveException, IOException, TException {
        switch (migrationOption) {
            case EXTERNAL: {
                HiveStrictManagedMigration.migrateToExternalTable(tableObj, tableType, dryRun, hiveUpdater);
                break;
            }
            case MANAGED: {
                HiveStrictManagedMigration.migrateToManagedTable(tableObj, tableType, dryRun, hiveUpdater, hms, conf);
                break;
            }
            case NONE: {
                break;
            }
            case VALIDATE: {
                String reason = HiveStrictManagedUtils.validateStrictManagedTable(conf, tableObj);
                if (reason == null) break;
                LOG.warn(reason);
                return true;
            }
            default: {
                throw new IllegalArgumentException("Unexpected table migration option " + (Object)((Object)migrationOption));
            }
        }
        return false;
    }

    boolean processTable(Database dbObj, String tableName, boolean modifyLocation) {
        try {
            FileSystem fs;
            boolean shouldMoveTable;
            boolean failedValidationCheck;
            String dbName = dbObj.getName();
            LOG.debug("Processing table {}", (Object)HiveStrictManagedMigration.getQualifiedName(dbName, tableName));
            org.apache.hadoop.hive.metastore.api.Table tableObj = this.hms.get().getTable(dbName, tableName);
            TableType tableType = TableType.valueOf(tableObj.getTableType());
            TableMigrationOption migrationOption = this.runOptions.migrationOption;
            if (migrationOption == TableMigrationOption.AUTOMATIC) {
                migrationOption = HiveStrictManagedMigration.determineMigrationTypeAutomatically(tableObj, tableType, this.ownerName, this.conf, this.hms.get(), null);
            }
            if (failedValidationCheck = HiveStrictManagedMigration.migrateTable(tableObj, tableType, migrationOption, this.runOptions.dryRun, this.hiveUpdater.get(), this.hms.get(), this.conf)) {
                this.failedValidationChecks.set(true);
                return true;
            }
            Path tablePath = new Path(tableObj.getSd().getLocation());
            boolean bl = shouldMoveTable = modifyLocation && (TableType.MANAGED_TABLE.name().equals(tableObj.getTableType()) && this.runOptions.shouldModifyManagedTableLocation || TableType.EXTERNAL_TABLE.name().equals(tableObj.getTableType()) && this.runOptions.shouldMoveExternal);
            if (shouldMoveTable && this.shouldModifyTableLocation(dbObj, tableObj)) {
                Path newTablePath = this.wh.get().getDnsPath(new Path(this.getDefaultDbPathManagedOrExternal(dbName), MetaStoreUtils.encodeTableName(tableName.toLowerCase())));
                this.moveTableData(dbObj, tableObj, newTablePath);
                if (!this.runOptions.dryRun) {
                    tablePath = newTablePath;
                }
            }
            if (TableType.MANAGED_TABLE.equals((Object)tableType) && (this.runOptions.shouldModifyManagedTableOwner || this.runOptions.shouldModifyManagedTablePermissions) && HiveStrictManagedMigration.isHdfs(fs = tablePath.getFileSystem((Configuration)this.conf))) {
                HiveStrictManagedMigration.checkAndSetFileOwnerPermissions(fs, tablePath, this.ownerName, this.groupName, this.dirPerms, this.filePerms, this.runOptions.dryRun, true);
            }
        }
        catch (Exception ex) {
            LOG.error("Error processing table " + HiveStrictManagedMigration.getQualifiedName(dbObj.getName(), tableName), (Throwable)ex);
            return false;
        }
        return true;
    }

    boolean shouldModifyDatabaseLocation(Database dbObj) throws IOException, MetaException {
        Path oldDefaultDbLocation;
        String dbLocation;
        String dbName = dbObj.getName();
        if ((this.runOptions.shouldModifyManagedTableLocation || this.runOptions.shouldMoveExternal) && HiveStrictManagedMigration.arePathsEqual(this.conf, dbLocation = dbObj.getLocationUri(), (oldDefaultDbLocation = this.oldWh.get().getDefaultDatabasePath(dbName)).toString())) {
            if (HiveStrictManagedMigration.hasEquivalentEncryption(this.encryptionShim, oldDefaultDbLocation, this.targetPath)) {
                if (HiveStrictManagedMigration.hasEquivalentErasureCodingPolicy(this.ecShim, oldDefaultDbLocation, this.targetPath)) {
                    return true;
                }
                LOG.info("{} and {} have different EC policies. Will not change database location for {}", new Object[]{oldDefaultDbLocation, this.targetPath, dbName});
            } else {
                LOG.info("{} and {} are on different encryption zones. Will not change database location for {}", new Object[]{oldDefaultDbLocation, this.targetPath, dbName});
            }
        }
        return false;
    }

    boolean shouldModifyTableLocation(Database dbObj, org.apache.hadoop.hive.metastore.api.Table tableObj) throws IOException, MetaException {
        Path oldDefaultTableLocation;
        String tableLocation = tableObj.getSd().getLocation();
        if (HiveStrictManagedMigration.arePathsEqual(this.conf, tableLocation, (oldDefaultTableLocation = this.oldWh.get().getDefaultTablePath(dbObj, tableObj.getTableName())).toString())) {
            if (HiveStrictManagedMigration.hasEquivalentEncryption(this.encryptionShim, oldDefaultTableLocation, this.targetPath)) {
                if (HiveStrictManagedMigration.hasEquivalentErasureCodingPolicy(this.ecShim, oldDefaultTableLocation, this.targetPath)) {
                    return true;
                }
                LOG.info("{} and {} have different EC policies. Will not change table location for {}", new Object[]{oldDefaultTableLocation, this.targetPath, HiveStrictManagedMigration.getQualifiedName(tableObj)});
            } else {
                LOG.info("{} and {} are on different encryption zones. Will not change table location for {}", new Object[]{oldDefaultTableLocation, this.targetPath, HiveStrictManagedMigration.getQualifiedName(tableObj)});
            }
        }
        return false;
    }

    boolean shouldModifyPartitionLocation(Database dbObj, org.apache.hadoop.hive.metastore.api.Table tableObj, org.apache.hadoop.hive.metastore.api.Partition partObj, Map<String, String> partSpec) throws IOException, MetaException {
        Path oldDefaultPartLocation;
        String partLocation = partObj.getSd().getLocation();
        Path path = oldDefaultPartLocation = this.runOptions.shouldMoveExternal ? this.oldWh.get().getPartitionPath(dbObj, tableObj, partSpec.values().stream().collect(Collectors.toList())) : this.oldWh.get().getDefaultPartitionPath(dbObj, tableObj, partSpec);
        return HiveStrictManagedMigration.arePathsEqual(this.conf, partLocation, oldDefaultPartLocation.toString());
    }

    void createExternalDbDir(Database dbObj) throws IOException, MetaException {
        Path externalTableDbPath = this.wh.get().getDefaultExternalDatabasePath(dbObj.getName());
        FileSystem fs = externalTableDbPath.getFileSystem((Configuration)this.conf);
        if (!fs.exists(externalTableDbPath)) {
            String dbOwner = this.ownerName;
            String dbGroup = null;
            String dbOwnerName = dbObj.getOwnerName();
            if (dbOwnerName != null && !dbOwnerName.isEmpty()) {
                switch (dbObj.getOwnerType()) {
                    case USER: {
                        dbOwner = dbOwnerName;
                        break;
                    }
                    case ROLE: {
                        break;
                    }
                    case GROUP: {
                        dbGroup = dbOwnerName;
                    }
                }
            }
            LOG.info("Creating external table directory for database {} at {} with ownership {}/{}", new Object[]{dbObj.getName(), externalTableDbPath, dbOwner, dbGroup});
            if (!this.runOptions.dryRun) {
                fs.mkdirs(externalTableDbPath);
                HiveStrictManagedMigration.checkAndSetFileOwnerPermissions(fs, externalTableDbPath, dbOwner, dbGroup, null, null, this.runOptions.dryRun, false);
            }
        } else {
            LOG.info("Not creating external table directory for database {} - {} already exists.", (Object)dbObj.getName(), (Object)externalTableDbPath);
        }
    }

    void moveTableData(Database dbObj, org.apache.hadoop.hive.metastore.api.Table tableObj, Path newTablePath) throws HiveException, IOException, TException {
        boolean movedData;
        FileSystem fs;
        String dbName = tableObj.getDbName();
        String tableName = tableObj.getTableName();
        Path oldTablePath = new Path(tableObj.getSd().getLocation());
        LOG.info("Moving location of {} from {} to {}", new Object[]{HiveStrictManagedMigration.getQualifiedName(tableObj), oldTablePath, newTablePath});
        if (!this.runOptions.dryRun && (fs = newTablePath.getFileSystem((Configuration)this.conf)).exists(oldTablePath) && !(movedData = fs.rename(oldTablePath, newTablePath))) {
            String msg = String.format("Unable to move data directory for table %s from %s to %s", HiveStrictManagedMigration.getQualifiedName(tableObj), oldTablePath, newTablePath);
            throw new HiveException(msg);
        }
        if (HiveStrictManagedMigration.isPartitionedTable(tableObj)) {
            List<String> partNames = this.hms.get().listPartitionNames(dbName, tableName, (short)Short.MAX_VALUE);
            for (String partName : partNames) {
                Map<String, String> partSpec;
                org.apache.hadoop.hive.metastore.api.Partition partObj = this.hms.get().getPartition(dbName, tableName, partName);
                if (!this.shouldModifyPartitionLocation(dbObj, tableObj, partObj, partSpec = Warehouse.makeSpecFromValues(tableObj.getPartitionKeys(), partObj.getValues())) || this.runOptions.dryRun) continue;
                Path newPartPath = this.wh.get().getPartitionPath(newTablePath, partSpec);
                this.hiveUpdater.get().updatePartitionLocation(dbName, tableObj, partName, partObj, newPartPath);
            }
        }
        if (!this.runOptions.dryRun) {
            this.hiveUpdater.get().updateTableLocation(tableObj, newTablePath);
        }
    }

    static void renameFilesToConformToAcid(org.apache.hadoop.hive.metastore.api.Table tableObj, IMetaStoreClient hms, Configuration conf, boolean dryRun) throws IOException, TException {
        if (HiveStrictManagedMigration.isPartitionedTable(tableObj)) {
            String dbName = tableObj.getDbName();
            String tableName = tableObj.getTableName();
            List<String> partNames = hms.listPartitionNames(dbName, tableName, (short)Short.MAX_VALUE);
            for (String partName : partNames) {
                org.apache.hadoop.hive.metastore.api.Partition partObj = hms.getPartition(dbName, tableName, partName);
                Path partPath = new Path(partObj.getSd().getLocation());
                FileSystem fs = partPath.getFileSystem(conf);
                if (!fs.exists(partPath)) continue;
                UpgradeTool.handleRenameFiles(tableObj, partPath, !dryRun, conf, tableObj.getSd().getBucketColsSize() > 0, null);
            }
        } else {
            Path tablePath = new Path(tableObj.getSd().getLocation());
            FileSystem fs = tablePath.getFileSystem(conf);
            if (fs.exists(tablePath)) {
                UpgradeTool.handleRenameFiles(tableObj, tablePath, !dryRun, conf, tableObj.getSd().getBucketColsSize() > 0, null);
            }
        }
    }

    public static TableMigrationOption determineMigrationTypeAutomatically(org.apache.hadoop.hive.metastore.api.Table tableObj, TableType tableType, String ownerName, Configuration conf, IMetaStoreClient hms, Boolean isPathOwnedByHive) throws IOException, MetaException, TException {
        TableMigrationOption result = TableMigrationOption.NONE;
        switch (tableType) {
            case MANAGED_TABLE: {
                if (AcidUtils.isTransactionalTable(tableObj)) {
                    result = TableMigrationOption.MANAGED;
                    break;
                }
                String reason = HiveStrictManagedMigration.shouldTableBeExternal(tableObj, ownerName, conf, hms, isPathOwnedByHive);
                if (reason != null) {
                    LOG.debug("Converting {} to external table. {}", (Object)HiveStrictManagedMigration.getQualifiedName(tableObj), (Object)reason);
                    result = TableMigrationOption.EXTERNAL;
                    break;
                }
                result = TableMigrationOption.MANAGED;
                break;
            }
            case EXTERNAL_TABLE: {
                String msg = String.format("Table %s is already an external table, not processing.", HiveStrictManagedMigration.getQualifiedName(tableObj));
                LOG.debug(msg);
                result = TableMigrationOption.NONE;
                break;
            }
            default: {
                String msg = String.format("Ignoring table %s because it has table type %s", new Object[]{HiveStrictManagedMigration.getQualifiedName(tableObj), tableType});
                LOG.debug(msg);
                result = TableMigrationOption.NONE;
            }
        }
        return result;
    }

    static boolean migrateToExternalTable(org.apache.hadoop.hive.metastore.api.Table tableObj, TableType tableType, boolean dryRun, HiveUpdater hiveUpdater) throws HiveException {
        switch (tableType) {
            case MANAGED_TABLE: {
                if (AcidUtils.isTransactionalTable(tableObj)) {
                    String msg = HiveStrictManagedMigration.createExternalConversionExcuse(tableObj, "Table is a transactional table");
                    LOG.debug(msg);
                    return false;
                }
                LOG.info("Converting {} to external table ...", (Object)HiveStrictManagedMigration.getQualifiedName(tableObj));
                if (!dryRun) {
                    tableObj.setTableType(TableType.EXTERNAL_TABLE.toString());
                    hiveUpdater.updateTableProperties(tableObj, convertToExternalTableProps);
                }
                return true;
            }
            case EXTERNAL_TABLE: {
                String msg = HiveStrictManagedMigration.createExternalConversionExcuse(tableObj, "Table is already an external table");
                LOG.debug(msg);
                break;
            }
            default: {
                String msg = HiveStrictManagedMigration.createExternalConversionExcuse(tableObj, "Table type " + (Object)((Object)tableType) + " cannot be converted");
                LOG.debug(msg);
            }
        }
        return false;
    }

    static boolean canTableBeFullAcid(org.apache.hadoop.hive.metastore.api.Table tableObj) throws MetaException {
        return TransactionalValidationListener.conformToAcid(tableObj) && tableObj.getSd().getSortColsSize() <= 0;
    }

    static Map<String, String> getTablePropsForConversionToTransactional(Map<String, String> props, boolean convertFromExternal) {
        if (convertFromExternal) {
            props = new HashMap<String, String>(props);
            props.put("EXTERNAL", "FALSE");
        }
        return props;
    }

    static boolean migrateToManagedTable(org.apache.hadoop.hive.metastore.api.Table tableObj, TableType tableType, boolean dryRun, HiveUpdater hiveUpdater, IMetaStoreClient hms, Configuration conf) throws HiveException, IOException, MetaException, TException {
        boolean convertFromExternal = false;
        switch (tableType) {
            case EXTERNAL_TABLE: {
                convertFromExternal = true;
            }
            case MANAGED_TABLE: {
                if (MetaStoreUtils.isNonNativeTable(tableObj)) {
                    String msg = HiveStrictManagedMigration.createManagedConversionExcuse(tableObj, "Table is a non-native (StorageHandler) table");
                    LOG.debug(msg);
                    return false;
                }
                if (HiveStrictManagedUtils.isAvroTableWithExternalSchema(tableObj)) {
                    String msg = HiveStrictManagedMigration.createManagedConversionExcuse(tableObj, "Table is an Avro table with an external schema url");
                    LOG.debug(msg);
                    return false;
                }
                if (HiveStrictManagedUtils.isListBucketedTable(tableObj)) {
                    String msg = HiveStrictManagedMigration.createManagedConversionExcuse(tableObj, "Table is a list bucketed table");
                    LOG.debug(msg);
                    return false;
                }
                if (AcidUtils.isTransactionalTable(tableObj)) {
                    String msg = HiveStrictManagedMigration.createManagedConversionExcuse(tableObj, "Table is already a transactional table");
                    LOG.debug(msg);
                    return false;
                }
                if (HiveStrictManagedMigration.canTableBeFullAcid(tableObj)) {
                    LOG.info("Converting {} to full transactional table", (Object)HiveStrictManagedMigration.getQualifiedName(tableObj));
                    if (hiveUpdater.doFileRename) {
                        HiveStrictManagedMigration.renameFilesToConformToAcid(tableObj, hms, conf, dryRun);
                    }
                    if (!dryRun) {
                        Map<String, String> props = HiveStrictManagedMigration.getTablePropsForConversionToTransactional(convertToAcidTableProps, convertFromExternal);
                        hiveUpdater.updateTableProperties(tableObj, props);
                    }
                    return true;
                }
                LOG.info("Converting {} to insert-only transactional table", (Object)HiveStrictManagedMigration.getQualifiedName(tableObj));
                if (!dryRun) {
                    Map<String, String> props = HiveStrictManagedMigration.getTablePropsForConversionToTransactional(convertToMMTableProps, convertFromExternal);
                    hiveUpdater.updateTableProperties(tableObj, props);
                }
                return true;
            }
        }
        String msg = HiveStrictManagedMigration.createManagedConversionExcuse(tableObj, "Table type " + (Object)((Object)tableType) + " cannot be converted");
        LOG.debug(msg);
        return false;
    }

    static String shouldTableBeExternal(org.apache.hadoop.hive.metastore.api.Table tableObj, String ownerName, Configuration conf, IMetaStoreClient hms, Boolean isPathOwnedByHive) throws IOException, MetaException, TException {
        if (MetaStoreUtils.isNonNativeTable(tableObj)) {
            return "Table is a non-native (StorageHandler) table";
        }
        if (HiveStrictManagedUtils.isAvroTableWithExternalSchema(tableObj)) {
            return "Table is an Avro table with an external schema url";
        }
        if (HiveStrictManagedUtils.isListBucketedTable(tableObj)) {
            return "Table is a list bucketed table";
        }
        if (isPathOwnedByHive != null) {
            return isPathOwnedByHive != false ? null : String.format("One or more table directories is not owned by hive or non-HDFS path at source cluster", new Object[0]);
        }
        if (HiveStrictManagedMigration.shouldTablePathBeExternal(tableObj, ownerName, conf, hms)) {
            return String.format("One or more table directories not owned by %s, or non-HDFS path", ownerName);
        }
        return null;
    }

    static boolean shouldTablePathBeExternal(org.apache.hadoop.hive.metastore.api.Table tableObj, String ownerName, Configuration conf, IMetaStoreClient hms) throws IOException, TException {
        boolean shouldBeExternal = false;
        String dbName = tableObj.getDbName();
        String tableName = tableObj.getTableName();
        if (!HiveStrictManagedMigration.isPartitionedTable(tableObj)) {
            boolean ownedByHive;
            Path tablePath = new Path(tableObj.getSd().getLocation());
            FileSystem fs = tablePath.getFileSystem(conf);
            shouldBeExternal = HiveStrictManagedMigration.isHdfs(fs) ? !(ownedByHive = HiveStrictManagedMigration.checkDirectoryOwnership(fs, tablePath, ownerName, true)) : true;
        } else {
            boolean ownedByHive;
            String partName;
            org.apache.hadoop.hive.metastore.api.Partition partObj;
            Path partPath;
            FileSystem fs;
            List<String> partNames = hms.listPartitionNames(dbName, tableName, (short)Short.MAX_VALUE);
            Iterator<String> iterator = partNames.iterator();
            while (iterator.hasNext() && !(shouldBeExternal = HiveStrictManagedMigration.isHdfs(fs = (partPath = new Path((partObj = hms.getPartition(dbName, tableName, partName = iterator.next())).getSd().getLocation())).getFileSystem(conf)) ? !(ownedByHive = HiveStrictManagedMigration.checkDirectoryOwnership(fs, partPath, ownerName, true)) : true)) {
            }
        }
        return shouldBeExternal;
    }

    void cleanup() {
        this.hms.close();
        if (this.hiveUpdater != null) {
            HiveStrictManagedMigration.runAndLogErrors(() -> this.hiveUpdater.close());
            this.hiveUpdater = null;
        }
    }

    public static HiveUpdater getHiveUpdater(HiveConf conf) throws HiveException {
        return new HiveUpdater(conf, false);
    }

    static void runAndLogErrors(ThrowableRunnable r) {
        try {
            r.run();
        }
        catch (Exception err) {
            LOG.error("Error encountered", (Throwable)err);
        }
    }

    static String createExternalConversionExcuse(org.apache.hadoop.hive.metastore.api.Table tableObj, String reason) {
        return String.format("Table %s cannot be converted to an external table in strict managed table mode for the following reason: %s", HiveStrictManagedMigration.getQualifiedName(tableObj), reason);
    }

    static String createManagedConversionExcuse(org.apache.hadoop.hive.metastore.api.Table tableObj, String reason) {
        return String.format("Table %s cannot be converted to a managed table in strict managed table mode for the following reason: %s", HiveStrictManagedMigration.getQualifiedName(tableObj), reason);
    }

    static boolean isPartitionedTable(org.apache.hadoop.hive.metastore.api.Table tableObj) {
        List<FieldSchema> partKeys = tableObj.getPartitionKeys();
        return partKeys != null && partKeys.size() > 0;
    }

    static boolean isHdfs(FileSystem fs) {
        return scheme.equals(fs.getScheme());
    }

    static String getQualifiedName(org.apache.hadoop.hive.metastore.api.Table tableObj) {
        return HiveStrictManagedMigration.getQualifiedName(tableObj.getDbName(), tableObj.getTableName());
    }

    static String getQualifiedName(String dbName, String tableName) {
        StringBuilder sb = new StringBuilder();
        sb.append('`');
        sb.append(dbName);
        sb.append("`.`");
        sb.append(tableName);
        sb.append('`');
        return sb.toString();
    }

    static boolean arePathsEqual(Configuration conf, String path1, String path2) throws IOException {
        String qualified1 = HiveStrictManagedMigration.getQualifiedPath(conf, new Path(path1));
        String qualified2 = HiveStrictManagedMigration.getQualifiedPath(conf, new Path(path2));
        return qualified1.equals(qualified2);
    }

    static String getQualifiedPath(Configuration conf, Path path) throws IOException {
        if (path == null) {
            return null;
        }
        FileSystem fs = path.getFileSystem(conf);
        return fs.makeQualified(path).toString();
    }

    static void checkAndSetFileOwnerPermissions(FileSystem fs, Path path, String userName, String groupName, FsPermission dirPerms, FsPermission filePerms, boolean dryRun, boolean recurse) throws IOException {
        FileStatus fStatus = HiveStrictManagedMigration.getFileStatus(fs, path);
        HiveStrictManagedMigration.checkAndSetFileOwnerPermissions(fs, fStatus, userName, groupName, dirPerms, filePerms, dryRun, recurse);
    }

    static void checkAndSetFileOwnerPermissions(FileSystem fs, FileStatus fStatus, String userName, String groupName, FsPermission dirPerms, FsPermission filePerms, boolean dryRun, boolean recurse) throws IOException {
        if (fStatus == null) {
            return;
        }
        Path path = fStatus.getPath();
        boolean setOwner = false;
        if (userName != null && !userName.equals(fStatus.getOwner())) {
            setOwner = true;
        } else if (groupName != null && !groupName.equals(fStatus.getGroup())) {
            setOwner = true;
        }
        boolean isDir = fStatus.isDirectory();
        boolean setPerms = false;
        FsPermission perms = filePerms;
        if (isDir) {
            perms = dirPerms;
        }
        if (perms != null && !perms.equals((Object)fStatus.getPermission())) {
            setPerms = true;
        }
        if (setOwner) {
            LOG.debug("Setting owner/group of {} to {}/{}", new Object[]{path, userName, groupName});
            if (!dryRun) {
                fs.setOwner(path, userName, groupName);
            }
        }
        if (setPerms) {
            LOG.debug("Setting perms of {} to {}", (Object)path, (Object)perms);
            if (!dryRun) {
                fs.setPermission(path, perms);
            }
        }
        if (isDir && recurse) {
            for (FileStatus subFile : fs.listStatus(path)) {
                HiveStrictManagedMigration.checkAndSetFileOwnerPermissions(fs, subFile, userName, groupName, dirPerms, filePerms, dryRun, recurse);
            }
        }
    }

    static boolean checkDirectoryOwnership(FileSystem fs, Path path, String userName, boolean recurse) throws IOException {
        FileStatus fStatus = HiveStrictManagedMigration.getFileStatus(fs, path);
        return HiveStrictManagedMigration.checkDirectoryOwnership(fs, fStatus, userName, recurse);
    }

    static boolean checkDirectoryOwnership(FileSystem fs, FileStatus fStatus, String userName, boolean recurse) throws IOException {
        if (fStatus == null) {
            return true;
        }
        Path path = fStatus.getPath();
        boolean result = true;
        boolean isDir = fStatus.isDirectory();
        if (isDir) {
            if (userName != null && !userName.equals(fStatus.getOwner())) {
                return false;
            }
            if (recurse) {
                for (FileStatus subFile : fs.listStatus(path)) {
                    if (HiveStrictManagedMigration.checkDirectoryOwnership(fs, subFile, userName, recurse)) continue;
                    return false;
                }
            }
        }
        return result;
    }

    static FileStatus getFileStatus(FileSystem fs, Path path) throws IOException {
        if (!fs.exists(path)) {
            return null;
        }
        return fs.getFileStatus(path);
    }

    static FileStatus[] listStatus(FileSystem fs, Path path) throws IOException {
        if (!fs.exists(path)) {
            return null;
        }
        return fs.listStatus(path);
    }

    static boolean hasEquivalentEncryption(HadoopShims.HdfsEncryptionShim encryptionShim, Path path1, Path path2) throws IOException {
        return !encryptionShim.isPathEncrypted(path1) && !encryptionShim.isPathEncrypted(path2) || encryptionShim.arePathsOnSameEncryptionZone(path1, path2);
    }

    static boolean hasEquivalentErasureCodingPolicy(HadoopShims.HdfsErasureCodingShim ecShim, Path path1, Path path2) throws IOException {
        HadoopShims.HdfsFileErasureCodingPolicy policy1 = ecShim.getErasureCodingPolicy(path1);
        HadoopShims.HdfsFileErasureCodingPolicy policy2 = ecShim.getErasureCodingPolicy(path2);
        if (policy1 != null) {
            return policy1.equals(policy2);
        }
        return policy2 == null;
    }

    static {
        convertToExternalTableProps.put("EXTERNAL", "TRUE");
        convertToExternalTableProps.put("external.table.purge", "true");
        convertToAcidTableProps.put("transactional", "true");
        convertToMMTableProps.put("transactional", "true");
        convertToMMTableProps.put("transactional_properties", "insert_only");
        hiveConf = null;
        scheme = "hdfs";
    }

    static interface ThrowableRunnable {
        public void run() throws Exception;
    }

    private static class HiveUpdater
    implements AutoCloseable {
        Hive hive;
        boolean doFileRename;

        HiveUpdater(HiveConf conf, boolean fileRename) throws HiveException {
            this.hive = Hive.get(conf);
            Hive.set(this.hive);
            this.doFileRename = fileRename;
        }

        @Override
        public void close() {
            if (this.hive != null) {
                HiveStrictManagedMigration.runAndLogErrors(Hive::closeCurrent);
                this.hive = null;
            }
        }

        void updateDbLocation(Database db, Path newLocation) throws HiveException {
            String msg = String.format("ALTER DATABASE %s SET LOCATION '%s'", db.getName(), newLocation);
            LOG.info(msg);
            db.setLocationUri(newLocation.toString());
            this.hive.alterDatabase(db.getName(), db);
        }

        void updateTableLocation(org.apache.hadoop.hive.metastore.api.Table table, Path newLocation) throws HiveException {
            String msg = String.format("ALTER TABLE %s SET LOCATION '%s'", HiveStrictManagedMigration.getQualifiedName(table), newLocation);
            LOG.info(msg);
            boolean isTxn = TxnUtils.isTransactionalTable(table);
            Table modifiedTable = new Table(table);
            modifiedTable.setDataLocation(newLocation);
            this.alterTableInternal(isTxn, table, modifiedTable);
        }

        private void alterTableInternal(boolean wasTxn, org.apache.hadoop.hive.metastore.api.Table table, Table modifiedTable) throws HiveException {
            IMetaStoreClient msc = this.getMSC();
            TxnCtx txnCtx = this.generateTxnCtxForAlter(table, msc, wasTxn);
            boolean isOk = false;
            try {
                String validWriteIds = null;
                if (txnCtx != null) {
                    validWriteIds = txnCtx.validWriteIds;
                    modifiedTable.getTTable().setWriteId(txnCtx.writeId);
                }
                msc.alter_table(table.getCatName(), table.getDbName(), table.getTableName(), modifiedTable.getTTable(), null, validWriteIds);
                isOk = true;
            }
            catch (TException ex) {
                throw new HiveException(ex);
            }
            finally {
                this.closeTxnCtx(txnCtx, msc, isOk);
            }
        }

        private void alterPartitionInternal(org.apache.hadoop.hive.metastore.api.Table table, Partition modifiedPart) throws HiveException {
            IMetaStoreClient msc = this.getMSC();
            TxnCtx txnCtx = this.generateTxnCtxForAlter(table, msc, null);
            boolean isOk = false;
            try {
                String validWriteIds = null;
                if (txnCtx != null) {
                    validWriteIds = txnCtx.validWriteIds;
                    modifiedPart.getTPartition().setWriteId(txnCtx.writeId);
                }
                msc.alter_partition(table.getCatName(), table.getDbName(), table.getTableName(), modifiedPart.getTPartition(), null, validWriteIds);
                isOk = true;
            }
            catch (TException ex) {
                throw new HiveException(ex);
            }
            finally {
                this.closeTxnCtx(txnCtx, msc, isOk);
            }
        }

        private IMetaStoreClient getMSC() throws HiveException {
            try {
                return this.hive.getMSC();
            }
            catch (MetaException ex) {
                throw new HiveException(ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private TxnCtx generateTxnCtxForAlter(org.apache.hadoop.hive.metastore.api.Table table, IMetaStoreClient msc, Boolean wasTxn) throws HiveException {
            if (wasTxn != null && !wasTxn.booleanValue() || !TxnUtils.isTransactionalTable(table.getParameters())) {
                return null;
            }
            try {
                UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
                long txnId = msc.openTxn(ugi == null ? "anonymous" : ugi.getShortUserName());
                TxnCtx result = null;
                try {
                    ValidTxnList txns = msc.getValidTxns(txnId);
                    String fqn = table.getDbName() + "." + table.getTableName();
                    List<TableValidWriteIds> writeIdsObj = msc.getValidWriteIds(Lists.newArrayList(fqn), txns.toString());
                    String validWriteIds = TxnUtils.createValidTxnWriteIdList(txnId, writeIdsObj).getTableValidWriteIdList(fqn).writeToString();
                    long writeId = msc.allocateTableWriteId(txnId, table.getDbName(), table.getTableName());
                    result = new TxnCtx(writeId, validWriteIds, txnId);
                    if (result != null) return result;
                }
                catch (Throwable throwable) {
                    if (result != null) throw throwable;
                    msc.abortTxns(Lists.newArrayList(txnId));
                    throw throwable;
                }
                msc.abortTxns(Lists.newArrayList(txnId));
                return result;
            }
            catch (IOException | TException ex) {
                throw new HiveException(ex);
            }
        }

        private void closeTxnCtx(TxnCtx txnCtx, IMetaStoreClient msc, boolean isOk) throws HiveException {
            if (txnCtx == null) {
                return;
            }
            try {
                if (isOk) {
                    msc.commitTxn(txnCtx.txnId);
                } else {
                    msc.abortTxns(Lists.newArrayList(txnCtx.txnId));
                }
            }
            catch (TException ex) {
                throw new HiveException(ex);
            }
        }

        void updatePartitionLocation(String dbName, org.apache.hadoop.hive.metastore.api.Table table, String partName, org.apache.hadoop.hive.metastore.api.Partition part, Path newLocation) throws HiveException, TException {
            String msg = String.format("ALTER TABLE %s PARTITION (%s) SET LOCATION '%s'", HiveStrictManagedMigration.getQualifiedName(table), partName, newLocation.toString());
            LOG.info(msg);
            Partition modifiedPart = new Partition(new Table(table), part);
            modifiedPart.setLocation(newLocation.toString());
            this.alterPartitionInternal(table, modifiedPart);
        }

        void updateTableProperties(org.apache.hadoop.hive.metastore.api.Table table, Map<String, String> props) throws HiveException {
            Table modifiedTable;
            StringBuilder sb = new StringBuilder();
            boolean isTxn = TxnUtils.isTransactionalTable(table);
            Table table2 = modifiedTable = this.doFileRename ? new Table(table) : null;
            if (props.size() == 0) {
                return;
            }
            boolean first = true;
            for (String key : props.keySet()) {
                String value = props.get(key);
                if (modifiedTable == null) {
                    table.getParameters().put(key, value);
                } else {
                    modifiedTable.getParameters().put(key, value);
                }
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append("'");
                sb.append(key);
                sb.append("'='");
                sb.append(value);
                sb.append("'");
            }
            String msg = String.format("ALTER TABLE %s SET TBLPROPERTIES (%s)", HiveStrictManagedMigration.getQualifiedName(table), sb.toString());
            LOG.info(msg);
            if (modifiedTable != null) {
                this.alterTableInternal(isTxn, table, modifiedTable);
            }
        }
    }

    private static final class TxnCtx {
        public final long writeId;
        public final String validWriteIds;
        public final long txnId;

        public TxnCtx(long writeId, String validWriteIds, long txnId) {
            this.writeId = writeId;
            this.txnId = txnId;
            this.validWriteIds = validWriteIds;
        }
    }

    private static class WarehouseRootCheckResult {
        final boolean shouldModifyManagedTableLocation;
        final boolean shouldMoveExternal;
        final Path targetPath;
        final HadoopShims.HdfsEncryptionShim encryptionShim;
        final HadoopShims.HdfsErasureCodingShim ecShim;

        WarehouseRootCheckResult(boolean shouldModifyManagedTableLocation, boolean shouldMoveExternal, Path curWhRootPath, HadoopShims.HdfsEncryptionShim encryptionShim, HadoopShims.HdfsErasureCodingShim ecShim) {
            this.shouldModifyManagedTableLocation = shouldModifyManagedTableLocation;
            this.shouldMoveExternal = shouldMoveExternal;
            this.targetPath = curWhRootPath;
            this.encryptionShim = encryptionShim;
            this.ecShim = ecShim;
        }
    }

    private static class OwnerPermsOptions {
        final String ownerName;
        final String groupName;
        final FsPermission dirPerms;
        final FsPermission filePerms;

        OwnerPermsOptions(String ownerName, String groupName, FsPermission dirPerms, FsPermission filePerms) {
            this.ownerName = ownerName;
            this.groupName = groupName;
            this.dirPerms = dirPerms;
            this.filePerms = filePerms;
        }
    }

    private static class RunOptions {
        final String dbRegex;
        final String tableRegex;
        final String oldWarehouseRoot;
        final TableMigrationOption migrationOption;
        final Properties confProps;
        boolean shouldModifyManagedTableLocation;
        final boolean shouldModifyManagedTableOwner;
        final boolean shouldModifyManagedTablePermissions;
        boolean shouldMoveExternal;
        final boolean dryRun;
        final TableType tableType;
        final int tablePoolSize;

        RunOptions(String dbRegex, String tableRegex, String oldWarehouseRoot, TableMigrationOption migrationOption, Properties confProps, boolean shouldModifyManagedTableLocation, boolean shouldModifyManagedTableOwner, boolean shouldModifyManagedTablePermissions, boolean shouldMoveExternal, boolean dryRun, TableType tableType, int tablePoolSize) {
            this.dbRegex = dbRegex;
            this.tableRegex = tableRegex;
            this.oldWarehouseRoot = oldWarehouseRoot;
            this.migrationOption = migrationOption;
            this.confProps = confProps;
            this.shouldModifyManagedTableLocation = shouldModifyManagedTableLocation;
            this.shouldModifyManagedTableOwner = shouldModifyManagedTableOwner;
            this.shouldModifyManagedTablePermissions = shouldModifyManagedTablePermissions;
            this.shouldMoveExternal = shouldMoveExternal;
            this.dryRun = dryRun;
            this.tableType = tableType;
            this.tablePoolSize = tablePoolSize;
        }

        public void setShouldModifyManagedTableLocation(boolean shouldModifyManagedTableLocation) {
            this.shouldModifyManagedTableLocation = shouldModifyManagedTableLocation;
        }

        public void setShouldMoveExternal(boolean shouldMoveExternal) {
            this.shouldMoveExternal = shouldMoveExternal;
        }

        public String toString() {
            return "RunOptions{dbRegex='" + this.dbRegex + '\'' + ", tableRegex='" + this.tableRegex + '\'' + ", oldWarehouseRoot='" + this.oldWarehouseRoot + '\'' + ", migrationOption=" + (Object)((Object)this.migrationOption) + ", confProps=" + this.confProps + ", shouldModifyManagedTableLocation=" + this.shouldModifyManagedTableLocation + ", shouldModifyManagedTableOwner=" + this.shouldModifyManagedTableOwner + ", shouldModifyManagedTablePermissions=" + this.shouldModifyManagedTablePermissions + ", shouldMoveExternal=" + this.shouldMoveExternal + ", dryRun=" + this.dryRun + ", tableType=" + (Object)((Object)this.tableType) + ", tablePoolSize=" + this.tablePoolSize + '}';
        }
    }

    public static enum TableMigrationOption {
        NONE,
        VALIDATE,
        AUTOMATIC,
        EXTERNAL,
        MANAGED;

    }
}

