/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.util;

import com.google.common.collect.ImmutableMap;
import org.apache.calcite.rel.RelFieldCollation;

public final class DirectionUtils {
    public static final int ASCENDING_CODE = 1;
    public static final int DESCENDING_CODE = 0;
    private static final ImmutableMap<String, Object> ASCENDING_DATA = ImmutableMap.of("code", 1, "sign", Character.valueOf('+'), "text", "ASC", "direction", RelFieldCollation.Direction.ASCENDING, "token", 1117);
    private static final ImmutableMap<String, Object> DESCENDING_DATA = ImmutableMap.of("code", 0, "sign", Character.valueOf('-'), "text", "DESC", "direction", RelFieldCollation.Direction.DESCENDING, "token", 1118);

    private DirectionUtils() {
        throw new UnsupportedOperationException("DirectionUtils should not be instantiated");
    }

    public static String codeToText(int code) {
        return (String)DirectionUtils.convert("code", code, "text");
    }

    public static char codeToSign(int code) {
        return ((Character)DirectionUtils.convert("code", code, "sign")).charValue();
    }

    public static int tokenToCode(int token) {
        return (Integer)DirectionUtils.convert("token", token, "code");
    }

    public static int signToCode(char sign) {
        return (Integer)DirectionUtils.convert("sign", Character.valueOf(sign), "code");
    }

    public static RelFieldCollation.Direction codeToDirection(int code) {
        return (RelFieldCollation.Direction)DirectionUtils.convert("code", code, "direction");
    }

    private static Object convert(String typeFrom, Object value, String typeTo) {
        Object ascObject = ASCENDING_DATA.get(typeFrom);
        Object descObject = DESCENDING_DATA.get(typeFrom);
        if (ascObject.equals(value)) {
            return ASCENDING_DATA.get(typeTo);
        }
        if (descObject.equals(value)) {
            return DESCENDING_DATA.get(typeTo);
        }
        throw new IllegalArgumentException("The value " + value + " isn not a valid value for " + typeFrom);
    }
}

