/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.util;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;

public class DateTimeMath {
    protected Calendar calUtc = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
    protected NanosResult nanosResult = new NanosResult();

    public long addMonthsToMillis(long millis, int months) {
        this.calUtc.setTimeInMillis(millis);
        this.calUtc.add(2, months);
        return this.calUtc.getTimeInMillis();
    }

    public long addMonthsToNanos(long nanos, int months) {
        long result = this.addMonthsToMillis(nanos / 1000000L, months) * 1000000L + nanos % 1000000L;
        return result;
    }

    public long addMonthsToDays(long days, int months) {
        long millis = DateWritableV2.daysToMillis((int)days);
        millis = this.addMonthsToMillis(millis, months);
        return DateWritableV2.millisToDays(millis);
    }

    public org.apache.hadoop.hive.common.type.Timestamp add(org.apache.hadoop.hive.common.type.Timestamp ts, HiveIntervalYearMonth interval) {
        if (ts == null || interval == null) {
            return null;
        }
        org.apache.hadoop.hive.common.type.Timestamp tsResult = new org.apache.hadoop.hive.common.type.Timestamp();
        this.add(ts, interval, tsResult);
        return tsResult;
    }

    @Deprecated
    public Timestamp add(Timestamp ts, HiveIntervalYearMonth interval) {
        if (ts == null || interval == null) {
            return null;
        }
        Timestamp tsResult = new Timestamp(0L);
        this.add(ts, interval, tsResult);
        return tsResult;
    }

    public boolean add(org.apache.hadoop.hive.common.type.Timestamp ts, HiveIntervalYearMonth interval, org.apache.hadoop.hive.common.type.Timestamp result) {
        if (ts == null || interval == null) {
            return false;
        }
        long resultMillis = this.addMonthsToMillis(ts.toEpochMilli(), interval.getTotalMonths());
        result.setTimeInMillis(resultMillis, ts.getNanos());
        return true;
    }

    @Deprecated
    public boolean add(Timestamp ts, HiveIntervalYearMonth interval, Timestamp result) {
        if (ts == null || interval == null) {
            return false;
        }
        long resultMillis = this.addMonthsToMillis(ts.getTime(), interval.getTotalMonths());
        result.setTime(resultMillis);
        result.setNanos(ts.getNanos());
        return true;
    }

    public org.apache.hadoop.hive.common.type.Timestamp add(HiveIntervalYearMonth interval, org.apache.hadoop.hive.common.type.Timestamp ts) {
        if (ts == null || interval == null) {
            return null;
        }
        org.apache.hadoop.hive.common.type.Timestamp tsResult = new org.apache.hadoop.hive.common.type.Timestamp();
        this.add(interval, ts, tsResult);
        return tsResult;
    }

    @Deprecated
    public Timestamp add(HiveIntervalYearMonth interval, Timestamp ts) {
        if (ts == null || interval == null) {
            return null;
        }
        Timestamp tsResult = new Timestamp(0L);
        this.add(interval, ts, tsResult);
        return tsResult;
    }

    public boolean add(HiveIntervalYearMonth interval, org.apache.hadoop.hive.common.type.Timestamp ts, org.apache.hadoop.hive.common.type.Timestamp result) {
        if (ts == null || interval == null) {
            return false;
        }
        long resultMillis = this.addMonthsToMillis(ts.toEpochMilli(), interval.getTotalMonths());
        result.setTimeInMillis(resultMillis, ts.getNanos());
        return true;
    }

    @Deprecated
    public boolean add(HiveIntervalYearMonth interval, Timestamp ts, Timestamp result) {
        if (ts == null || interval == null) {
            return false;
        }
        long resultMillis = this.addMonthsToMillis(ts.getTime(), interval.getTotalMonths());
        result.setTime(resultMillis);
        result.setNanos(ts.getNanos());
        return true;
    }

    public org.apache.hadoop.hive.common.type.Date add(org.apache.hadoop.hive.common.type.Date dt, HiveIntervalYearMonth interval) {
        if (dt == null || interval == null) {
            return null;
        }
        org.apache.hadoop.hive.common.type.Date dtResult = new org.apache.hadoop.hive.common.type.Date();
        this.add(dt, interval, dtResult);
        return dtResult;
    }

    @Deprecated
    public java.sql.Date add(java.sql.Date dt, HiveIntervalYearMonth interval) {
        if (dt == null || interval == null) {
            return null;
        }
        java.sql.Date dtResult = new java.sql.Date(0L);
        this.add(dt, interval, dtResult);
        return dtResult;
    }

    public boolean add(org.apache.hadoop.hive.common.type.Date dt, HiveIntervalYearMonth interval, org.apache.hadoop.hive.common.type.Date result) {
        if (dt == null || interval == null) {
            return false;
        }
        long resultMillis = this.addMonthsToMillis(dt.toEpochMilli(), interval.getTotalMonths());
        result.setTimeInMillis(resultMillis);
        return true;
    }

    @Deprecated
    public boolean add(java.sql.Date dt, HiveIntervalYearMonth interval, java.sql.Date result) {
        if (dt == null || interval == null) {
            return false;
        }
        long resultMillis = this.addMonthsToMillis(dt.getTime(), interval.getTotalMonths());
        result.setTime(resultMillis);
        return true;
    }

    public org.apache.hadoop.hive.common.type.Date add(HiveIntervalYearMonth interval, org.apache.hadoop.hive.common.type.Date dt) {
        if (dt == null || interval == null) {
            return null;
        }
        org.apache.hadoop.hive.common.type.Date dtResult = new org.apache.hadoop.hive.common.type.Date();
        this.add(interval, dt, dtResult);
        return dtResult;
    }

    @Deprecated
    public java.sql.Date add(HiveIntervalYearMonth interval, java.sql.Date dt) {
        if (dt == null || interval == null) {
            return null;
        }
        java.sql.Date dtResult = new java.sql.Date(0L);
        this.add(interval, dt, dtResult);
        return dtResult;
    }

    public boolean add(HiveIntervalYearMonth interval, org.apache.hadoop.hive.common.type.Date dt, org.apache.hadoop.hive.common.type.Date result) {
        if (dt == null || interval == null) {
            return false;
        }
        long resultMillis = this.addMonthsToMillis(dt.toEpochMilli(), interval.getTotalMonths());
        result.setTimeInMillis(resultMillis);
        return true;
    }

    @Deprecated
    public boolean add(HiveIntervalYearMonth interval, java.sql.Date dt, java.sql.Date result) {
        if (dt == null || interval == null) {
            return false;
        }
        long resultMillis = this.addMonthsToMillis(dt.getTime(), interval.getTotalMonths());
        result.setTime(resultMillis);
        return true;
    }

    public HiveIntervalYearMonth add(HiveIntervalYearMonth left, HiveIntervalYearMonth right) {
        HiveIntervalYearMonth result = null;
        if (left == null || right == null) {
            return null;
        }
        result = new HiveIntervalYearMonth(left.getTotalMonths() + right.getTotalMonths());
        return result;
    }

    public org.apache.hadoop.hive.common.type.Timestamp subtract(org.apache.hadoop.hive.common.type.Timestamp left, HiveIntervalYearMonth right) {
        if (left == null || right == null) {
            return null;
        }
        org.apache.hadoop.hive.common.type.Timestamp tsResult = new org.apache.hadoop.hive.common.type.Timestamp();
        this.subtract(left, right, tsResult);
        return tsResult;
    }

    @Deprecated
    public Timestamp subtract(Timestamp left, HiveIntervalYearMonth right) {
        if (left == null || right == null) {
            return null;
        }
        Timestamp tsResult = new Timestamp(0L);
        this.subtract(left, right, tsResult);
        return tsResult;
    }

    public boolean subtract(org.apache.hadoop.hive.common.type.Timestamp left, HiveIntervalYearMonth right, org.apache.hadoop.hive.common.type.Timestamp result) {
        if (left == null || right == null) {
            return false;
        }
        return this.add(left, right.negate(), result);
    }

    @Deprecated
    public boolean subtract(Timestamp left, HiveIntervalYearMonth right, Timestamp result) {
        if (left == null || right == null) {
            return false;
        }
        return this.add(left, right.negate(), result);
    }

    public org.apache.hadoop.hive.common.type.Date subtract(org.apache.hadoop.hive.common.type.Date left, HiveIntervalYearMonth right) {
        if (left == null || right == null) {
            return null;
        }
        org.apache.hadoop.hive.common.type.Date dtResult = new org.apache.hadoop.hive.common.type.Date();
        this.subtract(left, right, dtResult);
        return dtResult;
    }

    @Deprecated
    public java.sql.Date subtract(java.sql.Date left, HiveIntervalYearMonth right) {
        if (left == null || right == null) {
            return null;
        }
        java.sql.Date dtResult = new java.sql.Date(0L);
        this.subtract(left, right, dtResult);
        return dtResult;
    }

    public boolean subtract(org.apache.hadoop.hive.common.type.Date left, HiveIntervalYearMonth right, org.apache.hadoop.hive.common.type.Date result) {
        if (left == null || right == null) {
            return false;
        }
        return this.add(left, right.negate(), result);
    }

    @Deprecated
    public boolean subtract(java.sql.Date left, HiveIntervalYearMonth right, java.sql.Date result) {
        if (left == null || right == null) {
            return false;
        }
        return this.add(left, right.negate(), result);
    }

    public HiveIntervalYearMonth subtract(HiveIntervalYearMonth left, HiveIntervalYearMonth right) {
        if (left == null || right == null) {
            return null;
        }
        return this.add(left, right.negate());
    }

    public org.apache.hadoop.hive.common.type.Timestamp add(org.apache.hadoop.hive.common.type.Timestamp ts, HiveIntervalDayTime interval) {
        if (ts == null || interval == null) {
            return null;
        }
        org.apache.hadoop.hive.common.type.Timestamp tsResult = new org.apache.hadoop.hive.common.type.Timestamp();
        this.add(ts, interval, tsResult);
        return tsResult;
    }

    @Deprecated
    public Timestamp add(Timestamp ts, HiveIntervalDayTime interval) {
        if (ts == null || interval == null) {
            return null;
        }
        Timestamp tsResult = new Timestamp(0L);
        this.add(ts, interval, tsResult);
        return tsResult;
    }

    public boolean add(org.apache.hadoop.hive.common.type.Timestamp ts, HiveIntervalDayTime interval, org.apache.hadoop.hive.common.type.Timestamp result) {
        if (ts == null || interval == null) {
            return false;
        }
        this.nanosResult.addNanos(ts.getNanos(), interval.getNanos());
        long newMillis = ts.toEpochMilli() + TimeUnit.SECONDS.toMillis(interval.getTotalSeconds() + (long)this.nanosResult.seconds);
        result.setTimeInMillis(newMillis, this.nanosResult.nanos);
        return true;
    }

    @Deprecated
    public boolean add(Timestamp ts, HiveIntervalDayTime interval, Timestamp result) {
        if (ts == null || interval == null) {
            return false;
        }
        this.nanosResult.addNanos(ts.getNanos(), interval.getNanos());
        long newMillis = ts.getTime() + TimeUnit.SECONDS.toMillis(interval.getTotalSeconds() + (long)this.nanosResult.seconds);
        result.setTime(newMillis);
        result.setNanos(this.nanosResult.nanos);
        return true;
    }

    public org.apache.hadoop.hive.common.type.Timestamp add(HiveIntervalDayTime interval, org.apache.hadoop.hive.common.type.Timestamp ts) {
        if (ts == null || interval == null) {
            return null;
        }
        org.apache.hadoop.hive.common.type.Timestamp tsResult = new org.apache.hadoop.hive.common.type.Timestamp();
        this.add(interval, ts, tsResult);
        return tsResult;
    }

    @Deprecated
    public Timestamp add(HiveIntervalDayTime interval, Timestamp ts) {
        if (ts == null || interval == null) {
            return null;
        }
        Timestamp tsResult = new Timestamp(0L);
        this.add(interval, ts, tsResult);
        return tsResult;
    }

    public boolean add(HiveIntervalDayTime interval, org.apache.hadoop.hive.common.type.Timestamp ts, org.apache.hadoop.hive.common.type.Timestamp result) {
        if (ts == null || interval == null) {
            return false;
        }
        this.nanosResult.addNanos(ts.getNanos(), interval.getNanos());
        long newMillis = ts.toEpochMilli() + TimeUnit.SECONDS.toMillis(interval.getTotalSeconds() + (long)this.nanosResult.seconds);
        result.setTimeInMillis(newMillis, this.nanosResult.nanos);
        return true;
    }

    @Deprecated
    public boolean add(HiveIntervalDayTime interval, Timestamp ts, Timestamp result) {
        if (ts == null || interval == null) {
            return false;
        }
        this.nanosResult.addNanos(ts.getNanos(), interval.getNanos());
        long newMillis = ts.getTime() + TimeUnit.SECONDS.toMillis(interval.getTotalSeconds() + (long)this.nanosResult.seconds);
        result.setTime(newMillis);
        result.setNanos(this.nanosResult.nanos);
        return true;
    }

    public HiveIntervalDayTime add(HiveIntervalDayTime left, HiveIntervalDayTime right) {
        if (left == null || right == null) {
            return null;
        }
        HiveIntervalDayTime result = new HiveIntervalDayTime();
        this.add(left, right, result);
        return result;
    }

    public boolean add(HiveIntervalDayTime left, HiveIntervalDayTime right, HiveIntervalDayTime result) {
        if (left == null || right == null) {
            return false;
        }
        this.nanosResult.addNanos(left.getNanos(), right.getNanos());
        long totalSeconds = left.getTotalSeconds() + right.getTotalSeconds() + (long)this.nanosResult.seconds;
        result.set(totalSeconds, this.nanosResult.nanos);
        return true;
    }

    public org.apache.hadoop.hive.common.type.Timestamp subtract(org.apache.hadoop.hive.common.type.Timestamp left, HiveIntervalDayTime right) {
        if (left == null || right == null) {
            return null;
        }
        return this.add(left, right.negate());
    }

    @Deprecated
    public Timestamp subtract(Timestamp left, HiveIntervalDayTime right) {
        if (left == null || right == null) {
            return null;
        }
        return this.add(left, right.negate());
    }

    public boolean subtract(org.apache.hadoop.hive.common.type.Timestamp left, HiveIntervalDayTime right, org.apache.hadoop.hive.common.type.Timestamp result) {
        if (left == null || right == null) {
            return false;
        }
        return this.add(left, right.negate(), result);
    }

    @Deprecated
    public boolean subtract(Timestamp left, HiveIntervalDayTime right, Timestamp result) {
        if (left == null || right == null) {
            return false;
        }
        return this.add(left, right.negate(), result);
    }

    public HiveIntervalDayTime subtract(HiveIntervalDayTime left, HiveIntervalDayTime right) {
        if (left == null || right == null) {
            return null;
        }
        return this.add(left, right.negate());
    }

    public boolean subtract(HiveIntervalDayTime left, HiveIntervalDayTime right, HiveIntervalDayTime result) {
        if (left == null || right == null) {
            return false;
        }
        return this.add(left, right.negate(), result);
    }

    public HiveIntervalDayTime subtract(org.apache.hadoop.hive.common.type.Timestamp left, org.apache.hadoop.hive.common.type.Timestamp right) {
        if (left == null || right == null) {
            return null;
        }
        HiveIntervalDayTime result = new HiveIntervalDayTime();
        this.subtract(left, right, result);
        return result;
    }

    @Deprecated
    public HiveIntervalDayTime subtract(Timestamp left, Timestamp right) {
        if (left == null || right == null) {
            return null;
        }
        HiveIntervalDayTime result = new HiveIntervalDayTime();
        this.subtract(left, right, result);
        return result;
    }

    public boolean subtract(org.apache.hadoop.hive.common.type.Timestamp left, org.apache.hadoop.hive.common.type.Timestamp right, HiveIntervalDayTime result) {
        if (left == null || right == null) {
            return false;
        }
        this.nanosResult.addNanos(left.getNanos(), -right.getNanos());
        long totalSeconds = TimeUnit.MILLISECONDS.toSeconds(left.toEpochMilli()) - TimeUnit.MILLISECONDS.toSeconds(right.toEpochMilli()) + (long)this.nanosResult.seconds;
        result.set(totalSeconds, this.nanosResult.nanos);
        return true;
    }

    @Deprecated
    public boolean subtract(Timestamp left, Timestamp right, HiveIntervalDayTime result) {
        if (left == null || right == null) {
            return false;
        }
        this.nanosResult.addNanos(left.getNanos(), -right.getNanos());
        long totalSeconds = TimeUnit.MILLISECONDS.toSeconds(left.getTime()) - TimeUnit.MILLISECONDS.toSeconds(right.getTime()) + (long)this.nanosResult.seconds;
        result.set(totalSeconds, this.nanosResult.nanos);
        return true;
    }

    public static Calendar getProlepticGregorianCalendarUTC() {
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC".intern()));
        calendar.setGregorianChange(new Date(Long.MIN_VALUE));
        return calendar;
    }

    private static class NanosResult {
        public int seconds;
        public int nanos;

        private NanosResult() {
        }

        public void addNanos(int leftNanos, int rightNanos) {
            this.seconds = 0;
            this.nanos = leftNanos + rightNanos;
            if (this.nanos < 0) {
                this.seconds = -1;
                this.nanos += 1000000000;
            } else if (this.nanos >= 1000000000) {
                this.seconds = 1;
                this.nanos -= 1000000000;
            }
        }
    }
}

