/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.util;

import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloseableThreadLocal<T extends AutoCloseable> {
    private static final Logger LOG = LoggerFactory.getLogger(CloseableThreadLocal.class);
    private final ConcurrentHashMap<Thread, T> threadLocalMap;
    private final Supplier<T> initialValue;

    public CloseableThreadLocal(Supplier<T> initialValue, int poolSize) {
        this.initialValue = initialValue;
        this.threadLocalMap = new ConcurrentHashMap(poolSize);
    }

    public T get() {
        return (T)this.threadLocalMap.computeIfAbsent(Thread.currentThread(), thread -> (AutoCloseable)this.initialValue.get());
    }

    public void close() {
        this.threadLocalMap.values().forEach(this::closeQuietly);
    }

    private void closeQuietly(AutoCloseable autoCloseable) {
        try {
            autoCloseable.close();
        }
        catch (Exception e) {
            LOG.warn("Error while closing resource.", (Throwable)e);
        }
    }
}

