/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.io.BucketCodec;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableLongObjectInspector;
import org.apache.hadoop.io.LongWritable;

@UDFType(stateful=true)
@Description(name="validate_acid_sort_order(ROW__ID.writeId, ROW__ID.bucketId, ROW__ID.rowId)", value="_FUNC_(writeId, bucketId, rowId) - returns 0 if the current row is in the right acid sort order compared to the previous row")
public class GenericUDFValidateAcidSortOrder
extends GenericUDF {
    public static final String UDF_NAME = "validate_acid_sort_order";
    private transient PrimitiveObjectInspector.PrimitiveCategory[] inputTypes = new PrimitiveObjectInspector.PrimitiveCategory[3];
    private transient ObjectInspectorConverters.Converter[] converters = new ObjectInspectorConverters.Converter[3];
    private final LongWritable output = new LongWritable();
    private int bucketNumForWriter = -1;
    private WriteIdRowId previousWriteIdRowId = null;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        this.checkArgsSize(arguments, 3, 3);
        this.checkArgPrimitive(arguments, 0);
        this.checkArgPrimitive(arguments, 1);
        this.checkArgPrimitive(arguments, 2);
        this.obtainLongConverter(arguments, 0, this.inputTypes, this.converters);
        this.obtainIntConverter(arguments, 1, this.inputTypes, this.converters);
        this.obtainLongConverter(arguments, 2, this.inputTypes, this.converters);
        WritableLongObjectInspector outputOI = PrimitiveObjectInspectorFactory.writableLongObjectInspector;
        return outputOI;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        long writeId = this.getLongValue(arguments, 0, this.converters);
        int bucketProperty = this.getIntValue(arguments, 1, this.converters);
        int bucketNum = BucketCodec.determineVersion(bucketProperty).decodeWriterId(bucketProperty);
        long rowId = this.getLongValue(arguments, 2, this.converters);
        if (this.bucketNumForWriter < 0) {
            this.bucketNumForWriter = bucketNum;
        } else if (this.bucketNumForWriter != bucketNum) {
            throw new HiveException("One writer is supposed to handle only one bucket. We saw these 2 different buckets: " + this.bucketNumForWriter + " and " + bucketNum);
        }
        WriteIdRowId current = new WriteIdRowId(bucketProperty, writeId, rowId);
        if (this.previousWriteIdRowId != null && current.compareTo(this.previousWriteIdRowId) <= 0) {
            throw new HiveException("Wrong sort order of Acid rows detected for the rows: " + this.previousWriteIdRowId + " and " + current);
        }
        this.previousWriteIdRowId = current;
        this.output.set(0L);
        return this.output;
    }

    @Override
    public String getDisplayString(String[] children) {
        return this.getStandardDisplayString(UDF_NAME, children);
    }

    static final class WriteIdRowId
    implements Comparable<WriteIdRowId> {
        final int bucketProperty;
        final long writeId;
        final long rowId;

        WriteIdRowId(int bucketProperty, long writeId, long rowId) {
            this.bucketProperty = bucketProperty;
            this.writeId = writeId;
            this.rowId = rowId;
        }

        @Override
        public int compareTo(WriteIdRowId other) {
            if (this.bucketProperty != other.bucketProperty) {
                return this.bucketProperty < other.bucketProperty ? -1 : 1;
            }
            if (this.writeId != other.writeId) {
                return this.writeId < other.writeId ? -1 : 1;
            }
            if (this.rowId != other.rowId) {
                return this.rowId < other.rowId ? -1 : 1;
            }
            return 0;
        }
    }
}

