/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedUDAFs;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFVarDecimal;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFVarDecimalComplete;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFVarDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFVarDoubleComplete;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFVarFinal;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFVarLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFVarLongComplete;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFVarPartial2;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFVarTimestamp;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFVarTimestampComplete;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFStd;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFStdSample;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFVarianceSample;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(name="variance,var_pop", value="_FUNC_(x) - Returns the variance of a set of numbers")
public class GenericUDAFVariance
extends AbstractGenericUDAFResolver {
    static final Logger LOG = LoggerFactory.getLogger((String)GenericUDAFVariance.class.getName());

    public static boolean isVarianceFamilyName(String name) {
        return VarianceKind.nameMap.get(name) != null;
    }

    public static boolean isVarianceNull(long count, VarianceKind varianceKind) {
        switch (varianceKind) {
            case VARIANCE: 
            case STANDARD_DEVIATION: {
                return count == 0L;
            }
            case VARIANCE_SAMPLE: 
            case STANDARD_DEVIATION_SAMPLE: {
                return count <= 1L;
            }
        }
        throw new RuntimeException("Unexpected variance kind " + (Object)((Object)varianceKind));
    }

    public static double calculateIntermediate(long count, double sum, double value, double variance) {
        double t = (double)count * value - sum;
        return variance += t * t / ((double)count * (double)(count - 1L));
    }

    public static double calculateMerge(long partialCount, long mergeCount, double partialSum, double mergeSum, double partialVariance, double mergeVariance) {
        double doublePartialCount = partialCount;
        double doubleMergeCount = mergeCount;
        double t = doublePartialCount / doubleMergeCount * mergeSum - partialSum;
        return mergeVariance += partialVariance + doubleMergeCount / doublePartialCount / (doubleMergeCount + doublePartialCount) * t * t;
    }

    public static double calculateVarianceFamilyResult(double variance, long count, VarianceKind varianceKind) {
        double result;
        switch (varianceKind) {
            case VARIANCE: {
                result = GenericUDAFVarianceEvaluator.calculateVarianceResult(variance, count);
                break;
            }
            case VARIANCE_SAMPLE: {
                result = GenericUDAFVarianceSample.GenericUDAFVarianceSampleEvaluator.calculateVarianceSampleResult(variance, count);
                break;
            }
            case STANDARD_DEVIATION: {
                result = GenericUDAFStd.GenericUDAFStdEvaluator.calculateStdResult(variance, count);
                break;
            }
            case STANDARD_DEVIATION_SAMPLE: {
                result = GenericUDAFStdSample.GenericUDAFStdSampleEvaluator.calculateStdSampleResult(variance, count);
                break;
            }
            default: {
                throw new RuntimeException("Unexpected variance kind " + (Object)((Object)varianceKind));
            }
        }
        return result;
    }

    @Override
    public GenericUDAFEvaluator getEvaluator(TypeInfo[] parameters) throws SemanticException {
        if (parameters.length != 1) {
            throw new UDFArgumentTypeException(parameters.length - 1, "Exactly one argument is expected.");
        }
        if (parameters[0].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(0, "Only primitive type arguments are accepted but " + parameters[0].getTypeName() + " is passed.");
        }
        switch (((PrimitiveTypeInfo)parameters[0]).getPrimitiveCategory()) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case STRING: 
            case VARCHAR: 
            case CHAR: 
            case TIMESTAMP: 
            case DECIMAL: {
                return new GenericUDAFVarianceEvaluator();
            }
        }
        throw new UDFArgumentTypeException(0, "Only numeric or string type arguments are accepted but " + parameters[0].getTypeName() + " is passed.");
    }

    @VectorizedUDAFs(value={VectorUDAFVarLong.class, VectorUDAFVarLongComplete.class, VectorUDAFVarDouble.class, VectorUDAFVarDoubleComplete.class, VectorUDAFVarDecimal.class, VectorUDAFVarDecimalComplete.class, VectorUDAFVarTimestamp.class, VectorUDAFVarTimestampComplete.class, VectorUDAFVarPartial2.class, VectorUDAFVarFinal.class})
    public static class GenericUDAFVarianceEvaluator
    extends GenericUDAFEvaluator {
        private transient PrimitiveObjectInspector inputOI;
        private transient StructObjectInspector soi;
        private transient StructField countField;
        private transient StructField sumField;
        private transient StructField varianceField;
        private LongObjectInspector countFieldOI;
        private DoubleObjectInspector sumFieldOI;
        private Object[] partialResult;
        private DoubleWritable result;
        private boolean warned = false;

        @Override
        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            assert (parameters.length == 1);
            super.init(m, parameters);
            if (this.mode == GenericUDAFEvaluator.Mode.PARTIAL1 || this.mode == GenericUDAFEvaluator.Mode.COMPLETE) {
                this.inputOI = (PrimitiveObjectInspector)parameters[0];
            } else {
                this.soi = (StructObjectInspector)parameters[0];
                this.countField = this.soi.getStructFieldRef("count");
                this.sumField = this.soi.getStructFieldRef("sum");
                this.varianceField = this.soi.getStructFieldRef("variance");
                this.countFieldOI = (LongObjectInspector)this.countField.getFieldObjectInspector();
                this.sumFieldOI = (DoubleObjectInspector)this.sumField.getFieldObjectInspector();
            }
            if (this.mode == GenericUDAFEvaluator.Mode.PARTIAL1 || this.mode == GenericUDAFEvaluator.Mode.PARTIAL2) {
                ArrayList<ObjectInspector> foi = new ArrayList<ObjectInspector>();
                foi.add(PrimitiveObjectInspectorFactory.writableLongObjectInspector);
                foi.add(PrimitiveObjectInspectorFactory.writableDoubleObjectInspector);
                foi.add(PrimitiveObjectInspectorFactory.writableDoubleObjectInspector);
                ArrayList<String> fname = new ArrayList<String>();
                fname.add("count");
                fname.add("sum");
                fname.add("variance");
                this.partialResult = new Object[3];
                this.partialResult[0] = new LongWritable(0L);
                this.partialResult[1] = new DoubleWritable(0.0);
                this.partialResult[2] = new DoubleWritable(0.0);
                return ObjectInspectorFactory.getStandardStructObjectInspector(fname, foi);
            }
            this.setResult(new DoubleWritable(0.0));
            return PrimitiveObjectInspectorFactory.writableDoubleObjectInspector;
        }

        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            StdAgg result = new StdAgg();
            this.reset(result);
            return result;
        }

        @Override
        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            StdAgg myagg = (StdAgg)agg;
            myagg.count = 0L;
            myagg.sum = 0.0;
            myagg.variance = 0.0;
        }

        @Override
        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            block5: {
                assert (parameters.length == 1);
                Object p = parameters[0];
                if (p != null) {
                    StdAgg myagg = (StdAgg)agg;
                    try {
                        double v = PrimitiveObjectInspectorUtils.getDouble(p, this.inputOI);
                        ++myagg.count;
                        myagg.sum += v;
                        if (myagg.count > 1L) {
                            myagg.variance = GenericUDAFVariance.calculateIntermediate(myagg.count, myagg.sum, v, myagg.variance);
                        }
                    }
                    catch (NumberFormatException e) {
                        if (this.warned) break block5;
                        this.warned = true;
                        LOG.warn(this.getClass().getSimpleName() + " " + StringUtils.stringifyException((Throwable)e));
                        LOG.warn(this.getClass().getSimpleName() + " ignoring similar exceptions.");
                    }
                }
            }
        }

        @Override
        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            StdAgg myagg = (StdAgg)agg;
            ((LongWritable)this.partialResult[0]).set(myagg.count);
            ((DoubleWritable)((Object)this.partialResult[1])).set(myagg.sum);
            ((DoubleWritable)((Object)this.partialResult[2])).set(myagg.variance);
            return this.partialResult;
        }

        @Override
        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            if (partial != null) {
                StdAgg myagg = (StdAgg)agg;
                Object partialCount = this.soi.getStructFieldData(partial, this.countField);
                Object partialSum = this.soi.getStructFieldData(partial, this.sumField);
                Object partialVariance = this.soi.getStructFieldData(partial, this.varianceField);
                long n = myagg.count;
                long m = this.countFieldOI.get(partialCount);
                if (n == 0L) {
                    myagg.variance = this.sumFieldOI.get(partialVariance);
                    myagg.count = this.countFieldOI.get(partialCount);
                    myagg.sum = this.sumFieldOI.get(partialSum);
                    return;
                }
                if (m != 0L && n != 0L) {
                    double a = myagg.sum;
                    double b = this.sumFieldOI.get(partialSum);
                    myagg.variance = GenericUDAFVariance.calculateMerge(m, n, b, a, this.sumFieldOI.get(partialVariance), myagg.variance);
                    myagg.count += m;
                    myagg.sum += b;
                }
            }
        }

        public static double calculateVarianceResult(double variance, long count) {
            double result = variance / (double)count;
            return result;
        }

        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            StdAgg myagg = (StdAgg)agg;
            if (myagg.count == 0L) {
                return null;
            }
            if (myagg.count > 1L) {
                this.getResult().set(GenericUDAFVarianceEvaluator.calculateVarianceResult(myagg.variance, myagg.count));
            } else {
                this.getResult().set(0.0);
            }
            return this.getResult();
        }

        public void setResult(DoubleWritable result) {
            this.result = result;
        }

        public DoubleWritable getResult() {
            return this.result;
        }

        @GenericUDAFEvaluator.AggregationType(estimable=true)
        static class StdAgg
        extends GenericUDAFEvaluator.AbstractAggregationBuffer {
            long count;
            double sum;
            double variance;

            StdAgg() {
            }

            @Override
            public int estimate() {
                return 24;
            }
        }
    }

    public static enum VarianceKind {
        NONE,
        VARIANCE,
        VARIANCE_SAMPLE,
        STANDARD_DEVIATION,
        STANDARD_DEVIATION_SAMPLE;

        public static final Map<String, VarianceKind> nameMap;

        static {
            nameMap = new HashMap<String, VarianceKind>();
            nameMap.put("variance", VARIANCE);
            nameMap.put("var_pop", VARIANCE);
            nameMap.put("var_samp", VARIANCE_SAMPLE);
            nameMap.put("std", STANDARD_DEVIATION);
            nameMap.put("stddev", STANDARD_DEVIATION);
            nameMap.put("stddev_pop", STANDARD_DEVIATION);
            nameMap.put("stddev_samp", STANDARD_DEVIATION_SAMPLE);
        }
    }
}

