/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import java.util.Calendar;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFWeekOfYearDate;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFWeekOfYearString;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFWeekOfYearTimestamp;
import org.apache.hadoop.hive.ql.udf.generic.NDV;
import org.apache.hadoop.hive.ql.util.DateTimeMath;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;

@Description(name="weekofyear", value="_FUNC_(date) - Returns the week of the year of the given date. A week is considered to start on a Monday and week 1 is the first week with >3 days.", extended="Examples:\n  > SELECT _FUNC_('2008-02-20') FROM src LIMIT 1;\n  8\n  > SELECT _FUNC_('1980-12-31 12:59:59') FROM src LIMIT 1;\n  1")
@VectorizedExpressions(value={VectorUDFWeekOfYearDate.class, VectorUDFWeekOfYearString.class, VectorUDFWeekOfYearTimestamp.class})
@NDV(maxNdv=52L)
public class UDFWeekOfYear
extends UDF {
    private final IntWritable result = new IntWritable();
    private final Calendar calendar = DateTimeMath.getProlepticGregorianCalendarUTC();

    public UDFWeekOfYear() {
        this.calendar.setFirstDayOfWeek(2);
        this.calendar.setMinimalDaysInFirstWeek(4);
    }

    public IntWritable evaluate(Text dateString) {
        if (dateString == null) {
            return null;
        }
        try {
            Date date = Date.valueOf(dateString.toString());
            this.calendar.setTimeInMillis(date.toEpochMilli());
            this.result.set(this.calendar.get(3));
            return this.result;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public IntWritable evaluate(DateWritableV2 d) {
        if (d == null) {
            return null;
        }
        Date date = d.get();
        this.calendar.setTimeInMillis(date.toEpochMilli());
        this.result.set(this.calendar.get(3));
        return this.result;
    }

    public IntWritable evaluate(TimestampWritableV2 t) {
        if (t == null) {
            return null;
        }
        Timestamp ts = t.getTimestamp();
        this.calendar.setTimeInMillis(ts.toEpochMilli());
        this.result.set(this.calendar.get(3));
        return this.result;
    }
}

