/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.common.ValidCompactorWriteIdList;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreUtils;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreThread;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TxnType;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.txn.CompactionInfo;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.processors.CommandProcessorException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.stats.StatsUtils;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorMR;
import org.apache.hadoop.hive.ql.txn.compactor.RemoteCompactorThread;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;
import org.apache.hive.common.util.Ref;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Worker
extends RemoteCompactorThread
implements MetaStoreThread {
    private static final String CLASS_NAME = Worker.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLASS_NAME);
    private static final long SLEEP_TIME = 10000L;
    private static final int NOT_SET = -1;
    private String workerName;
    private JobConf mrJob;

    public static String hostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOG.error("Unable to resolve my host name " + e.getMessage());
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        LOG.info("Starting Worker thread");
        do {
            boolean launchedJob;
            block49: {
                launchedJob = false;
                CompactionHeartbeater heartbeater = null;
                long compactorTxnId = -1L;
                CompactionInfo ci = null;
                try {
                    if (this.msc == null) {
                        this.msc = HiveMetaStoreUtils.getHiveMetastoreClient(this.conf);
                    }
                    ci = CompactionInfo.optionalCompactionInfoStructToInfo(this.msc.findNextCompact(this.workerName));
                    LOG.debug("Processing compaction request " + ci);
                    if (ci == null && !this.stop.get()) {
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException e) {
                            LOG.warn("Worker thread sleep interrupted " + e.getMessage());
                            this.commitTxnIfSet(compactorTxnId);
                            if (heartbeater == null) continue;
                            heartbeater.cancel();
                        }
                        continue;
                    }
                    Table t1 = null;
                    try {
                        t1 = this.resolveTable(ci);
                        if (t1 == null) {
                            LOG.info("Unable to find table " + ci.getFullTableName() + ", assuming it was dropped and moving on.");
                            this.msc.markCleaned(CompactionInfo.compactionInfoToStruct(ci));
                            continue;
                        }
                    }
                    catch (MetaException e) {
                        this.msc.markCleaned(CompactionInfo.compactionInfoToStruct(ci));
                        continue;
                    }
                    final Table t = t1;
                    Partition p = null;
                    try {
                        p = this.resolvePartition(ci);
                        if (p == null && ci.partName != null) {
                            LOG.info("Unable to find partition " + ci.getFullPartitionName() + ", assuming it was dropped and moving on.");
                            this.msc.markCleaned(CompactionInfo.compactionInfoToStruct(ci));
                            continue;
                        }
                    }
                    catch (Exception e) {
                        this.msc.markCleaned(CompactionInfo.compactionInfoToStruct(ci));
                        continue;
                    }
                    final StorageDescriptor sd = this.resolveStorageDescriptor(t, p);
                    if (sd.getSortCols() != null && !sd.getSortCols().isEmpty()) {
                        LOG.error("Attempt to compact sorted table, which is not yet supported!");
                        this.msc.markCleaned(CompactionInfo.compactionInfoToStruct(ci));
                        continue;
                    }
                    String fullTableName = TxnUtils.getFullTableName(t.getDbName(), t.getTableName());
                    if (ci.runAs == null) {
                        ci.runAs = this.findUserToRunAs(sd.getLocation(), t);
                    }
                    compactorTxnId = this.msc.openTxn(ci.runAs, TxnType.COMPACTION);
                    heartbeater = new CompactionHeartbeater(compactorTxnId, fullTableName, this.conf);
                    heartbeater.start();
                    ValidTxnList validTxnList = this.msc.getValidTxns(compactorTxnId);
                    final ValidCompactorWriteIdList tblValidWriteIds = TxnUtils.createValidCompactWriteIdList(this.msc.getValidWriteIds(Collections.singletonList(fullTableName), validTxnList.writeToString()).get(0));
                    LOG.debug("ValidCompactWriteIdList: " + tblValidWriteIds.writeToString());
                    this.conf.set("hive.txn.valid.txns", validTxnList.writeToString());
                    ci.highestWriteId = tblValidWriteIds.getHighWatermark();
                    this.msc.updateCompactorState(CompactionInfo.compactionInfoToStruct(ci), compactorTxnId);
                    final StringBuilder jobName = new StringBuilder(this.workerName);
                    jobName.append("-compactor-");
                    jobName.append(ci.getFullPartitionName());
                    final AcidUtils.Directory dir = AcidUtils.getAcidState(null, new Path(sd.getLocation()), this.conf, tblValidWriteIds, Ref.from(false), true, null, false);
                    if (!Worker.isEnoughToCompact(ci.isMajorCompaction(), dir, sd)) {
                        if (Worker.needsCleaning(dir, sd)) {
                            this.msc.markCompacted(CompactionInfo.compactionInfoToStruct(ci));
                            continue;
                        }
                        this.msc.markCleaned(CompactionInfo.compactionInfoToStruct(ci));
                        continue;
                    }
                    LOG.info("Starting " + ci.type.toString() + " compaction for " + ci.getFullPartitionName() + " in " + JavaUtils.txnIdToString(compactorTxnId));
                    final StatsUpdater su = StatsUpdater.init(ci, this.msc.findColumnsWithStats(CompactionInfo.compactionInfoToStruct(ci)), this.conf, this.runJobAsSelf(ci.runAs) ? ci.runAs : t.getOwner());
                    final CompactorMR mr = new CompactorMR();
                    launchedJob = true;
                    try {
                        if (this.runJobAsSelf(ci.runAs)) {
                            mr.run(this.conf, jobName.toString(), t, p, sd, tblValidWriteIds, ci, su, this.msc, dir);
                        } else {
                            UserGroupInformation ugi = UserGroupInformation.createProxyUser((String)t.getOwner(), (UserGroupInformation)UserGroupInformation.getLoginUser());
                            final Partition fp = p;
                            final CompactionInfo fci = ci;
                            ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                                @Override
                                public Object run() throws Exception {
                                    mr.run(Worker.this.conf, jobName.toString(), t, fp, sd, tblValidWriteIds, fci, su, Worker.this.msc, dir);
                                    return null;
                                }
                            });
                            try {
                                FileSystem.closeAllForUGI((UserGroupInformation)ugi);
                            }
                            catch (IOException exception) {
                                LOG.error("Could not clean up file-system handles for UGI: " + ugi + " for " + ci.getFullPartitionName(), (Throwable)exception);
                            }
                        }
                        heartbeater.cancel();
                        this.msc.markCompacted(CompactionInfo.compactionInfoToStruct(ci));
                        if (this.conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST)) {
                            this.mrJob = mr.getMrJob();
                        }
                        break block49;
                    }
                    catch (Exception e) {
                        LOG.error("Caught exception while trying to compact " + ci + ".  Marking failed to avoid repeated failures, " + StringUtils.stringifyException((Throwable)e));
                        ci.errorMessage = e.getMessage();
                        this.msc.markFailed(CompactionInfo.compactionInfoToStruct(ci));
                        this.msc.abortTxns(Collections.singletonList(compactorTxnId));
                        compactorTxnId = -1L;
                    }
                    break block49;
                    {
                        catch (IOException | TException t2) {
                            LOG.error("Caught an exception in the main loop of compactor worker " + this.workerName + ", " + StringUtils.stringifyException((Throwable)t2));
                            try {
                                if (this.msc != null && ci != null) {
                                    ci.errorMessage = t2.getMessage();
                                    this.msc.markFailed(CompactionInfo.compactionInfoToStruct(ci));
                                    compactorTxnId = -1L;
                                }
                            }
                            catch (TException e) {
                                LOG.error("Caught an exception while trying to mark compaction {} as failed: {}", (Object)ci, (Object)e);
                            }
                            finally {
                                if (this.msc != null) {
                                    this.msc.close();
                                    this.msc = null;
                                }
                            }
                            try {
                                Thread.sleep(10000L);
                            }
                            catch (InterruptedException e) {
                                LOG.error("Interrupted while sleeping to instantiate metastore client");
                            }
                            break block49;
                        }
                        catch (Throwable t3) {
                            LOG.error("Caught an exception in the main loop of compactor worker " + this.workerName + ", " + StringUtils.stringifyException((Throwable)t3));
                            compactorTxnId = -1L;
                            break block49;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    this.commitTxnIfSet(compactorTxnId);
                    if (heartbeater != null) {
                        heartbeater.cancel();
                    }
                }
            }
            if (launchedJob || this.stop.get()) continue;
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (!this.stop.get());
    }

    private void commitTxnIfSet(long compactorTxnId) {
        if (compactorTxnId != -1L) {
            try {
                if (this.msc != null) {
                    this.msc.commitTxn(compactorTxnId);
                }
            }
            catch (TException e) {
                LOG.error("Caught an exception while committing compaction in worker " + this.workerName + ", " + StringUtils.stringifyException((Throwable)e));
            }
        }
    }

    @Override
    public void init(AtomicBoolean stop, AtomicBoolean looped) throws Exception {
        super.init(stop, looped);
        StringBuilder name = new StringBuilder(Worker.hostname());
        name.append("-");
        name.append(this.getId());
        this.workerName = name.toString();
        this.setName(name.toString());
    }

    public JobConf getMrJob() {
        return this.mrJob;
    }

    static boolean isEnoughToCompact(boolean isMajorCompaction, AcidUtils.Directory dir, StorageDescriptor sd) {
        boolean isEnoughToCompact;
        int deltaCount = dir.getCurrentDirectories().size();
        int origCount = dir.getOriginalFiles().size();
        StringBuilder deltaInfo = new StringBuilder().append(deltaCount);
        if (isMajorCompaction) {
            isEnoughToCompact = origCount > 0 || deltaCount + (dir.getBaseDirectory() == null ? 0 : 1) > 1;
        } else {
            boolean bl = isEnoughToCompact = deltaCount > 1;
            if (deltaCount == 2) {
                Map<String, Long> deltaByType = dir.getCurrentDirectories().stream().collect(Collectors.groupingBy(delta -> delta.isDeleteDelta() ? "delete_delta_" : "delta_", Collectors.counting()));
                isEnoughToCompact = deltaByType.size() != deltaCount;
                deltaInfo.append(" ").append(deltaByType);
            }
        }
        if (!isEnoughToCompact) {
            LOG.debug("Not compacting {}; current base: {}, delta files: {}, originals: {}", new Object[]{sd.getLocation(), dir.getBaseDirectory(), deltaInfo, origCount});
        }
        return isEnoughToCompact;
    }

    public static boolean needsCleaning(AcidUtils.Directory dir, StorageDescriptor sd) {
        boolean needsJustCleaning;
        int numObsoleteDirs = dir.getObsolete().size();
        boolean bl = needsJustCleaning = numObsoleteDirs > 0;
        if (needsJustCleaning) {
            LOG.debug("{} obsolete directories in {} found; marked for cleaning.", (Object)numObsoleteDirs, (Object)sd.getLocation());
        }
        return needsJustCleaning;
    }

    static final class CompactionHeartbeater
    extends Thread {
        private static final Logger LOG = LoggerFactory.getLogger(CompactionHeartbeater.class);
        private final AtomicBoolean stop = new AtomicBoolean();
        private final long compactorTxnId;
        private final String tableName;
        private final HiveConf conf;
        private final long interval;

        public CompactionHeartbeater(long compactorTxnId, String tableName, HiveConf conf) {
            this.tableName = tableName;
            this.compactorTxnId = compactorTxnId;
            this.conf = conf;
            this.interval = MetastoreConf.getTimeVar(conf, MetastoreConf.ConfVars.TXN_TIMEOUT, TimeUnit.MILLISECONDS) / 2L;
            this.setDaemon(true);
            this.setPriority(1);
            this.setName("CompactionHeartbeater-" + compactorTxnId);
        }

        @Override
        public void run() {
            try {
                IMetaStoreClient msc = HiveMetaStoreUtils.getHiveMetastoreClient(this.conf);
                LOG.debug("Heartbeating compaction transaction id {} for table: {}", (Object)this.compactorTxnId, (Object)this.tableName);
                while (!this.stop.get()) {
                    msc.heartbeat(this.compactorTxnId, 0L);
                    Thread.sleep(this.interval);
                }
            }
            catch (Exception e) {
                LOG.error("Error while heartbeating txn {} in {}, error: ", new Object[]{this.compactorTxnId, Thread.currentThread().getName(), e.getMessage()});
            }
        }

        public void cancel() {
            if (!this.stop.get()) {
                LOG.debug("Successfully stop the heartbeating the transaction {}", (Object)this.compactorTxnId);
                this.stop.set(true);
            }
        }
    }

    static final class StatsUpdater {
        private static final Logger LOG = LoggerFactory.getLogger(StatsUpdater.class);
        private final List<String> columnList;
        private final HiveConf conf;
        private final String userName;
        private final CompactionInfo ci;

        public static StatsUpdater init(CompactionInfo ci, List<String> columnListForStats, HiveConf conf, String userName) {
            return new StatsUpdater(ci, columnListForStats, conf, userName);
        }

        private StatsUpdater(CompactionInfo ci, List<String> columnListForStats, HiveConf conf, String userName) {
            this.conf = new HiveConf(conf);
            this.conf.unset("hive.txn.valid.txns");
            this.userName = userName;
            this.ci = ci;
            if (!ci.isMajorCompaction() || columnListForStats == null || columnListForStats.isEmpty()) {
                this.columnList = Collections.emptyList();
                return;
            }
            this.columnList = columnListForStats;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void gatherStats() {
            try {
                if (!this.ci.isMajorCompaction()) {
                    return;
                }
                if (this.columnList.isEmpty()) {
                    LOG.debug(this.ci + ": No existing stats found.  Will not run analyze.");
                    return;
                }
                StringBuilder sb = new StringBuilder("analyze table ").append(StatsUtils.getFullyQualifiedTableName(this.ci.dbname, this.ci.tableName));
                if (this.ci.partName != null) {
                    sb.append(" partition(");
                    Map<String, String> partitionColumnValues = Warehouse.makeEscSpecFromName(this.ci.partName);
                    for (Map.Entry ent : partitionColumnValues.entrySet()) {
                        sb.append((String)ent.getKey()).append("='").append((String)ent.getValue()).append("',");
                    }
                    sb.setLength(sb.length() - 1);
                    sb.append(")");
                }
                sb.append(" compute statistics for columns ");
                for (String colName : this.columnList) {
                    sb.append(colName).append(",");
                }
                sb.setLength(sb.length() - 1);
                LOG.info(this.ci + ": running '" + sb.toString() + "'");
                this.conf.setVar(HiveConf.ConfVars.METASTOREURIS, "");
                QueryState queryState = new QueryState.Builder().withGenerateNewQueryId(true).withHiveConf(this.conf).build();
                SessionState localSession = null;
                try (Driver d = new Driver(queryState, this.userName);){
                    if (SessionState.get() == null) {
                        localSession = new SessionState(this.conf);
                        SessionState.start(localSession);
                    }
                    try {
                        d.run(sb.toString());
                    }
                    catch (CommandProcessorException e) {
                        LOG.warn(this.ci + ": " + sb.toString() + " failed due to: " + e);
                    }
                }
                finally {
                    if (localSession != null) {
                        try {
                            localSession.close();
                        }
                        catch (IOException ex) {
                            LOG.warn(this.ci + ": localSession.close() failed due to: " + ex.getMessage(), (Throwable)ex);
                        }
                    }
                }
            }
            catch (Throwable t) {
                LOG.error(this.ci + ": gatherStats(" + this.ci.dbname + "," + this.ci.tableName + "," + this.ci.partName + ") failed due to: " + t.getMessage(), t);
            }
        }
    }
}

