/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.txn.CompactionInfo;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.txn.compactor.MajorQueryCompactor;
import org.apache.hadoop.hive.ql.txn.compactor.MinorQueryCompactor;
import org.apache.hadoop.hive.ql.txn.compactor.MmMajorQueryCompactor;
import org.apache.hadoop.hive.ql.txn.compactor.MmMinorQueryCompactor;
import org.apache.hadoop.hive.ql.txn.compactor.QueryCompactor;

final class QueryCompactorFactory {
    private QueryCompactorFactory() {
    }

    static QueryCompactor getQueryCompactor(Table table, HiveConf configuration, CompactionInfo compactionInfo) {
        if (!AcidUtils.isInsertOnlyTable(table.getParameters()) && HiveConf.getBoolVar(configuration, HiveConf.ConfVars.COMPACTOR_CRUD_QUERY_BASED)) {
            if (compactionInfo.isMajorCompaction()) {
                return new MajorQueryCompactor();
            }
            if (!compactionInfo.isMajorCompaction() && "tez".equalsIgnoreCase(HiveConf.getVar(configuration, HiveConf.ConfVars.HIVE_EXECUTION_ENGINE))) {
                return new MinorQueryCompactor();
            }
        }
        if (AcidUtils.isInsertOnlyTable(table.getParameters()) && HiveConf.getBoolVar(configuration, HiveConf.ConfVars.HIVE_COMPACTOR_COMPACT_MM)) {
            if (compactionInfo.isMajorCompaction()) {
                return new MmMajorQueryCompactor();
            }
            return new MmMinorQueryCompactor();
        }
        return null;
    }
}

