/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.txn.CompactionInfo;
import org.apache.hadoop.hive.ql.DriverUtils;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorMR;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class QueryCompactor {
    private static final Logger LOG = LoggerFactory.getLogger((String)QueryCompactor.class.getName());
    private static final String TMPDIR = "_tmp";

    QueryCompactor() {
    }

    abstract void runCompaction(HiveConf var1, org.apache.hadoop.hive.metastore.api.Table var2, Partition var3, StorageDescriptor var4, ValidWriteIdList var5, CompactionInfo var6) throws IOException, HiveException;

    protected abstract void commitCompaction(String var1, String var2, HiveConf var3, ValidWriteIdList var4, long var5) throws IOException, HiveException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void runCompactionQueries(HiveConf conf, String tmpTableName, StorageDescriptor storageDescriptor, ValidWriteIdList writeIds, CompactionInfo compactionInfo, List<String> createQueries, List<String> compactionQueries, List<String> dropQueries) throws IOException {
        String user = UserGroupInformation.getCurrentUser().getShortUserName();
        SessionState sessionState = DriverUtils.setUpSessionState(conf, user, true);
        long compactorTxnId = CompactorMR.CompactorMap.getCompactorTxnId(conf);
        try {
            for (String query : createQueries) {
                try {
                    LOG.info("Running {} compaction query into temp table with query: {}", (Object)(compactionInfo.isMajorCompaction() ? "major" : "minor"), (Object)query);
                    DriverUtils.runOnDriver(conf, user, sessionState, query);
                }
                catch (Exception ex) {
                    Throwable cause;
                    for (cause = ex; cause != null && !(cause instanceof AlreadyExistsException); cause = cause.getCause()) {
                    }
                    if (cause != null) continue;
                    throw new IOException(ex);
                }
            }
            for (String query : compactionQueries) {
                LOG.info("Running {} compaction via query: {}", (Object)(compactionInfo.isMajorCompaction() ? "major" : "minor"), (Object)query);
                DriverUtils.runOnDriver(conf, user, sessionState, query, writeIds, compactorTxnId);
            }
            this.commitCompaction(storageDescriptor.getLocation(), tmpTableName, conf, writeIds, compactorTxnId);
        }
        catch (HiveException e) {
            try {
                LOG.error("Error doing query based {} compaction", (Object)(compactionInfo.isMajorCompaction() ? "major" : "minor"), (Object)e);
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                try {
                    Iterator<String> iterator = dropQueries.iterator();
                    while (iterator.hasNext()) {
                        String query = iterator.next();
                        LOG.info("Running {} compaction query into temp table with query: {}", (Object)(compactionInfo.isMajorCompaction() ? "major" : "minor"), (Object)query);
                        DriverUtils.runOnDriver(conf, user, sessionState, query);
                    }
                    throw throwable;
                }
                catch (HiveException e2) {
                    LOG.error("Unable to drop temp table {} which was created for running {} compaction", (Object)tmpTableName, (Object)(compactionInfo.isMajorCompaction() ? "major" : "minor"));
                    LOG.error(ExceptionUtils.getStackTrace(e2));
                }
                throw throwable;
            }
        }
        try {
            Iterator<String> iterator = dropQueries.iterator();
            while (iterator.hasNext()) {
                String query;
                query = iterator.next();
                LOG.info("Running {} compaction query into temp table with query: {}", (Object)(compactionInfo.isMajorCompaction() ? "major" : "minor"), (Object)query);
                DriverUtils.runOnDriver(conf, user, sessionState, query);
            }
            return;
        }
        catch (HiveException e) {
            LOG.error("Unable to drop temp table {} which was created for running {} compaction", (Object)tmpTableName, (Object)(compactionInfo.isMajorCompaction() ? "major" : "minor"));
            LOG.error(ExceptionUtils.getStackTrace(e));
            return;
        }
    }

    static class Util {
        Util() {
        }

        static String generateTmpPath(StorageDescriptor sd) {
            return sd.getLocation() + "/" + QueryCompactor.TMPDIR + "_" + UUID.randomUUID().toString();
        }

        private static void disableLlapCaching(HiveConf conf) {
            String llapIOETLSkipFormat = conf.getVar(HiveConf.ConfVars.LLAP_IO_ETL_SKIP_FORMAT);
            if (!"none".equals(llapIOETLSkipFormat)) {
                conf.setVar(HiveConf.ConfVars.LLAP_IO_ETL_SKIP_FORMAT, "all");
            }
        }

        static void cleanupEmptyDir(HiveConf conf, String tmpTableName) throws IOException, HiveException {
            Path path;
            FileSystem fs;
            Table tmpTable = Hive.get().getTable(tmpTableName);
            if (tmpTable != null && !(fs = (path = new Path(tmpTable.getSd().getLocation())).getFileSystem((Configuration)conf)).listFiles(path, false).hasNext()) {
                fs.delete(path, true);
            }
        }

        static void removeFilesForMmTable(HiveConf conf, AcidUtils.Directory dir) throws IOException {
            List<Path> filesToDelete = dir.getAbortedDirectories();
            if (filesToDelete.size() < 1) {
                return;
            }
            LOG.info("About to remove " + filesToDelete.size() + " aborted directories from " + dir);
            FileSystem fs = filesToDelete.get(0).getFileSystem((Configuration)conf);
            for (Path dead : filesToDelete) {
                LOG.debug("Going to delete path " + dead.toString());
                fs.delete(dead, true);
            }
        }
    }
}

