/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.txn.CompactionInfo;
import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.txn.compactor.CompactionQueryBuilder;
import org.apache.hadoop.hive.ql.txn.compactor.QueryCompactor;
import org.apache.hive.common.util.Ref;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MmMinorQueryCompactor
extends QueryCompactor {
    private static final Logger LOG = LoggerFactory.getLogger((String)MmMinorQueryCompactor.class.getName());

    MmMinorQueryCompactor() {
    }

    @Override
    void runCompaction(HiveConf hiveConf, org.apache.hadoop.hive.metastore.api.Table table, Partition partition, StorageDescriptor storageDescriptor, ValidWriteIdList writeIds, CompactionInfo compactionInfo) throws IOException {
        LOG.debug("Going to delete directories for aborted transactions for MM table " + table.getDbName() + "." + table.getTableName());
        AcidUtils.Directory dir = AcidUtils.getAcidState(null, new Path(storageDescriptor.getLocation()), hiveConf, writeIds, Ref.from(false), false, table.getParameters(), false);
        QueryCompactor.Util.removeFilesForMmTable(hiveConf, dir);
        String tmpLocation = QueryCompactor.Util.generateTmpPath(storageDescriptor);
        Path sourceTabLocation = new Path(tmpLocation);
        Path resultTabLocation = new Path(tmpLocation, "_result");
        HiveConf driverConf = this.setUpDriverSession(hiveConf);
        String tmpPrefix = table.getDbName() + ".tmp_minor_compactor_" + table.getTableName() + "_";
        String tmpTableName = tmpPrefix + System.currentTimeMillis();
        String resultTmpTableName = tmpTableName + "_result";
        List<String> createTableQueries = this.getCreateQueries(tmpTableName, table, partition == null ? table.getSd() : partition.getSd(), sourceTabLocation.toString(), resultTabLocation.toString(), dir, writeIds);
        List<String> compactionQueries = this.getCompactionQueries(tmpTableName, resultTmpTableName, table);
        List<String> dropQueries = this.getDropQueries(tmpTableName);
        this.runCompactionQueries(driverConf, tmpTableName, storageDescriptor, writeIds, compactionInfo, createTableQueries, compactionQueries, dropQueries);
    }

    @Override
    protected void commitCompaction(String dest, String tmpTableName, HiveConf conf, ValidWriteIdList actualWriteIds, long compactorTxnId) throws IOException, HiveException {
        Table resultTable = Hive.get().getTable(tmpTableName + "_result");
        String from = resultTable.getSd().getLocation();
        Path fromPath = new Path(from);
        Path toPath = new Path(dest);
        FileSystem fs = fromPath.getFileSystem((Configuration)conf);
        long maxTxn = actualWriteIds.getHighWatermark();
        AcidOutputFormat.Options options = new AcidOutputFormat.Options(conf).writingBase(false).isCompressed(false).minimumWriteId(1L).maximumWriteId(maxTxn).bucket(0).statementId(-1).visibilityTxnId(compactorTxnId);
        Path newDeltaDir = AcidUtils.createFilename(toPath, options).getParent();
        if (!fs.exists(fromPath)) {
            LOG.info(from + " not found.  Assuming 0 splits. Creating " + newDeltaDir);
            fs.mkdirs(newDeltaDir);
            return;
        }
        LOG.info("Moving contents of " + from + " to " + dest);
        fs.rename(fromPath, newDeltaDir);
        fs.delete(fromPath, true);
    }

    private List<String> getCreateQueries(String tmpTableBase, org.apache.hadoop.hive.metastore.api.Table t, StorageDescriptor sd, String sourceTabLocation, String resultTabLocation, AcidUtils.Directory dir, ValidWriteIdList validWriteIdList) {
        ArrayList<String> queries = Lists.newArrayList(this.getCreateQuery(tmpTableBase, t, sd, sourceTabLocation, true), this.getCreateQuery(tmpTableBase + "_result", t, sd, resultTabLocation, false));
        String alterQuery = this.buildAlterTableQuery(tmpTableBase, dir, validWriteIdList);
        if (!alterQuery.isEmpty()) {
            queries.add(alterQuery);
        }
        return queries;
    }

    private String getCreateQuery(String resultTableName, org.apache.hadoop.hive.metastore.api.Table t, StorageDescriptor sd, String location, boolean isPartitioned) {
        return new CompactionQueryBuilder(CompactionQueryBuilder.CompactionType.MINOR_INSERT_ONLY, CompactionQueryBuilder.Operation.CREATE, resultTableName).setSourceTab(t).setStorageDescriptor(sd).setLocation(location).setPartitioned(isPartitioned).build();
    }

    private String buildAlterTableQuery(String tableName, AcidUtils.Directory dir, ValidWriteIdList validWriteIdList) {
        return new CompactionQueryBuilder(CompactionQueryBuilder.CompactionType.MINOR_INSERT_ONLY, CompactionQueryBuilder.Operation.ALTER, tableName).setDir(dir).setValidWriteIdList(validWriteIdList).build();
    }

    private List<String> getCompactionQueries(String sourceTmpTableName, String resultTmpTableName, org.apache.hadoop.hive.metastore.api.Table sourceTable) {
        return Lists.newArrayList(new CompactionQueryBuilder(CompactionQueryBuilder.CompactionType.MINOR_INSERT_ONLY, CompactionQueryBuilder.Operation.INSERT, resultTmpTableName).setSourceTabForInsert(sourceTmpTableName).setSourceTab(sourceTable).build());
    }

    private List<String> getDropQueries(String tmpTableBase) {
        return Lists.newArrayList(this.getDropQuery(tmpTableBase), this.getDropQuery(tmpTableBase + "_result"));
    }

    private String getDropQuery(String tableToDrop) {
        return new CompactionQueryBuilder(CompactionQueryBuilder.CompactionType.MINOR_INSERT_ONLY, CompactionQueryBuilder.Operation.DROP, tableToDrop).build();
    }

    private HiveConf setUpDriverSession(HiveConf hiveConf) {
        HiveConf driverConf = new HiveConf(hiveConf);
        driverConf.set(HiveConf.ConfVars.HIVE_QUOTEDID_SUPPORT.varname, "column");
        driverConf.setBoolVar(HiveConf.ConfVars.HIVE_STATS_FETCH_COLUMN_STATS, false);
        driverConf.setBoolVar(HiveConf.ConfVars.HIVE_STATS_ESTIMATE_STATS, false);
        return driverConf;
    }
}

