/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.txn.CompactionInfo;
import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.txn.compactor.CompactionQueryBuilder;
import org.apache.hadoop.hive.ql.txn.compactor.QueryCompactor;
import org.apache.hive.common.util.Ref;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MmMajorQueryCompactor
extends QueryCompactor {
    private static final Logger LOG = LoggerFactory.getLogger((String)MmMajorQueryCompactor.class.getName());

    MmMajorQueryCompactor() {
    }

    @Override
    void runCompaction(HiveConf hiveConf, org.apache.hadoop.hive.metastore.api.Table table, Partition partition, StorageDescriptor storageDescriptor, ValidWriteIdList writeIds, CompactionInfo compactionInfo) throws IOException {
        LOG.debug("Going to delete directories for aborted transactions for MM table " + table.getDbName() + "." + table.getTableName());
        AcidUtils.Directory dir = AcidUtils.getAcidState(null, new Path(storageDescriptor.getLocation()), hiveConf, writeIds, Ref.from(false), false, table.getParameters(), false);
        QueryCompactor.Util.removeFilesForMmTable(hiveConf, dir);
        String tmpLocation = QueryCompactor.Util.generateTmpPath(storageDescriptor);
        Path baseLocation = new Path(tmpLocation, "_base");
        HiveConf driverConf = new HiveConf(hiveConf);
        driverConf.set(HiveConf.ConfVars.HIVE_QUOTEDID_SUPPORT.varname, "column");
        String tmpPrefix = table.getDbName() + ".tmp_compactor_" + table.getTableName() + "_";
        String tmpTableName = tmpPrefix + System.currentTimeMillis();
        List<String> createTableQueries = this.getCreateQueries(tmpTableName, table, partition == null ? table.getSd() : partition.getSd(), baseLocation.toString());
        List<String> compactionQueries = this.getCompactionQueries(table, partition, tmpTableName);
        List<String> dropQueries = this.getDropQueries(tmpTableName);
        this.runCompactionQueries(driverConf, tmpTableName, storageDescriptor, writeIds, compactionInfo, createTableQueries, compactionQueries, dropQueries);
    }

    @Override
    protected void commitCompaction(String dest, String tmpTableName, HiveConf conf, ValidWriteIdList actualWriteIds, long compactorTxnId) throws IOException, HiveException {
        Table tempTable = Hive.get().getTable(tmpTableName);
        String from = tempTable.getSd().getLocation();
        Path fromPath = new Path(from);
        Path toPath = new Path(dest);
        FileSystem fs = fromPath.getFileSystem((Configuration)conf);
        long maxTxn = actualWriteIds.getHighWatermark();
        AcidOutputFormat.Options options = new AcidOutputFormat.Options(conf).writingBase(true).isCompressed(false).maximumWriteId(maxTxn).bucket(0).statementId(-1).visibilityTxnId(compactorTxnId);
        Path newBaseDir = AcidUtils.createFilename(toPath, options).getParent();
        if (!fs.exists(fromPath)) {
            LOG.info(from + " not found.  Assuming 0 splits. Creating " + newBaseDir);
            fs.mkdirs(newBaseDir);
            return;
        }
        LOG.info("Moving contents of " + from + " to " + dest);
        fs.rename(fromPath, newBaseDir);
        fs.delete(fromPath, true);
    }

    private List<String> getCreateQueries(String tmpTableName, org.apache.hadoop.hive.metastore.api.Table table, StorageDescriptor storageDescriptor, String baseLocation) {
        return Lists.newArrayList(new CompactionQueryBuilder(CompactionQueryBuilder.CompactionType.MAJOR_INSERT_ONLY, CompactionQueryBuilder.Operation.CREATE, tmpTableName).setSourceTab(table).setStorageDescriptor(storageDescriptor).setLocation(baseLocation).build());
    }

    private List<String> getCompactionQueries(org.apache.hadoop.hive.metastore.api.Table t, Partition p, String tmpName) {
        return Lists.newArrayList(new CompactionQueryBuilder(CompactionQueryBuilder.CompactionType.MAJOR_INSERT_ONLY, CompactionQueryBuilder.Operation.INSERT, tmpName).setSourceTab(t).setSourcePartition(p).build());
    }

    private List<String> getDropQueries(String tmpTableName) {
        return Lists.newArrayList(new CompactionQueryBuilder(CompactionQueryBuilder.CompactionType.MAJOR_INSERT_ONLY, CompactionQueryBuilder.Operation.DROP, tmpTableName).build());
    }
}

