/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.txn.CompactionInfo;
import org.apache.hadoop.hive.ql.exec.repl.util.ReplUtils;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CompactorThread
extends Thread
implements Configurable {
    private static final String CLASS_NAME = CompactorThread.class.getName();
    protected static final Logger LOG = LoggerFactory.getLogger((String)CLASS_NAME);
    protected HiveConf conf;
    protected RawStore rs;
    protected AtomicBoolean stop;
    protected AtomicBoolean looped;
    protected int threadId;
    private static AtomicInteger nextThreadId = new AtomicInteger(1000000);

    public void setThreadId(int threadId) {
        this.threadId = threadId;
    }

    public void setConf(Configuration configuration) {
        this.conf = new HiveConf(configuration, HiveConf.class);
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void init(AtomicBoolean stop, AtomicBoolean looped) throws Exception {
        this.setPriority(1);
        this.setDaemon(true);
        this.stop = stop;
        this.looped = looped;
    }

    abstract Table resolveTable(CompactionInfo var1) throws MetaException;

    abstract boolean replIsCompactionDisabledForDatabase(String var1) throws TException;

    abstract List<Partition> getPartitionsByNames(CompactionInfo var1) throws MetaException;

    protected Partition resolvePartition(CompactionInfo ci) throws Exception {
        if (ci.partName != null) {
            List<Partition> parts;
            try {
                parts = this.getPartitionsByNames(ci);
                if (parts == null || parts.size() == 0) {
                    return null;
                }
            }
            catch (Exception e) {
                LOG.error("Unable to find partition " + ci.getFullPartitionName() + ", " + e.getMessage());
                throw e;
            }
            if (parts.size() != 1) {
                LOG.error(ci.getFullPartitionName() + " does not refer to a single partition. " + parts);
                throw new MetaException("Too many partitions for : " + ci.getFullPartitionName());
            }
            return parts.get(0);
        }
        return null;
    }

    protected StorageDescriptor resolveStorageDescriptor(Table t, Partition p) {
        return p == null ? t.getSd() : p.getSd();
    }

    protected String findUserToRunAs(String location, Table t) throws IOException, InterruptedException {
        LOG.debug("Determining who to run the job as.");
        final Path p = new Path(location);
        FileSystem fs = p.getFileSystem((Configuration)this.conf);
        try {
            FileStatus stat = fs.getFileStatus(p);
            LOG.debug("Running job as " + stat.getOwner());
            return stat.getOwner();
        }
        catch (AccessControlException e) {
            LOG.debug("Unable to stat file as current user, trying as table owner");
            final ArrayList wrapper = new ArrayList(1);
            UserGroupInformation ugi = UserGroupInformation.createProxyUser((String)t.getOwner(), (UserGroupInformation)UserGroupInformation.getLoginUser());
            ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    FileSystem proxyFs = p.getFileSystem((Configuration)CompactorThread.this.conf);
                    FileStatus stat = proxyFs.getFileStatus(p);
                    wrapper.add(stat.getOwner());
                    return null;
                }
            });
            try {
                FileSystem.closeAllForUGI((UserGroupInformation)ugi);
            }
            catch (IOException exception) {
                LOG.error("Could not clean up file-system handles for UGI: " + ugi, (Throwable)exception);
            }
            if (wrapper.size() == 1) {
                LOG.debug("Running job as " + (String)wrapper.get(0));
                return (String)wrapper.get(0);
            }
            LOG.error("Unable to stat file " + p + " as either current user(" + UserGroupInformation.getLoginUser() + ") or table owner(" + t.getOwner() + "), giving up");
            throw new IOException("Unable to stat file: " + p);
        }
    }

    protected boolean runJobAsSelf(String owner) {
        return owner.equals(System.getProperty("user.name"));
    }

    protected String tableName(Table t) {
        return Warehouse.getQualifiedName(t);
    }

    public static void initializeAndStartThread(CompactorThread thread, Configuration conf) throws Exception {
        LOG.info("Starting compactor thread of type " + thread.getClass().getName());
        thread.setConf(conf);
        thread.setThreadId(nextThreadId.incrementAndGet());
        thread.init(new AtomicBoolean(), new AtomicBoolean());
        thread.start();
    }

    protected boolean replIsCompactionDisabledForTable(Table tbl) {
        return ReplUtils.isFirstIncPending(tbl.getParameters());
    }
}

