/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.ValidReaderWriteIdList;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.ReplChangeManager;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.GetValidWriteIdsRequest;
import org.apache.hadoop.hive.metastore.api.GetValidWriteIdsResponse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.txn.CompactionInfo;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.txn.compactor.MetaStoreCompactorThread;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;
import org.apache.hive.common.util.Ref;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cleaner
extends MetaStoreCompactorThread {
    private static final String CLASS_NAME = Cleaner.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLASS_NAME);
    private long cleanerCheckInterval = 0L;
    private ReplChangeManager replChangeManager;

    @Override
    public void init(AtomicBoolean stop, AtomicBoolean looped) throws Exception {
        super.init(stop, looped);
        this.replChangeManager = ReplChangeManager.getInstance(this.conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.cleanerCheckInterval == 0L) {
            this.cleanerCheckInterval = this.conf.getTimeVar(HiveConf.ConfVars.HIVE_COMPACTOR_CLEANER_RUN_INTERVAL, TimeUnit.MILLISECONDS);
        }
        do {
            long elapsedTime;
            boolean setLooped = !this.looped.get();
            TxnStore.MutexAPI.LockHandle handle = null;
            long startedAt = -1L;
            try {
                handle = this.txnHandler.getMutexAPI().acquireLock(TxnStore.MUTEX_KEY.Cleaner.name());
                startedAt = System.currentTimeMillis();
                long minOpenTxnId = this.txnHandler.findMinOpenTxnId();
                for (CompactionInfo compactionInfo : this.txnHandler.findReadyToClean()) {
                    this.clean(compactionInfo, minOpenTxnId);
                }
            }
            catch (Throwable t) {
                LOG.error("Caught an exception in the main loop of compactor cleaner, " + StringUtils.stringifyException((Throwable)t));
            }
            finally {
                if (handle != null) {
                    handle.releaseLocks();
                }
            }
            if (setLooped) {
                this.looped.set(true);
            }
            if ((elapsedTime = System.currentTimeMillis() - startedAt) >= this.cleanerCheckInterval || this.stop.get()) continue;
            try {
                Thread.sleep(this.cleanerCheckInterval - elapsedTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (!this.stop.get());
    }

    private void clean(final CompactionInfo ci, long minOpenTxnGLB) throws MetaException {
        LOG.info("Starting cleaning for " + ci);
        try {
            Table t = this.resolveTable(ci);
            if (t == null) {
                LOG.info("Unable to find table " + ci.getFullTableName() + ", assuming it was dropped." + Cleaner.idWatermark(ci));
                this.txnHandler.markCleaned(ci);
                return;
            }
            Partition p = null;
            if (ci.partName != null && (p = this.resolvePartition(ci)) == null) {
                LOG.info("Unable to find partition " + ci.getFullPartitionName() + ", assuming it was dropped." + Cleaner.idWatermark(ci));
                this.txnHandler.markCleaned(ci);
                return;
            }
            StorageDescriptor sd = this.resolveStorageDescriptor(t, p);
            final String location = sd.getLocation();
            ValidTxnList validTxnList = TxnUtils.createValidTxnListForCleaner(this.txnHandler.getOpenTxns(), minOpenTxnGLB);
            this.conf.set("hive.txn.valid.txns", validTxnList.writeToString());
            List<String> tblNames = Collections.singletonList(TxnUtils.getFullTableName(t.getDbName(), t.getTableName()));
            GetValidWriteIdsRequest rqst = new GetValidWriteIdsRequest(tblNames);
            rqst.setValidTxnList(validTxnList.writeToString());
            GetValidWriteIdsResponse rsp = this.txnHandler.getValidWriteIds(rqst);
            assert (rsp != null && rsp.getTblValidWriteIdsSize() == 1);
            final ValidReaderWriteIdList validWriteIdList = TxnUtils.createValidReaderWriteIdList(rsp.getTblValidWriteIds().get(0));
            if (this.runJobAsSelf(ci.runAs)) {
                this.removeFiles(location, validWriteIdList, ci);
            } else {
                LOG.info("Cleaning as user " + ci.runAs + " for " + ci.getFullPartitionName());
                UserGroupInformation ugi = UserGroupInformation.createProxyUser((String)ci.runAs, (UserGroupInformation)UserGroupInformation.getLoginUser());
                ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        Cleaner.this.removeFiles(location, validWriteIdList, ci);
                        return null;
                    }
                });
                try {
                    FileSystem.closeAllForUGI((UserGroupInformation)ugi);
                }
                catch (IOException exception) {
                    LOG.error("Could not clean up file-system handles for UGI: " + ugi + " for " + ci.getFullPartitionName() + Cleaner.idWatermark(ci), (Throwable)exception);
                }
            }
            this.txnHandler.markCleaned(ci);
        }
        catch (Exception e) {
            LOG.error("Caught exception when cleaning, unable to complete cleaning of " + ci + " " + StringUtils.stringifyException((Throwable)e));
            ci.errorMessage = e.getMessage();
            this.txnHandler.markFailed(ci);
        }
    }

    private static String idWatermark(CompactionInfo ci) {
        return " id=" + ci.id;
    }

    private void removeFiles(String location, ValidWriteIdList writeIdList, CompactionInfo ci) throws IOException, NoSuchObjectException {
        Path locPath = new Path(location);
        AcidUtils.Directory dir = AcidUtils.getAcidState(locPath.getFileSystem((Configuration)this.conf), locPath, this.conf, writeIdList, Ref.from(false), false, null, false);
        List<Path> obsoleteDirs = dir.getObsolete();
        obsoleteDirs.addAll(dir.getAbortedDirectories());
        ArrayList<Path> filesToDelete = new ArrayList<Path>(obsoleteDirs.size());
        StringBuilder extraDebugInfo = new StringBuilder("[");
        for (Path stat : obsoleteDirs) {
            filesToDelete.add(stat);
            extraDebugInfo.append(stat.getName()).append(",");
            if (FileUtils.isPathWithinSubtree(stat, locPath)) continue;
            LOG.info(Cleaner.idWatermark(ci) + " found unexpected file: " + stat);
        }
        extraDebugInfo.setCharAt(extraDebugInfo.length() - 1, ']');
        LOG.info(Cleaner.idWatermark(ci) + " About to remove " + filesToDelete.size() + " obsolete directories from " + location + ". " + extraDebugInfo.toString());
        if (filesToDelete.size() < 1) {
            LOG.warn("Hmm, nothing to delete in the cleaner for directory " + location + ", that hardly seems right.");
            return;
        }
        FileSystem fs = ((Path)filesToDelete.get(0)).getFileSystem((Configuration)this.conf);
        Database db = this.rs.getDatabase(MetaStoreUtils.getDefaultCatalog(this.conf), ci.dbname);
        Boolean isSourceOfRepl = ReplChangeManager.isSourceOfReplication(db);
        for (Path dead : filesToDelete) {
            LOG.debug("Going to delete path " + dead.toString());
            if (isSourceOfRepl.booleanValue()) {
                this.replChangeManager.recycle(dead, ReplChangeManager.RecycleType.MOVE, true);
            }
            fs.delete(dead, true);
        }
    }
}

