/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.session;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.hooks.LineageInfo;
import org.apache.hadoop.hive.ql.optimizer.lineage.LineageCtx;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;

public class LineageState
implements Serializable {
    private final Map<String, Operator> dirToFop = new HashMap<String, Operator>();
    private LineageCtx.Index index;
    private final LineageInfo linfo = new LineageInfo();

    public LineageState() {
        this.index = new LineageCtx.Index();
    }

    public synchronized void mapDirToOp(Path dir, Operator fop) {
        this.dirToFop.put(dir.toUri().toString(), fop);
    }

    public synchronized void updateDirToOpMap(Path newPath, Path oldPath) {
        Operator op = this.dirToFop.get(oldPath.toUri().toString());
        if (op != null) {
            this.dirToFop.put(newPath.toUri().toString(), op);
        }
    }

    public synchronized void setLineage(Path dir, LineageInfo.DataContainer dc, List<FieldSchema> cols) {
        Operator op = this.dirToFop.get(dir.toUri().toString());
        if (op == null) {
            return;
        }
        List<ColumnInfo> signature = op.getSchema().getSignature();
        int i = 0;
        for (FieldSchema fs : cols) {
            this.linfo.putDependency(dc, fs, this.index.getDependency((Operator<? extends OperatorDesc>)op, signature.get(i++)));
        }
    }

    public LineageInfo getLineageInfo() {
        return this.linfo;
    }

    public LineageCtx.Index getIndex() {
        return this.index;
    }

    public synchronized void clear() {
        this.dirToFop.clear();
        this.linfo.clear();
        this.index.clear();
    }
}

