/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.events;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.events.PreEventContext;
import org.apache.hadoop.hive.metastore.events.PreReadTableEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.HiveMetaStoreAuthorizableEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.HiveMetaStoreAuthzInfo;

public class ReadTableEvent
extends HiveMetaStoreAuthorizableEvent {
    private static final Log LOG = LogFactory.getLog(ReadTableEvent.class);
    private static final String COMMAND_STR = "select";

    public ReadTableEvent(PreEventContext preEventContext) {
        super(preEventContext);
    }

    @Override
    public HiveMetaStoreAuthzInfo getAuthzContext() {
        HiveMetaStoreAuthzInfo ret = new HiveMetaStoreAuthzInfo(this.preEventContext, HiveOperationType.QUERY, this.getInputHObjs(), this.getOutputHObjs(), COMMAND_STR);
        return ret;
    }

    private List<HivePrivilegeObject> getInputHObjs() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> ReadTableEvent.getInputHObjs()");
        }
        ArrayList<HivePrivilegeObject> ret = new ArrayList<HivePrivilegeObject>();
        PreReadTableEvent preReadTableEvent = (PreReadTableEvent)this.preEventContext;
        String dbName = preReadTableEvent.getTable().getDbName();
        Table table = preReadTableEvent.getTable();
        ret.add(new HivePrivilegeObject(HivePrivilegeObject.HivePrivilegeObjectType.DATABASE, dbName, null, null, null, HivePrivilegeObject.HivePrivObjectActionType.OTHER, null, null, table.getOwner(), table.getOwnerType()));
        ret.add(this.getHivePrivilegeObject(table));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== ReadTableEvent.getInputHObjs()" + ret));
        }
        return ret;
    }

    private List<HivePrivilegeObject> getOutputHObjs() {
        return Collections.emptyList();
    }
}

