/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.command;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.FunctionUtils;
import org.apache.hadoop.hive.ql.hooks.Entity;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.security.authorization.AuthorizationUtils;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.session.SessionState;

final class CommandAuthorizerV2 {
    private CommandAuthorizerV2() {
        throw new UnsupportedOperationException("CommandAuthorizerV2 should not be instantiated");
    }

    static void doAuthorization(HiveOperation op, BaseSemanticAnalyzer sem, SessionState ss, Set<ReadEntity> inputs, Set<WriteEntity> outputs, String command) throws HiveException {
        HiveOperationType hiveOpType = HiveOperationType.valueOf(op.name());
        Map<String, List<String>> selectTab2Cols = sem.getColumnAccessInfo() != null ? sem.getColumnAccessInfo().getTableToColumnAccessMap() : null;
        Map<String, List<String>> updateTab2Cols = sem.getUpdateColumnAccessInfo() != null ? sem.getUpdateColumnAccessInfo().getTableToColumnAccessMap() : null;
        ArrayList<ReadEntity> inputList = new ArrayList<ReadEntity>(inputs);
        ArrayList<WriteEntity> outputList = new ArrayList<WriteEntity>(outputs);
        CommandAuthorizerV2.addPermanentFunctionEntities(ss, inputList);
        List<HivePrivilegeObject> inputsHObjs = CommandAuthorizerV2.getHivePrivObjects(inputList, selectTab2Cols);
        List<HivePrivilegeObject> outputHObjs = CommandAuthorizerV2.getHivePrivObjects(outputList, updateTab2Cols);
        HiveAuthzContext.Builder authzContextBuilder = new HiveAuthzContext.Builder();
        authzContextBuilder.setUserIpAddress(ss.getUserIpAddress());
        authzContextBuilder.setForwardedAddresses(ss.getForwardedAddresses());
        authzContextBuilder.setCommandString(command);
        ss.getAuthorizerV2().checkPrivileges(hiveOpType, inputsHObjs, outputHObjs, authzContextBuilder.build());
    }

    private static void addPermanentFunctionEntities(SessionState ss, List<ReadEntity> inputList) throws HiveException {
        for (Map.Entry<String, FunctionInfo> function : ss.getCurrentFunctionsInUse().entrySet()) {
            if (function.getValue().getFunctionType() != FunctionInfo.FunctionType.PERSISTENT) continue;
            String[] qualifiedFunctionName = FunctionUtils.getQualifiedFunctionNameParts(function.getKey());
            Database db = new Database(qualifiedFunctionName[0], "", "", null);
            inputList.add(new ReadEntity(db, qualifiedFunctionName[1], function.getValue().getClassName(), Entity.Type.FUNCTION));
        }
    }

    private static List<HivePrivilegeObject> getHivePrivObjects(List<? extends Entity> privObjects, Map<String, List<String>> tableName2Cols) {
        ArrayList<HivePrivilegeObject> hivePrivobjs = new ArrayList<HivePrivilegeObject>();
        if (privObjects == null) {
            return hivePrivobjs;
        }
        for (Entity entity : privObjects) {
            if (entity.isDummy() || entity instanceof ReadEntity && !((ReadEntity)entity).isDirect() || entity instanceof WriteEntity && ((WriteEntity)entity).isTempURI() || entity.getTyp() == Entity.Type.TABLE && (entity.getT() == null || entity.getT().isTemporary())) continue;
            CommandAuthorizerV2.addHivePrivObject(entity, tableName2Cols, hivePrivobjs);
        }
        return hivePrivobjs;
    }

    private static void addHivePrivObject(Entity privObject, Map<String, List<String>> tableName2Cols, List<HivePrivilegeObject> hivePrivObjs) {
        HivePrivilegeObject.HivePrivilegeObjectType privObjType = AuthorizationUtils.getHivePrivilegeObjectType(privObject.getType());
        HivePrivilegeObject.HivePrivObjectActionType actionType = AuthorizationUtils.getActionType(privObject);
        HivePrivilegeObject hivePrivObject = null;
        switch (privObject.getType()) {
            case DATABASE: {
                Database database = privObject.getDatabase();
                hivePrivObject = new HivePrivilegeObject(privObjType, database.getName(), null, null, null, actionType, null, null, database.getOwnerName(), database.getOwnerType());
                break;
            }
            case TABLE: {
                Table table = privObject.getTable();
                List<String> columns = tableName2Cols == null ? null : tableName2Cols.get(Table.getCompleteName(table.getDbName(), table.getTableName()));
                hivePrivObject = new HivePrivilegeObject(privObjType, table.getDbName(), table.getTableName(), null, columns, actionType, null, null, table.getOwner(), table.getOwnerType());
                break;
            }
            case DFS_DIR: 
            case LOCAL_DIR: {
                hivePrivObject = new HivePrivilegeObject(privObjType, null, privObject.getD().toString(), null, null, actionType, null, null, null, null);
                break;
            }
            case FUNCTION: {
                String dbName = privObject.getDatabase() != null ? privObject.getDatabase().getName() : null;
                hivePrivObject = new HivePrivilegeObject(privObjType, dbName, privObject.getFunctionName(), null, null, actionType, null, privObject.getClassName(), null, null);
                break;
            }
            case DUMMYPARTITION: 
            case PARTITION: {
                return;
            }
            case SERVICE_NAME: {
                hivePrivObject = new HivePrivilegeObject(privObjType, null, privObject.getServiceName(), null, null, actionType, null, null, null, null);
                break;
            }
            default: {
                throw new AssertionError((Object)"Unexpected object type");
            }
        }
        hivePrivObjs.add(hivePrivObject);
    }
}

