/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.security.authorization.PrivilegeScope;
import org.apache.hadoop.hive.ql.security.authorization.PrivilegeType;

public class Privilege {
    private PrivilegeType priv;
    private EnumSet<PrivilegeScope> supportedScopeSet;
    public static Privilege ALL = new Privilege(PrivilegeType.ALL, PrivilegeScope.ALLSCOPE_EXCEPT_COLUMN);
    public static Privilege ALTER_METADATA = new Privilege(PrivilegeType.ALTER_METADATA, PrivilegeScope.ALLSCOPE_EXCEPT_COLUMN);
    public static Privilege ALTER_DATA = new Privilege(PrivilegeType.ALTER_DATA, PrivilegeScope.ALLSCOPE_EXCEPT_COLUMN);
    public static Privilege CREATE = new Privilege(PrivilegeType.CREATE, PrivilegeScope.ALLSCOPE_EXCEPT_COLUMN);
    public static Privilege DROP = new Privilege(PrivilegeType.DROP, PrivilegeScope.ALLSCOPE_EXCEPT_COLUMN);
    public static Privilege LOCK = new Privilege(PrivilegeType.LOCK, PrivilegeScope.ALLSCOPE_EXCEPT_COLUMN);
    public static Privilege SELECT = new Privilege(PrivilegeType.SELECT, PrivilegeScope.ALLSCOPE);
    public static Privilege INSERT = new Privilege(PrivilegeType.INSERT, PrivilegeScope.ALLSCOPE_EXCEPT_COLUMN);
    public static Privilege DELETE = new Privilege(PrivilegeType.DELETE, PrivilegeScope.ALLSCOPE_EXCEPT_COLUMN);
    public static Privilege SHOW_DATABASE = new Privilege(PrivilegeType.SHOW_DATABASE, EnumSet.of(PrivilegeScope.USER_LEVEL_SCOPE));

    private Privilege(PrivilegeType priv, EnumSet<PrivilegeScope> scopeSet) {
        this.priv = priv;
        this.supportedScopeSet = scopeSet;
    }

    public Privilege(PrivilegeType priv) {
        this.priv = priv;
    }

    @Explain(skipHeader=true, explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public PrivilegeType getPriv() {
        return this.priv;
    }

    public void setPriv(PrivilegeType priv) {
        this.priv = priv;
    }

    public boolean supportColumnLevel() {
        return this.supportedScopeSet != null && this.supportedScopeSet.contains((Object)PrivilegeScope.COLUMN_LEVEL_SCOPE);
    }

    public boolean supportDBLevel() {
        return this.supportedScopeSet != null && this.supportedScopeSet.contains((Object)PrivilegeScope.DB_LEVEL_SCOPE);
    }

    public boolean supportTableLevel() {
        return this.supportedScopeSet != null && this.supportedScopeSet.contains((Object)PrivilegeScope.TABLE_LEVEL_SCOPE);
    }

    public List<String> getScopeList() {
        if (this.supportedScopeSet == null) {
            return null;
        }
        ArrayList<String> scopes = new ArrayList<String>();
        for (PrivilegeScope scope : this.supportedScopeSet) {
            scopes.add(scope.name());
        }
        return scopes;
    }

    public String toString() {
        return this.getPriv().toString();
    }

    public Privilege() {
    }
}

