/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan.mapper;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Map;
import java.util.Optional;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.optimizer.signature.OpTreeSignature;
import org.apache.hadoop.hive.ql.plan.mapper.StatsSource;
import org.apache.hadoop.hive.ql.stats.OperatorStats;

public class CachingStatsSource
implements StatsSource {
    private final Cache<OpTreeSignature, OperatorStats> cache;

    public CachingStatsSource(int cacheSize) {
        this.cache = CacheBuilder.newBuilder().maximumSize(cacheSize).build();
    }

    public void put(OpTreeSignature sig, OperatorStats opStat) {
        this.cache.put(sig, opStat);
    }

    @Override
    public Optional<OperatorStats> lookup(OpTreeSignature treeSig) {
        return Optional.ofNullable(this.cache.getIfPresent(treeSig));
    }

    @Override
    public boolean canProvideStatsFor(Class<?> clazz) {
        return this.cache.size() > 0L && Operator.class.isAssignableFrom(clazz);
    }

    @Override
    public void putAll(Map<OpTreeSignature, OperatorStats> map) {
        for (Map.Entry<OpTreeSignature, OperatorStats> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }
}

