/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.CopyOnFirstWriteProperties;
import org.apache.hadoop.hive.common.StringInternUtils;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.VectorPartitionDesc;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hive.common.util.ReflectionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Explain(displayName="Partition", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class PartitionDesc
implements Serializable,
Cloneable {
    private static final Interner<Class<?>> CLASS_INTERNER = Interners.newWeakInterner();
    private TableDesc tableDesc;
    private LinkedHashMap<String, String> partSpec;
    private Class<? extends InputFormat> inputFileFormatClass;
    private Class<? extends OutputFormat> outputFileFormatClass;
    private Properties properties;
    private String baseFileName;
    private VectorPartitionDesc vectorPartitionDesc;
    private static final Logger LOG = LoggerFactory.getLogger(PartitionDesc.class);

    public void setBaseFileName(String baseFileName) {
        this.baseFileName = StringInternUtils.internIfNotNull(baseFileName);
    }

    public PartitionDesc() {
    }

    public PartitionDesc(TableDesc table, LinkedHashMap<String, String> partSpec) {
        this.tableDesc = table;
        this.setPartSpec(partSpec);
    }

    public PartitionDesc(Partition part, TableDesc tableDesc) throws HiveException {
        this.PartitionDescConstructorHelper(part, tableDesc, true);
        if (Utilities.isInputFileFormatSelfDescribing(this)) {
            Table tbl = part.getTable();
            this.setProperties(MetaStoreUtils.getSchemaWithoutCols(part.getTPartition().getSd(), part.getParameters(), tbl.getDbName(), tbl.getTableName(), tbl.getPartitionKeys()));
        } else {
            this.setProperties(part.getMetadataFromPartitionSchema());
        }
    }

    public PartitionDesc(Partition part) throws HiveException {
        this(part, PartitionDesc.getTableDesc(part.getTable()));
    }

    public PartitionDesc(Partition part, TableDesc tblDesc, boolean usePartSchemaProperties) throws HiveException {
        this.PartitionDescConstructorHelper(part, tblDesc, usePartSchemaProperties);
        if (usePartSchemaProperties) {
            this.setProperties(part.getMetadataFromPartitionSchema());
        } else {
            this.setProperties(part.getSchemaFromTableSchema(tblDesc.getProperties()));
        }
    }

    private void PartitionDescConstructorHelper(Partition part, TableDesc tblDesc, boolean setInputFileFormat) throws HiveException {
        PlanUtils.configureInputJobPropertiesForStorageHandler(tblDesc);
        this.tableDesc = tblDesc;
        this.setPartSpec(part.getSpec());
        if (setInputFileFormat) {
            this.setInputFileFormatClass(part.getInputFormatClass());
        } else {
            this.setOutputFileFormatClass(part.getInputFormatClass());
        }
        this.setOutputFileFormatClass(part.getOutputFormatClass());
    }

    @Explain(displayName="", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public TableDesc getTableDesc() {
        return this.tableDesc;
    }

    public void setTableDesc(TableDesc tableDesc) {
        this.tableDesc = tableDesc;
    }

    @Explain(displayName="partition values", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public LinkedHashMap<String, String> getPartSpec() {
        return this.partSpec;
    }

    public void setPartSpec(LinkedHashMap<String, String> partSpec) {
        StringInternUtils.internValuesInMap(partSpec);
        this.partSpec = partSpec;
    }

    public Class<? extends InputFormat> getInputFileFormatClass() {
        if (this.inputFileFormatClass == null && this.tableDesc != null) {
            this.setInputFileFormatClass(this.tableDesc.getInputFileFormatClass());
        }
        return this.inputFileFormatClass;
    }

    public String getDeserializerClassName() {
        Properties schema = this.getProperties();
        String clazzName = schema.getProperty("serialization.lib");
        if (clazzName == null) {
            throw new IllegalStateException("Property serialization.lib cannot be null");
        }
        return clazzName;
    }

    public Deserializer getDeserializer(Configuration conf) throws Exception {
        Properties schema = this.getProperties();
        String clazzName = this.getDeserializerClassName();
        Deserializer deserializer = ReflectionUtil.newInstance(conf.getClassByName(clazzName).asSubclass(Deserializer.class), conf);
        SerDeUtils.initializeSerDe(deserializer, conf, this.getTableDesc().getProperties(), schema);
        return deserializer;
    }

    public void setInputFileFormatClass(Class<? extends InputFormat> inputFileFormatClass) {
        this.inputFileFormatClass = inputFileFormatClass == null ? null : CLASS_INTERNER.intern(inputFileFormatClass);
    }

    public Class<? extends OutputFormat> getOutputFileFormatClass() {
        if (this.outputFileFormatClass == null && this.tableDesc != null) {
            this.setOutputFileFormatClass(this.tableDesc.getOutputFileFormatClass());
        }
        return this.outputFileFormatClass;
    }

    public void setOutputFileFormatClass(Class<?> outputFileFormatClass) {
        Class<? extends OutputFormat> outputClass = outputFileFormatClass == null ? null : HiveFileFormatUtils.getOutputFormatSubstitute(outputFileFormatClass);
        this.outputFileFormatClass = outputClass != null ? CLASS_INTERNER.intern(outputClass) : outputClass;
    }

    public Properties getProperties() {
        if (this.properties == null && this.tableDesc != null) {
            return this.tableDesc.getProperties();
        }
        return this.properties;
    }

    @Explain(displayName="properties", explainLevels={Explain.Level.EXTENDED})
    public Map getPropertiesExplain() {
        return PlanUtils.getPropertiesExplain(this.getProperties());
    }

    public void setProperties(Properties properties) {
        if (properties instanceof CopyOnFirstWriteProperties) {
            this.properties = properties;
        } else {
            PartitionDesc.internProperties(properties);
            this.properties = new CopyOnFirstWriteProperties(properties);
        }
    }

    public static TableDesc getTableDesc(Table table) {
        return Utilities.getTableDesc(table);
    }

    private static void internProperties(Properties properties) {
        Enumeration<?> keys = properties.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String oldValue = properties.getProperty(key);
            if (oldValue == null) continue;
            properties.setProperty(key, oldValue.intern());
        }
    }

    @Explain(displayName="serde", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getSerdeClassName() {
        return this.getProperties().getProperty("serialization.lib");
    }

    @Explain(displayName="name", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getTableName() {
        return this.getProperties().getProperty("name");
    }

    @Explain(displayName="input format", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getInputFileFormatClassName() {
        return this.getInputFileFormatClass().getName();
    }

    @Explain(displayName="output format", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getOutputFileFormatClassName() {
        return this.getOutputFileFormatClass().getName();
    }

    @Explain(displayName="base file name", explainLevels={Explain.Level.EXTENDED})
    public String getBaseFileName() {
        return this.baseFileName;
    }

    public boolean isPartitioned() {
        return this.partSpec != null && !this.partSpec.isEmpty();
    }

    public PartitionDesc clone() {
        PartitionDesc ret = new PartitionDesc();
        ret.inputFileFormatClass = this.inputFileFormatClass;
        ret.outputFileFormatClass = this.outputFileFormatClass;
        if (this.properties != null) {
            ret.setProperties((Properties)this.properties.clone());
        }
        ret.tableDesc = (TableDesc)this.tableDesc.clone();
        if (this.partSpec != null) {
            ret.partSpec = new LinkedHashMap<String, String>(this.partSpec);
        }
        if (this.vectorPartitionDesc != null) {
            ret.vectorPartitionDesc = this.vectorPartitionDesc.clone();
        }
        return ret;
    }

    public boolean equals(Object o) {
        boolean cond = o instanceof PartitionDesc;
        if (!cond) {
            return false;
        }
        PartitionDesc other = (PartitionDesc)o;
        Class<? extends InputFormat> input1 = this.getInputFileFormatClass();
        Class<? extends InputFormat> input2 = other.getInputFileFormatClass();
        boolean bl = cond = input1 == null && input2 == null || input1 != null && input1.equals(input2);
        if (!cond) {
            return false;
        }
        Class<? extends OutputFormat> output1 = this.getOutputFileFormatClass();
        Class<? extends OutputFormat> output2 = other.getOutputFileFormatClass();
        boolean bl2 = cond = output1 == null && output2 == null || output1 != null && output1.equals(output2);
        if (!cond) {
            return false;
        }
        Properties properties1 = this.getProperties();
        Properties properties2 = other.getProperties();
        boolean bl3 = cond = properties1 == null && properties2 == null || properties1 != null && properties1.equals(properties2);
        if (!cond) {
            return false;
        }
        TableDesc tableDesc1 = this.getTableDesc();
        TableDesc tableDesc2 = other.getTableDesc();
        boolean bl4 = cond = tableDesc1 == null && tableDesc2 == null || tableDesc1 != null && tableDesc1.equals(tableDesc2);
        if (!cond) {
            return false;
        }
        LinkedHashMap<String, String> partSpec1 = this.getPartSpec();
        LinkedHashMap<String, String> partSpec2 = other.getPartSpec();
        boolean bl5 = cond = partSpec1 == null && partSpec2 == null || partSpec1 != null && partSpec1.equals(partSpec2);
        if (!cond) {
            return false;
        }
        VectorPartitionDesc vecPartDesc1 = this.getVectorPartitionDesc();
        VectorPartitionDesc vecPartDesc2 = other.getVectorPartitionDesc();
        return vecPartDesc1 == null && vecPartDesc2 == null || vecPartDesc1 != null && vecPartDesc1.equals(vecPartDesc2);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = result * 31 + (this.getInputFileFormatClass() == null ? 0 : this.getInputFileFormatClass().hashCode());
        result = result * 31 + (this.getOutputFileFormatClass() == null ? 0 : this.getOutputFileFormatClass().hashCode());
        result = result * 31 + (this.getProperties() == null ? 0 : this.getProperties().hashCode());
        result = result * 31 + (this.getTableDesc() == null ? 0 : this.getTableDesc().hashCode());
        result = result * 31 + (this.getPartSpec() == null ? 0 : this.getPartSpec().hashCode());
        result = result * 31 + (this.getVectorPartitionDesc() == null ? 0 : this.getVectorPartitionDesc().hashCode());
        return result;
    }

    public void deriveBaseFileName(Path path) {
        if (path == null) {
            return;
        }
        this.baseFileName = path.getName().intern();
    }

    public void intern(Interner<TableDesc> interner) {
        this.tableDesc = interner.intern(this.tableDesc);
    }

    public void setVectorPartitionDesc(VectorPartitionDesc vectorPartitionDesc) {
        this.vectorPartitionDesc = vectorPartitionDesc;
    }

    public VectorPartitionDesc getVectorPartitionDesc() {
        return this.vectorPartitionDesc;
    }

    public String toString() {
        return "PartitionDesc [tableDesc=" + this.tableDesc + ", partSpec=" + this.partSpec + ", inputFileFormatClass=" + this.inputFileFormatClass + ", outputFileFormatClass=" + this.outputFileFormatClass + ", properties=" + this.properties + ", baseFileName=" + this.baseFileName + ", vectorPartitionDesc=" + this.vectorPartitionDesc + "]";
    }
}

