/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.ql.security.authorization.Privilege;

public enum HiveOperation {
    EXPLAIN("EXPLAIN", 878, null, null),
    LOAD("LOAD", 937, null, new Privilege[]{Privilege.ALTER_DATA}),
    EXPORT("EXPORT", 881, new Privilege[]{Privilege.SELECT}, null),
    IMPORT("IMPORT", 906, null, new Privilege[]{Privilege.ALTER_METADATA, Privilege.ALTER_DATA}),
    REPLDUMP("REPLDUMP", 1015, new Privilege[]{Privilege.ALL}, null),
    REPLLOAD("REPLLOAD", 1016, null, new Privilege[]{Privilege.ALL}),
    REPLSTATUS("REPLSTATUS", 1017, new Privilege[]{Privilege.SELECT}, null),
    CREATEDATABASE("CREATEDATABASE", 821, null, new Privilege[]{Privilege.CREATE}),
    DROPDATABASE("DROPDATABASE", 860, null, new Privilege[]{Privilege.DROP}),
    SWITCHDATABASE("SWITCHDATABASE", 1085, null, null, true, false),
    LOCKDB("LOCKDATABASE", 938, new Privilege[]{Privilege.LOCK}, null),
    UNLOCKDB("UNLOCKDATABASE", 1141, new Privilege[]{Privilege.LOCK}, null),
    DROPTABLE("DROPTABLE", 864, null, new Privilege[]{Privilege.DROP}),
    DESCTABLE("DESCTABLE", 853, null, null),
    DESCFUNCTION("DESCFUNCTION", 852, null, null),
    MSCK("MSCK", 944, null, null),
    ALTERTABLE_ADDCOLS("ALTERTABLE_ADDCOLS", 752, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_REPLACECOLS("ALTERTABLE_REPLACECOLS", 773, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_RENAMECOL("ALTERTABLE_RENAMECOL", 771, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_RENAMEPART("ALTERTABLE_RENAMEPART", 772, new Privilege[]{Privilege.DROP}, new Privilege[]{Privilege.CREATE}),
    ALTERTABLE_UPDATEPARTSTATS("ALTERTABLE_UPDATEPARTSTATS", new int[]{750, 749}, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_UPDATETABLESTATS("ALTERTABLE_UPDATETABLESTATS", new int[]{782, 780}, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_RENAME("ALTERTABLE_RENAME", 770, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_DROPPARTS("ALTERTABLE_DROPPARTS", new int[]{761, 785}, new Privilege[]{Privilege.DROP}, null),
    ALTERTABLE_ADDPARTS("ALTERTABLE_ADDPARTS", new int[]{754, 784}, null, new Privilege[]{Privilege.CREATE}),
    ALTERTABLE_TOUCH("ALTERTABLE_TOUCH", 778, null, null),
    ALTERTABLE_ARCHIVE("ALTERTABLE_ARCHIVE", 755, new Privilege[]{Privilege.ALTER_DATA}, null),
    ALTERTABLE_UNARCHIVE("ALTERTABLE_UNARCHIVE", 779, new Privilege[]{Privilege.ALTER_DATA}, null),
    ALTERTABLE_PROPERTIES("ALTERTABLE_PROPERTIES", new int[]{769, 762}, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_OWNER("ALTERTABLE_OWNER", 767, null, null),
    ALTERTABLE_SERIALIZER("ALTERTABLE_SERIALIZER", 775, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERPARTITION_SERIALIZER("ALTERPARTITION_SERIALIZER", 748, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_SERDEPROPERTIES("ALTERTABLE_SERDEPROPERTIES", 774, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERPARTITION_SERDEPROPERTIES("ALTERPARTITION_SERDEPROPERTIES", 747, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_CLUSTER_SORT("ALTERTABLE_CLUSTER_SORT", 758, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ANALYZE_TABLE("ANALYZE_TABLE", 805, null, null),
    CACHE_METADATA("CACHE_METADATA", 811, new Privilege[]{Privilege.SELECT}, null),
    ALTERTABLE_BUCKETNUM("ALTERTABLE_BUCKETNUM", 756, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERPARTITION_BUCKETNUM("ALTERPARTITION_BUCKETNUM", 743, new Privilege[]{Privilege.ALTER_METADATA}, null),
    SHOWDATABASES("SHOWDATABASES", 1048, new Privilege[]{Privilege.SHOW_DATABASE}, null, true, false),
    SHOWTABLES("SHOWTABLES", 1054, null, null, true, false),
    SHOWCOLUMNS("SHOWCOLUMNS", 1046, null, null, true, false),
    SHOW_TABLESTATUS("SHOW_TABLESTATUS", 1065, null, null, true, false),
    SHOW_TBLPROPERTIES("SHOW_TBLPROPERTIES", 1066, null, null, true, false),
    SHOW_CREATEDATABASE("SHOW_CREATEDATABASE", 1057, new Privilege[]{Privilege.SELECT}, null),
    SHOW_CREATETABLE("SHOW_CREATETABLE", 1058, new Privilege[]{Privilege.SELECT}, null),
    SHOWFUNCTIONS("SHOWFUNCTIONS", 1050, null, null, true, false),
    SHOWPARTITIONS("SHOWPARTITIONS", 1053, null, null),
    SHOWLOCKS("SHOWLOCKS", new int[]{1051, 1049}, null, null, true, false),
    SHOWCONF("SHOWCONF", 1047, null, null),
    SHOWVIEWS("SHOWVIEWS", 1055, null, null, true, false),
    SHOWMATERIALIZEDVIEWS("SHOWMATERIALIZEDVIEWS", 1052, null, null, true, false),
    CREATEFUNCTION("CREATEFUNCTION", 822, null, null),
    DROPFUNCTION("DROPFUNCTION", 861, null, null),
    RELOADFUNCTION("RELOADFUNCTION", 1008, null, null),
    CREATEMACRO("CREATEMACRO", 823, null, null),
    DROPMACRO("DROPMACRO", 862, null, null),
    CREATEVIEW("CREATEVIEW", 826, new Privilege[]{Privilege.SELECT}, new Privilege[]{Privilege.CREATE}),
    CREATE_MATERIALIZED_VIEW("CREATE_MATERIALIZED_VIEW", 828, new Privilege[]{Privilege.SELECT}, new Privilege[]{Privilege.CREATE}),
    DROPVIEW("DROPVIEW", 865, null, new Privilege[]{Privilege.DROP}),
    DROP_MATERIALIZED_VIEW("DROP_MATERIALIZED_VIEW", 867, null, new Privilege[]{Privilege.DROP}),
    ALTER_MATERIALIZED_VIEW_REWRITE("ALTER_MATERIALIZED_VIEW_REWRITE", 792, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERVIEW_PROPERTIES("ALTERVIEW_PROPERTIES", new int[]{787, 786}, null, null),
    LOCKTABLE("LOCKTABLE", 939, new Privilege[]{Privilege.LOCK}, null),
    UNLOCKTABLE("UNLOCKTABLE", 1142, new Privilege[]{Privilege.LOCK}, null),
    CREATEROLE("CREATEROLE", 824, null, null),
    DROPROLE("DROPROLE", 863, null, null),
    GRANT_PRIVILEGE("GRANT_PRIVILEGE", 894, null, null),
    REVOKE_PRIVILEGE("REVOKE_PRIVILEGE", 1024, null, null),
    SHOW_GRANT("SHOW_GRANT", 1060, null, null, true, false),
    GRANT_ROLE("GRANT_ROLE", 896, null, null),
    REVOKE_ROLE("REVOKE_ROLE", 1025, null, null),
    SHOW_ROLES("SHOW_ROLES", new int[]{1061, 1059, 1045}, null, null, true, false),
    SHOW_ROLE_PRINCIPALS("SHOW_ROLE_PRINCIPALS", 1063, null, null, true, false),
    SHOW_ROLE_GRANT("SHOW_ROLE_GRANT", 1062, null, null, true, false),
    ALTERTABLE_FILEFORMAT("ALTERTABLE_FILEFORMAT", 764, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERPARTITION_FILEFORMAT("ALTERPARTITION_FILEFORMAT", 744, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_LOCATION("ALTERTABLE_LOCATION", 765, new Privilege[]{Privilege.ALTER_DATA}, null),
    ALTERPARTITION_LOCATION("ALTERPARTITION_LOCATION", 745, new Privilege[]{Privilege.ALTER_DATA}, null),
    CREATETABLE("CREATETABLE", 825, null, new Privilege[]{Privilege.CREATE}),
    TRUNCATETABLE("TRUNCATETABLE", 1132, null, new Privilege[]{Privilege.DROP}),
    CREATETABLE_AS_SELECT("CREATETABLE_AS_SELECT", null, new Privilege[]{Privilege.SELECT}, new Privilege[]{Privilege.CREATE}),
    QUERY("QUERY", 1003, new Privilege[]{Privilege.SELECT}, new Privilege[]{Privilege.ALTER_DATA, Privilege.CREATE}, true, false),
    ALTERDATABASE("ALTERDATABASE", 742, null, null),
    ALTERDATABASE_OWNER("ALTERDATABASE_OWNER", 741, null, null),
    ALTERDATABASE_LOCATION("ALTERDATABASE_LOCATION", 740, new Privilege[]{Privilege.ALTER_DATA}, null),
    DESCDATABASE("DESCDATABASE", 851, null, null),
    ALTERTABLE_MERGEFILES("ALTER_TABLE_MERGE", 766, new Privilege[]{Privilege.SELECT}, new Privilege[]{Privilege.ALTER_DATA}),
    ALTERPARTITION_MERGEFILES("ALTER_PARTITION_MERGE", 746, new Privilege[]{Privilege.SELECT}, new Privilege[]{Privilege.ALTER_DATA}),
    ALTERTABLE_SKEWED("ALTERTABLE_SKEWED", 776, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTBLPART_SKEWED_LOCATION("ALTERTBLPART_SKEWED_LOCATION", 777, new Privilege[]{Privilege.ALTER_DATA}, null),
    ALTERTABLE_PARTCOLTYPE("ALTERTABLE_PARTCOLTYPE", 768, new Privilege[]{Privilege.SELECT}, new Privilege[]{Privilege.ALTER_DATA}),
    ALTERTABLE_EXCHANGEPARTITION("ALTERTABLE_EXCHANGEPARTITION", 763, new Privilege[]{Privilege.SELECT, Privilege.DELETE}, new Privilege[]{Privilege.INSERT}),
    ALTERTABLE_DROPCONSTRAINT("ALTERTABLE_DROPCONSTRAINT", 760, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_ADDCONSTRAINT("ALTERTABLE_ADDCONSTRAINT", 753, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_UPDATECOLUMNS("ALTERTABLE_UPDATECOLUMNS", 781, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERVIEW_RENAME("ALTERVIEW_RENAME", 788, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERVIEW_AS("ALTERVIEW_AS", 783, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_COMPACT("ALTERTABLE_COMPACT", 759, new Privilege[]{Privilege.SELECT}, new Privilege[]{Privilege.ALTER_DATA}),
    SHOW_COMPACTIONS("SHOW COMPACTIONS", 1056, null, null, true, false),
    SHOW_TRANSACTIONS("SHOW TRANSACTIONS", 1067, null, null, true, false),
    START_TRANSACTION("START TRANSACTION", 1073, null, null, false, false),
    COMMIT("COMMIT", 819, null, null, true, true),
    ROLLBACK("ROLLBACK", 1030, null, null, true, true),
    SET_AUTOCOMMIT("SET AUTOCOMMIT", 1043, null, null, true, false),
    ABORT_TRANSACTIONS("ABORT TRANSACTIONS", 733, null, null, false, false),
    KILL_QUERY("KILL QUERY", 927, null, null),
    CREATE_RESOURCEPLAN("CREATE RESOURCEPLAN", 830, null, null, false, false),
    SHOW_RESOURCEPLAN("SHOW RESOURCEPLAN", 1064, null, null, false, false),
    ALTER_RESOURCEPLAN("ALTER RESOURCEPLAN", new int[]{802, 798, 800, 801, 797, 796, 799}, null, null, false, false),
    DROP_RESOURCEPLAN("DROP RESOURCEPLAN", 869, null, null, false, false),
    CREATE_TRIGGER("CREATE TRIGGER", 832, null, null, false, false),
    ALTER_TRIGGER("ALTER TRIGGER", 804, null, null, false, false),
    DROP_TRIGGER("DROP TRIGGER", 871, null, null, false, false),
    CREATE_POOL("CREATE POOL", 829, null, null, false, false),
    ALTER_POOL("ALTER POOL", new int[]{793, 794, 795}, null, null, false, false),
    DROP_POOL("DROP POOL", 868, null, null, false, false),
    CREATE_MAPPING("CREATE MAPPING", 827, null, null, false, false),
    ALTER_MAPPING("ALTER MAPPING", 789, null, null, false, false),
    DROP_MAPPING("DROP MAPPING", 866, null, null, false, false),
    CREATE_SCHEDULED_QUERY("CREATE SCHEDULED QUERY", 831, null, null),
    ALTER_SCHEDULED_QUERY("ALTER SCHEDULED QUERY", 803, null, null),
    DROP_SCHEDULED_QUERY("DROP SCHEDULED QUERY", 870, null, null);

    private final String operationName;
    private final int[] tokens;
    private final Privilege[] inputRequiredPrivileges;
    private final Privilege[] outputRequiredPrivileges;
    private final boolean allowedInTransaction;
    private final boolean requiresOpenTransaction;
    private static final Map<Integer, HiveOperation> TOKEN_TO_OPERATION;

    private HiveOperation(String operationName, int token, Privilege[] inputRequiredPrivileges, Privilege[] outputRequiredPrivileges) {
        this(operationName, new int[]{token}, inputRequiredPrivileges, outputRequiredPrivileges, false, false);
    }

    private HiveOperation(String operationName, int[] tokens, Privilege[] inputRequiredPrivileges, Privilege[] outputRequiredPrivileges) {
        this(operationName, tokens, inputRequiredPrivileges, outputRequiredPrivileges, false, false);
    }

    private HiveOperation(String operationName, int token, Privilege[] inputRequiredPrivileges, Privilege[] outputRequiredPrivileges, boolean allowedInTransaction, boolean requiresOpenTransaction) {
        this(operationName, new int[]{token}, inputRequiredPrivileges, outputRequiredPrivileges, allowedInTransaction, requiresOpenTransaction);
    }

    private HiveOperation(String operationName, int[] tokens, Privilege[] inputRequiredPrivileges, Privilege[] outputRequiredPrivileges, boolean allowedInTransaction, boolean requiresOpenTransaction) {
        this.operationName = operationName;
        this.tokens = tokens;
        this.inputRequiredPrivileges = inputRequiredPrivileges;
        this.outputRequiredPrivileges = outputRequiredPrivileges;
        this.requiresOpenTransaction = requiresOpenTransaction;
        this.allowedInTransaction = allowedInTransaction || requiresOpenTransaction;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public Privilege[] getInputRequiredPrivileges() {
        return this.inputRequiredPrivileges;
    }

    public Privilege[] getOutputRequiredPrivileges() {
        return this.outputRequiredPrivileges;
    }

    public boolean isAllowedInTransaction() {
        return this.allowedInTransaction;
    }

    public boolean isRequiresOpenTransaction() {
        return this.requiresOpenTransaction;
    }

    public static HiveOperation operationForToken(int token) {
        return TOKEN_TO_OPERATION.get(token);
    }

    static {
        TOKEN_TO_OPERATION = new HashMap<Integer, HiveOperation>();
        for (HiveOperation hiveOperation : HiveOperation.values()) {
            if (hiveOperation.tokens == null) continue;
            for (int token : hiveOperation.tokens) {
                TOKEN_TO_OPERATION.put(token, hiveOperation);
            }
        }
    }
}

