/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExplainConfiguration;
import org.apache.hadoop.hive.ql.parse.ParseContext;

public class ExplainWork
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Path resFile;
    private List<Task<?>> rootTasks;
    private Task<?> fetchTask;
    private Set<ReadEntity> inputs;
    private Set<WriteEntity> outputs;
    private ParseContext pCtx;
    private ExplainConfiguration config;
    private boolean appendTaskType;
    private String cboInfo;
    private String cboPlan;
    private String optimizedSQL;
    private transient BaseSemanticAnalyzer analyzer;

    public ExplainWork() {
    }

    public ExplainWork(Path resFile, ParseContext pCtx, List<Task<? extends Serializable>> rootTasks, Task<? extends Serializable> fetchTask, BaseSemanticAnalyzer analyzer, ExplainConfiguration config, String cboInfo, String optimizedSQL, String cboPlan) {
        this.resFile = resFile;
        this.rootTasks = new ArrayList<Task<? extends Serializable>>(rootTasks);
        this.fetchTask = fetchTask;
        this.analyzer = analyzer;
        if (analyzer != null) {
            this.inputs = analyzer.getInputs();
        }
        if (analyzer != null) {
            this.outputs = analyzer.getAllOutputs();
        }
        this.pCtx = pCtx;
        this.cboInfo = cboInfo;
        this.optimizedSQL = optimizedSQL;
        this.cboPlan = cboPlan;
        this.config = config;
    }

    public Path getResFile() {
        return this.resFile;
    }

    public void setResFile(Path resFile) {
        this.resFile = resFile;
    }

    public List<Task<?>> getRootTasks() {
        return this.rootTasks;
    }

    public void setRootTasks(List<Task<?>> rootTasks) {
        this.rootTasks = rootTasks;
    }

    public Task<? extends Serializable> getFetchTask() {
        return this.fetchTask;
    }

    public void setFetchTask(Task<? extends Serializable> fetchTask) {
        this.fetchTask = fetchTask;
    }

    public Set<ReadEntity> getInputs() {
        return this.inputs;
    }

    public void setInputs(Set<ReadEntity> inputs) {
        this.inputs = inputs;
    }

    public Set<WriteEntity> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(Set<WriteEntity> outputs) {
        this.outputs = outputs;
    }

    public boolean getExtended() {
        return this.config.isExtended();
    }

    public boolean getDependency() {
        return this.config.isDependency();
    }

    public boolean isFormatted() {
        return this.config.isFormatted();
    }

    public boolean isVectorization() {
        return this.config.isVectorization();
    }

    public boolean isVectorizationOnly() {
        return this.config.isVectorizationOnly();
    }

    public ExplainConfiguration.VectorizationDetailLevel isVectorizationDetailLevel() {
        return this.config.getVectorizationDetailLevel();
    }

    public boolean isDebug() {
        return this.config.isDebug();
    }

    public ParseContext getParseContext() {
        return this.pCtx;
    }

    public void setParseContext(ParseContext pCtx) {
        this.pCtx = pCtx;
    }

    public boolean isCbo() {
        return this.config.isCbo();
    }

    public boolean isLogical() {
        return this.config.isLogical();
    }

    public boolean isAppendTaskType() {
        return this.appendTaskType;
    }

    public void setAppendTaskType(boolean appendTaskType) {
        this.appendTaskType = appendTaskType;
    }

    public boolean isAuthorize() {
        return this.config.isAuthorize();
    }

    public BaseSemanticAnalyzer getAnalyzer() {
        return this.analyzer;
    }

    public boolean isUserLevelExplain() {
        return this.config.isUserLevelExplain();
    }

    public String getCboInfo() {
        return this.cboInfo;
    }

    public void setCboInfo(String cboInfo) {
        this.cboInfo = cboInfo;
    }

    public String getOptimizedSQL() {
        return this.optimizedSQL;
    }

    public void setOptimizedSQL(String optimizedSQL) {
        this.optimizedSQL = optimizedSQL;
    }

    public String getCboPlan() {
        return this.cboPlan;
    }

    public void setCboPlan(String cboPlan) {
        this.cboPlan = cboPlan;
    }

    public ExplainConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(ExplainConfiguration config) {
        this.config = config;
    }

    public boolean isLocks() {
        return this.config.isLocks();
    }
}

