/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hive.metastore.api.LockComponent;
import org.apache.hadoop.hive.metastore.api.LockType;

public class ExplainLockDesc {
    private String catalogName;
    private String dbName;
    private String tableName;
    private String partitionName;
    private LockType lockType;

    public ExplainLockDesc() {
    }

    public ExplainLockDesc(LockComponent component) {
        this.dbName = component.getDbname();
        if (null != component.getTablename()) {
            this.tableName = component.getTablename();
        }
        if (null != component.getPartitionname()) {
            this.partitionName = component.getPartitionname();
        }
        this.lockType = component.getType();
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public ExplainLockDesc setCatalogName(String catalogName) {
        this.catalogName = catalogName;
        return this;
    }

    public String getDbName() {
        return this.dbName;
    }

    public ExplainLockDesc setDbName(String dbName) {
        this.dbName = dbName;
        return this;
    }

    public String getTableName() {
        return this.tableName;
    }

    public ExplainLockDesc setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public ExplainLockDesc setPartitionName(String partitionName) {
        this.partitionName = partitionName;
        return this;
    }

    public LockType getLockType() {
        return this.lockType;
    }

    public ExplainLockDesc setLockType(LockType lockType) {
        this.lockType = lockType;
        return this;
    }

    public String getFullName() {
        ArrayList<String> list = new ArrayList<String>();
        if (null != this.catalogName) {
            list.add(this.catalogName);
        }
        if (null != this.dbName) {
            list.add(this.dbName);
        }
        if (null != this.tableName) {
            list.add(this.tableName);
        }
        if (null != this.partitionName) {
            list.add(this.partitionName);
        }
        return StringUtils.join(list, '.');
    }

    public String toString() {
        return this.getFullName() + " -> " + this.getLockType();
    }
}

