/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.load.message;

import java.io.Serializable;
import java.util.List;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc;
import org.apache.hadoop.hive.metastore.messaging.UpdateTableColumnStatMessage;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.repl.util.ReplUtils;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.load.message.AbstractMessageHandler;
import org.apache.hadoop.hive.ql.parse.repl.load.message.MessageHandler;

public class UpdateTableColStatHandler
extends AbstractMessageHandler {
    @Override
    public List<Task<? extends Serializable>> handle(MessageHandler.Context context) throws SemanticException {
        UpdateTableColumnStatMessage utcsm = this.deserializer.getUpdateTableColumnStatMessage(context.dmd.getPayload());
        ColumnStatistics colStats = utcsm.getColumnStatistics();
        if (colStats.getEngine() == null) {
            colStats.setEngine("hive");
        }
        ColumnStatisticsDesc colStatsDesc = colStats.getStatsDesc();
        colStatsDesc.setDbName(context.dbName);
        if (!context.isDbNameEmpty()) {
            this.updatedMetadata.set(context.dmd.getEventTo().toString(), context.dbName, colStatsDesc.getTableName(), null);
        }
        try {
            return ReplUtils.addTasksForLoadingColStats(colStats, context.hiveConf, this.updatedMetadata, utcsm.getTableObject(), utcsm.getWriteId());
        }
        catch (Exception e) {
            throw new SemanticException(e);
        }
    }
}

