/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.load.message;

import java.io.Serializable;
import java.util.List;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.metastore.messaging.AlterTableMessage;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.misc.truncate.TruncateTableDesc;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.repl.util.ReplUtils;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.load.message.AbstractMessageHandler;
import org.apache.hadoop.hive.ql.parse.repl.load.message.MessageHandler;

public class TruncateTableHandler
extends AbstractMessageHandler {
    @Override
    public List<Task<? extends Serializable>> handle(MessageHandler.Context context) throws SemanticException {
        AlterTableMessage msg = this.deserializer.getAlterTableMessage(context.dmd.getPayload());
        TableName tName = TableName.fromString(msg.getTable(), null, context.isDbNameEmpty() ? msg.getDB() : context.dbName);
        TruncateTableDesc truncateTableDesc = new TruncateTableDesc(tName, null, context.eventOnlyReplicationSpec());
        truncateTableDesc.setWriteId(msg.getWriteId());
        Task<DDLWork> truncateTableTask = TaskFactory.get(new DDLWork(this.readEntitySet, this.writeEntitySet, truncateTableDesc), context.hiveConf);
        context.log.debug("Added truncate tbl task : {}:{}:{}", new Object[]{truncateTableTask.getId(), truncateTableDesc.getTableName(), truncateTableDesc.getWriteId()});
        this.updatedMetadata.set(context.dmd.getEventTo().toString(), tName.getDb(), tName.getTable(), null);
        try {
            return ReplUtils.addOpenTxnTaskForMigration(tName.getDb(), tName.getTable(), context.hiveConf, this.updatedMetadata, truncateTableTask, msg.getTableObjBefore());
        }
        catch (Exception e) {
            throw new SemanticException(e.getMessage());
        }
    }
}

