/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.load.message;

import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.messaging.AlterPartitionMessage;
import org.apache.hadoop.hive.metastore.messaging.AlterTableMessage;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.repl.ReplExternalTables;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.EximUtil;
import org.apache.hadoop.hive.ql.parse.ImportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.DumpType;
import org.apache.hadoop.hive.ql.parse.repl.load.MetaData;
import org.apache.hadoop.hive.ql.parse.repl.load.message.AbstractMessageHandler;
import org.apache.hadoop.hive.ql.parse.repl.load.message.MessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableHandler
extends AbstractMessageHandler {
    private static final long DEFAULT_WRITE_ID = 0L;
    private static final Logger LOG = LoggerFactory.getLogger(TableHandler.class);

    @Override
    public List<Task<? extends Serializable>> handle(MessageHandler.Context context) throws SemanticException {
        try {
            ArrayList<Task<? extends Serializable>> importTasks = new ArrayList<Task<? extends Serializable>>();
            boolean isExternal = false;
            boolean isLocationSet = false;
            String parsedLocation = null;
            DumpType eventType = context.dmd.getDumpType();
            Tuple tuple = this.extract(context);
            if (tuple.isExternalTable) {
                URI fromURI = EximUtil.getValidatedURI(context.hiveConf, context.location);
                Path fromPath = new Path(fromURI.getScheme(), fromURI.getAuthority(), fromURI.getPath());
                isLocationSet = true;
                isExternal = true;
                FileSystem fs = FileSystem.get((URI)fromURI, (Configuration)context.hiveConf);
                try {
                    MetaData metaData = EximUtil.readMetaData(fs, new Path(fromPath, "_metadata"));
                    Table table = new Table(metaData.getTable());
                    parsedLocation = ReplExternalTables.externalTableLocation(context.hiveConf, table.getSd().getLocation());
                }
                catch (IOException iOException) {
                    throw new SemanticException(ErrorMsg.INVALID_PATH.getMsg(), iOException);
                }
            }
            context.nestedContext.setConf(context.hiveConf);
            EximUtil.SemanticAnalyzerWrapperContext x = new EximUtil.SemanticAnalyzerWrapperContext(context.hiveConf, context.db, this.readEntitySet, this.writeEntitySet, importTasks, context.log, context.nestedContext);
            x.setEventType(eventType);
            ImportSemanticAnalyzer.prepareImport(false, isLocationSet, isExternal, false, context.precursor != null, parsedLocation, null, context.dbName, null, context.location, x, this.updatedMetadata, context.getTxnMgr(), tuple.writeId);
            Task<? extends Serializable> openTxnTask = x.getOpenTxnTask();
            if (openTxnTask != null && !importTasks.isEmpty()) {
                for (Task task : importTasks) {
                    openTxnTask.addDependentTask(task);
                }
                importTasks.add(openTxnTask);
            }
            return importTasks;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SemanticException(e);
        }
    }

    private Tuple extract(MessageHandler.Context context) throws SemanticException {
        try {
            String tableType = null;
            long writeId = 0L;
            switch (context.dmd.getDumpType()) {
                case EVENT_CREATE_TABLE: 
                case EVENT_ADD_PARTITION: {
                    Path metadataPath = new Path(context.location, "_metadata");
                    MetaData rv = EximUtil.readMetaData(metadataPath.getFileSystem((Configuration)context.hiveConf), metadataPath);
                    tableType = rv.getTable().getTableType();
                    break;
                }
                case EVENT_ALTER_TABLE: {
                    AlterTableMessage alterTableMessage = this.deserializer.getAlterTableMessage(context.dmd.getPayload());
                    tableType = alterTableMessage.getTableObjAfter().getTableType();
                    writeId = alterTableMessage.getWriteId();
                    break;
                }
                case EVENT_ALTER_PARTITION: {
                    AlterPartitionMessage msg = this.deserializer.getAlterPartitionMessage(context.dmd.getPayload());
                    tableType = msg.getTableObj().getTableType();
                    writeId = msg.getWriteId();
                    break;
                }
            }
            boolean isExternalTable = tableType != null && TableType.EXTERNAL_TABLE.equals((Object)Enum.valueOf(TableType.class, tableType));
            return new Tuple(isExternalTable, writeId);
        }
        catch (Exception e) {
            LOG.error("failed to determine if the table associated with the event is external or not", (Throwable)e);
            throw new SemanticException(e);
        }
    }

    private static final class Tuple {
        private final boolean isExternalTable;
        private final long writeId;

        private Tuple(boolean isExternalTable, long writeId) {
            this.isExternalTable = isExternalTable;
            this.writeId = writeId;
        }
    }
}

