/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.load.message;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hive.metastore.messaging.AllocWriteIdMessage;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.load.message.AbstractMessageHandler;
import org.apache.hadoop.hive.ql.parse.repl.load.message.MessageHandler;
import org.apache.hadoop.hive.ql.plan.ReplTxnWork;

public class AllocWriteIdHandler
extends AbstractMessageHandler {
    @Override
    public List<Task<? extends Serializable>> handle(MessageHandler.Context context) throws SemanticException {
        if (!AcidUtils.isAcidEnabled(context.hiveConf)) {
            context.log.error("Cannot load alloc write id event as acid is not enabled");
            throw new SemanticException("Cannot load alloc write id event as acid is not enabled");
        }
        AllocWriteIdMessage msg = this.deserializer.getAllocWriteIdMessage(context.dmd.getPayload());
        String dbName = context.dbName != null && !context.dbName.isEmpty() ? context.dbName : msg.getDB();
        String tableName = msg.getTableName();
        ReplTxnWork work = new ReplTxnWork(HiveUtils.getReplPolicy(context.dbName), dbName, tableName, ReplTxnWork.OperationType.REPL_ALLOC_WRITE_ID, msg.getTxnToWriteIdList(), context.eventOnlyReplicationSpec());
        Task<ReplTxnWork> allocWriteIdTask = TaskFactory.get(work, context.hiveConf);
        context.log.info("Added alloc write id task : {}", (Object)allocWriteIdTask.getId());
        this.updatedMetadata.set(context.dmd.getEventTo().toString(), dbName, tableName, null);
        return Collections.singletonList(allocWriteIdTask);
    }
}

