/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.load;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.repl.ReplScope;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.DumpType;
import org.apache.hadoop.hive.ql.parse.repl.dump.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DumpMetaData {
    private static final String DUMP_METADATA = "_dumpmetadata";
    private static final Logger LOG = LoggerFactory.getLogger(DumpMetaData.class);
    private DumpType dumpType;
    private Long eventFrom = null;
    private Long eventTo = null;
    private Path cmRoot;
    private String payload = null;
    private ReplScope replScope = null;
    private boolean initialized = false;
    private final Path dumpFile;
    private final HiveConf hiveConf;

    public DumpMetaData(Path dumpRoot, HiveConf hiveConf) {
        this.hiveConf = hiveConf;
        this.dumpFile = new Path(dumpRoot, DUMP_METADATA);
    }

    public DumpMetaData(Path dumpRoot, DumpType lvl, Long eventFrom, Long eventTo, Path cmRoot, HiveConf hiveConf) {
        this(dumpRoot, hiveConf);
        this.setDump(lvl, eventFrom, eventTo, cmRoot);
    }

    public void setDump(DumpType lvl, Long eventFrom, Long eventTo, Path cmRoot) {
        this.dumpType = lvl;
        this.eventFrom = eventFrom;
        this.eventTo = eventTo;
        this.cmRoot = cmRoot;
        this.initialized = true;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public void setReplScope(ReplScope replScope) {
        this.replScope = replScope;
    }

    private void readReplScope(String line) throws IOException {
        if (line == null) {
            return;
        }
        String[] lineContents = line.split("\t");
        this.replScope = new ReplScope();
        block5: for (int idx = 0; idx < lineContents.length; ++idx) {
            String value = lineContents[idx];
            switch (idx) {
                case 0: {
                    LOG.info("Read ReplScope: Set Db Name: {}.", (Object)value);
                    this.replScope.setDbName(value);
                    continue block5;
                }
                case 1: {
                    LOG.info("Read ReplScope: Include table name list: {}.", (Object)value);
                    this.replScope.setIncludedTablePatterns(value);
                    continue block5;
                }
                case 2: {
                    LOG.info("Read ReplScope: Exclude table name list: {}.", (Object)value);
                    this.replScope.setExcludedTablePatterns(value);
                    continue block5;
                }
                default: {
                    throw new IOException("Invalid repl tables list data in dump metadata file");
                }
            }
        }
    }

    private void loadDumpFromFile() throws SemanticException {
        BufferedReader br = null;
        try {
            FileSystem fs = this.dumpFile.getFileSystem((Configuration)this.hiveConf);
            br = new BufferedReader(new InputStreamReader((InputStream)fs.open(this.dumpFile)));
            String line = br.readLine();
            if (line == null) {
                throw new IOException("Unable to read valid values from dumpFile:" + this.dumpFile.toUri().toString());
            }
            String[] lineContents = line.split("\t", 5);
            this.setDump(DumpType.valueOf(lineContents[0]), Long.valueOf(lineContents[1]), Long.valueOf(lineContents[2]), new Path(lineContents[3]));
            this.setPayload(lineContents[4].equals("NULL") ? null : lineContents[4]);
            this.readReplScope(br.readLine());
        }
        catch (IOException ioe) {
            throw new SemanticException(ioe);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    throw new SemanticException(e);
                }
            }
        }
    }

    public DumpType getDumpType() throws SemanticException {
        this.initializeIfNot();
        return this.dumpType;
    }

    public String getPayload() throws SemanticException {
        this.initializeIfNot();
        return this.payload;
    }

    public Long getEventFrom() throws SemanticException {
        this.initializeIfNot();
        return this.eventFrom;
    }

    public Long getEventTo() throws SemanticException {
        this.initializeIfNot();
        return this.eventTo;
    }

    public ReplScope getReplScope() throws SemanticException {
        this.initializeIfNot();
        return this.replScope;
    }

    public Path getDumpFilePath() {
        return this.dumpFile;
    }

    public boolean isIncrementalDump() throws SemanticException {
        this.initializeIfNot();
        return this.dumpType == DumpType.INCREMENTAL;
    }

    private void initializeIfNot() throws SemanticException {
        if (!this.initialized) {
            this.loadDumpFromFile();
        }
    }

    private List<String> prepareReplScopeValues() {
        assert (this.replScope != null);
        ArrayList<String> values = new ArrayList<String>();
        values.add(this.replScope.getDbName());
        String includedTableNames = this.replScope.getIncludedTableNames();
        String excludedTableNames = this.replScope.getExcludedTableNames();
        if (includedTableNames != null) {
            values.add(includedTableNames);
        }
        if (excludedTableNames != null) {
            values.add(excludedTableNames);
        }
        LOG.info("Preparing ReplScope {} to dump.", values);
        return values;
    }

    public void write() throws SemanticException {
        ArrayList<List<String>> listValues = new ArrayList<List<String>>();
        listValues.add(Arrays.asList(this.dumpType.toString(), this.eventFrom.toString(), this.eventTo.toString(), this.cmRoot.toString(), this.payload));
        if (this.replScope != null) {
            listValues.add(this.prepareReplScopeValues());
        }
        Utils.writeOutput(listValues, this.dumpFile, this.hiveConf);
    }
}

