/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.dump.log;

import org.apache.hadoop.hive.ql.parse.repl.ReplLogger;
import org.apache.hadoop.hive.ql.parse.repl.ReplState;
import org.apache.hadoop.hive.ql.parse.repl.dump.log.state.IncrementalDumpBegin;
import org.apache.hadoop.hive.ql.parse.repl.dump.log.state.IncrementalDumpEnd;
import org.apache.hadoop.hive.ql.parse.repl.dump.log.state.IncrementalDumpEvent;

public class IncrementalDumpLogger
extends ReplLogger {
    private String dbName;
    private String dumpDir;
    private long estimatedNumEvents;
    private long eventSeqNo;
    private Long fromEventId;
    private Long toEventId;
    private int maxEvents;

    public IncrementalDumpLogger(String dbName, String dumpDir, long estimatedNumEvents, Long fromEventId, Long toEventId, int maxEvents) {
        this.dbName = dbName;
        this.dumpDir = dumpDir;
        this.estimatedNumEvents = estimatedNumEvents;
        this.eventSeqNo = 0L;
        this.fromEventId = fromEventId;
        this.toEventId = toEventId;
        this.maxEvents = maxEvents;
    }

    @Override
    public void startLog() {
        new IncrementalDumpBegin(this.dbName, this.estimatedNumEvents, this.fromEventId, this.toEventId, Long.valueOf(this.maxEvents)).log(ReplState.LogTag.START);
    }

    @Override
    public void eventLog(String eventId, String eventType) {
        ++this.eventSeqNo;
        new IncrementalDumpEvent(this.dbName, eventId, eventType, this.eventSeqNo, this.estimatedNumEvents).log(ReplState.LogTag.EVENT_DUMP);
    }

    @Override
    public void endLog(String lastReplId) {
        new IncrementalDumpEnd(this.dbName, this.eventSeqNo, this.dumpDir, lastReplId).log(ReplState.LogTag.END);
    }
}

