/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.dump.events;

import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.messaging.UpdatePartitionColumnStatMessage;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.repl.DumpType;
import org.apache.hadoop.hive.ql.parse.repl.dump.Utils;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.AbstractEventHandler;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.EventHandler;
import org.apache.hadoop.hive.ql.parse.repl.load.DumpMetaData;

class UpdatePartColStatHandler
extends AbstractEventHandler<UpdatePartitionColumnStatMessage> {
    UpdatePartColStatHandler(NotificationEvent event) {
        super(event);
    }

    @Override
    UpdatePartitionColumnStatMessage eventMessage(String stringRepresentation) {
        return this.deserializer.getUpdatePartitionColumnStatMessage(stringRepresentation);
    }

    @Override
    public void handle(EventHandler.Context withinContext) throws Exception {
        LOG.info("Processing#{} UpdatePartitionTableColumnStat message : {}", (Object)this.fromEventId(), (Object)this.eventMessageAsJSON);
        org.apache.hadoop.hive.metastore.api.Table tableObj = ((UpdatePartitionColumnStatMessage)this.eventMessage).getTableObject();
        if (tableObj == null) {
            LOG.debug("Event#{} was an event of type {} with no table listed", (Object)this.fromEventId(), (Object)this.event.getEventType());
            return;
        }
        if (withinContext.replicationSpec.isMetadataOnly()) {
            return;
        }
        if (!Utils.shouldReplicate(withinContext.replicationSpec, new Table(tableObj), true, withinContext.getTablesForBootstrap(), withinContext.oldReplScope, withinContext.hiveConf)) {
            return;
        }
        DumpMetaData dmd = withinContext.createDmd(this);
        dmd.setPayload(this.eventMessageAsJSON);
        dmd.write();
    }

    @Override
    public DumpType dumpType() {
        return DumpType.EVENT_UPDATE_PART_COL_STAT;
    }
}

