/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.dump.events;

import java.util.Set;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.repl.ReplScope;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.repl.DumpType;
import org.apache.hadoop.hive.ql.parse.repl.load.DumpMetaData;

public interface EventHandler {
    public void handle(Context var1) throws Exception;

    public long fromEventId();

    public long toEventId();

    public DumpType dumpType();

    public static class Context {
        Path eventRoot;
        final Path cmRoot;
        final Hive db;
        final HiveConf hiveConf;
        final ReplicationSpec replicationSpec;
        final ReplScope replScope;
        final ReplScope oldReplScope;
        private Set<String> tablesForBootstrap;

        public Context(Path eventRoot, Path cmRoot, Hive db, HiveConf hiveConf, ReplicationSpec replicationSpec, ReplScope replScope, ReplScope oldReplScope, Set<String> tablesForBootstrap) {
            this.eventRoot = eventRoot;
            this.cmRoot = cmRoot;
            this.db = db;
            this.hiveConf = hiveConf;
            this.replicationSpec = replicationSpec;
            this.replScope = replScope;
            this.oldReplScope = oldReplScope;
            this.tablesForBootstrap = tablesForBootstrap;
        }

        public Context(Context other) {
            this.eventRoot = other.eventRoot;
            this.cmRoot = other.cmRoot;
            this.db = other.db;
            this.hiveConf = other.hiveConf;
            this.replicationSpec = other.replicationSpec;
            this.replScope = other.replScope;
            this.oldReplScope = other.oldReplScope;
            this.tablesForBootstrap = other.tablesForBootstrap;
        }

        void setEventRoot(Path eventRoot) {
            this.eventRoot = eventRoot;
        }

        DumpMetaData createDmd(EventHandler eventHandler) {
            return new DumpMetaData(this.eventRoot, eventHandler.dumpType(), eventHandler.fromEventId(), eventHandler.toEventId(), this.cmRoot, this.hiveConf);
        }

        Set<String> getTablesForBootstrap() {
            return this.tablesForBootstrap;
        }

        void addToListOfTablesForBootstrap(String tableName) {
            assert (tableName != null);
            this.tablesForBootstrap.add(tableName.toLowerCase());
        }

        boolean removeFromListOfTablesForBootstrap(String tableName) {
            assert (tableName != null);
            return this.tablesForBootstrap.remove(tableName.toLowerCase());
        }
    }
}

