/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.dump.events;

import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.messaging.EventMessage;
import org.apache.hadoop.hive.metastore.messaging.MessageDeserializer;
import org.apache.hadoop.hive.metastore.messaging.MessageEncoder;
import org.apache.hadoop.hive.metastore.messaging.MessageFactory;
import org.apache.hadoop.hive.metastore.messaging.json.JSONMessageEncoder;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractEventHandler<T extends EventMessage>
implements EventHandler {
    static final Logger LOG = LoggerFactory.getLogger(AbstractEventHandler.class);
    static final MessageEncoder jsonMessageEncoder = JSONMessageEncoder.getInstance();
    final NotificationEvent event;
    final MessageDeserializer deserializer;
    final String eventMessageAsJSON;
    final T eventMessage;

    AbstractEventHandler(NotificationEvent event) {
        this.event = event;
        try {
            this.deserializer = MessageFactory.getInstance(event.getMessageFormat()).getDeserializer();
        }
        catch (Exception e) {
            String message = "could not create appropriate messageFactory for format " + event.getMessageFormat();
            LOG.error(message, (Throwable)e);
            throw new IllegalStateException(message, e);
        }
        this.eventMessage = this.eventMessage(event.getMessage());
        this.eventMessageAsJSON = this.eventMessageAsJSON(this.eventMessage);
    }

    abstract T eventMessage(String var1);

    private String eventMessageAsJSON(T eventMessage) {
        if (eventMessage == null) {
            return null;
        }
        return jsonMessageEncoder.getSerializer().serialize((EventMessage)eventMessage);
    }

    @Override
    public long fromEventId() {
        return this.event.getEventId();
    }

    @Override
    public long toEventId() {
        return this.event.getEventId();
    }
}

