/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.dump;

import com.google.common.collect.Collections2;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.repl.ReplScope;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.repl.util.ReplUtils;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static Logger LOG = LoggerFactory.getLogger(Utils.class);
    public static final String BOOTSTRAP_DUMP_STATE_KEY_PREFIX = "bootstrap.dump.state.";

    public static void writeOutput(List<List<String>> listValues, Path outputFile, HiveConf hiveConf) throws SemanticException {
        FSDataOutputStream outStream = null;
        try {
            FileSystem fs = outputFile.getFileSystem((Configuration)hiveConf);
            outStream = fs.create(outputFile);
            for (List<String> values : listValues) {
                outStream.writeBytes(values.get(0) == null ? "NULL" : values.get(0));
                for (int i = 1; i < values.size(); ++i) {
                    outStream.write(9);
                    outStream.writeBytes(values.get(i) == null ? "NULL" : values.get(i));
                }
                outStream.write(10);
            }
        }
        catch (IOException e) {
            try {
                throw new SemanticException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(outStream);
                throw throwable;
            }
        }
        IOUtils.closeStream((Closeable)outStream);
    }

    public static Iterable<String> matchesDb(Hive db, String dbPattern) throws HiveException {
        if (dbPattern == null) {
            return db.getAllDatabases();
        }
        return db.getDatabasesByPattern(dbPattern);
    }

    public static Iterable<String> matchesTbl(Hive db, String dbName, String tblPattern) throws HiveException {
        if (tblPattern == null) {
            return Utils.getAllTables(db, dbName, null);
        }
        return db.getTablesByPattern(dbName, tblPattern);
    }

    public static Iterable<String> matchesTbl(Hive db, String dbName, ReplScope replScope) throws HiveException {
        return Utils.getAllTables(db, dbName, replScope);
    }

    public static Collection<String> getAllTables(Hive db, String dbName, ReplScope replScope) throws HiveException {
        return Collections2.filter(db.getAllTables(dbName), tableName -> {
            assert (tableName != null);
            return !tableName.toLowerCase().startsWith("Values__Tmp__Table__".toLowerCase()) && (replScope == null || replScope.tableIncludedInReplScope((String)tableName));
        });
    }

    public static String setDbBootstrapDumpState(Hive hiveDb, String dbName) throws HiveException {
        Database database = hiveDb.getDatabase(dbName);
        if (database == null) {
            return null;
        }
        HashMap<String, String> newParams = new HashMap<String, String>();
        String uniqueKey = BOOTSTRAP_DUMP_STATE_KEY_PREFIX + UUID.randomUUID().toString();
        newParams.put(uniqueKey, ReplDumpState.ACTIVE.name());
        Map<String, String> params = database.getParameters();
        if (params != null) {
            params.putAll(newParams);
            database.setParameters(params);
        } else {
            database.setParameters(newParams);
        }
        hiveDb.alterDatabase(dbName, database);
        LOG.info("REPL DUMP:: Set property for Database: {}, Property: {}, Value: {}", new Object[]{dbName, uniqueKey, ReplDumpState.ACTIVE.name()});
        return uniqueKey;
    }

    public static void resetDbBootstrapDumpState(Hive hiveDb, String dbName, String uniqueKey) throws HiveException {
        Map<String, String> params;
        Database database = hiveDb.getDatabase(dbName);
        if (database != null && (params = database.getParameters()) != null && params.containsKey(uniqueKey)) {
            params.remove(uniqueKey);
            database.setParameters(params);
            hiveDb.alterDatabase(dbName, database);
            LOG.info("REPL DUMP:: Reset property for Database: {}, Property: {}", (Object)dbName, (Object)uniqueKey);
        }
    }

    public static boolean isBootstrapDumpInProgress(Hive hiveDb, String dbName) throws HiveException {
        Database database = hiveDb.getDatabase(dbName);
        if (database == null) {
            return false;
        }
        Map<String, String> params = database.getParameters();
        if (params == null) {
            return false;
        }
        for (String key : params.keySet()) {
            if (!key.startsWith(BOOTSTRAP_DUMP_STATE_KEY_PREFIX) || !params.get(key).equals(ReplDumpState.ACTIVE.name())) continue;
            return true;
        }
        return false;
    }

    public static boolean shouldReplicate(ReplicationSpec replicationSpec, Table tableHandle, boolean isEventDump, Set<String> bootstrapTableList, ReplScope oldReplScope, HiveConf hiveConf) {
        if (replicationSpec == null) {
            replicationSpec = new ReplicationSpec();
        }
        if (replicationSpec.isNoop() || tableHandle == null) {
            return false;
        }
        if (tableHandle.isNonNative() && !replicationSpec.isMetadataOnly()) {
            return false;
        }
        if (replicationSpec.isInReplicationScope()) {
            if (tableHandle.isTemporary()) {
                return false;
            }
            if (MetaStoreUtils.isExternalTable(tableHandle.getTTable())) {
                boolean shouldReplicateExternalTables;
                boolean bl = shouldReplicateExternalTables = hiveConf.getBoolVar(HiveConf.ConfVars.REPL_INCLUDE_EXTERNAL_TABLES) || replicationSpec.isMetadataOnly();
                if (isEventDump) {
                    shouldReplicateExternalTables = shouldReplicateExternalTables && !hiveConf.getBoolVar(HiveConf.ConfVars.REPL_BOOTSTRAP_EXTERNAL_TABLES) && ReplUtils.tableIncludedInReplScope(oldReplScope, tableHandle.getTableName());
                }
                return shouldReplicateExternalTables;
            }
            if (AcidUtils.isTransactionalTable(tableHandle.getTTable())) {
                if (!ReplUtils.includeAcidTableInDump(hiveConf)) {
                    return false;
                }
                if (isEventDump && hiveConf.getBoolVar(HiveConf.ConfVars.REPL_BOOTSTRAP_ACID_TABLES)) {
                    return false;
                }
            }
            if (isEventDump) {
                if (!ReplUtils.tableIncludedInReplScope(oldReplScope, tableHandle.getTableName())) {
                    return false;
                }
                return bootstrapTableList == null || !bootstrapTableList.contains(tableHandle.getTableName().toLowerCase());
            }
        }
        return true;
    }

    public static boolean shouldReplicate(NotificationEvent tableForEvent, ReplicationSpec replicationSpec, Hive db, boolean isEventDump, Set<String> bootstrapTableList, ReplScope oldReplScope, HiveConf hiveConf) {
        Table table;
        try {
            table = db.getTable(tableForEvent.getDbName(), tableForEvent.getTableName());
        }
        catch (HiveException e) {
            LOG.info("error while getting table info for" + tableForEvent.getDbName() + "." + tableForEvent.getTableName(), (Throwable)e);
            return false;
        }
        return Utils.shouldReplicate(replicationSpec, table, isEventDump, bootstrapTableList, oldReplScope, hiveConf);
    }

    static List<Path> getDataPathList(Path fromPath, ReplicationSpec replicationSpec, HiveConf conf) throws IOException {
        if (replicationSpec.isTransactionalTableDump()) {
            try {
                conf.set("hive.txn.valid.txns", replicationSpec.getValidTxnList());
                return AcidUtils.getValidDataPaths(fromPath, conf, replicationSpec.getValidWriteIdList());
            }
            catch (FileNotFoundException e) {
                throw new IOException(ErrorMsg.FILE_NOT_FOUND.format(e.getMessage()), e);
            }
        }
        return Collections.singletonList(fromPath);
    }

    public static boolean shouldDumpMetaDataOnly(Table table, HiveConf conf) {
        return conf.getBoolVar(HiveConf.ConfVars.REPL_DUMP_METADATA_ONLY) || conf.getBoolVar(HiveConf.ConfVars.REPL_INCLUDE_EXTERNAL_TABLES) && table.getTableType().equals((Object)TableType.EXTERNAL_TABLE) && conf.getBoolVar(HiveConf.ConfVars.REPL_DUMP_METADATA_ONLY_FOR_EXTERNAL_TABLE);
    }

    public static enum ReplDumpState {
        IDLE,
        ACTIVE;

    }
}

