/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.hooks.Entity;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.InvalidTableException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.ColumnAccessInfo;
import org.apache.hadoop.hive.ql.parse.ParseException;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RewriteSemanticAnalyzer
extends SemanticAnalyzer {
    protected static final Logger LOG = LoggerFactory.getLogger(RewriteSemanticAnalyzer.class);
    protected boolean useSuper = false;

    RewriteSemanticAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode tree) throws SemanticException {
        if (this.useSuper) {
            super.analyzeInternal(tree);
        } else {
            if (!this.getTxnMgr().supportsAcid()) {
                throw new SemanticException(ErrorMsg.ACID_OP_ON_NONACID_TXNMGR.getMsg());
            }
            this.analyze(tree);
            this.cleanUpMetaColumnAccessControl();
        }
    }

    protected abstract void analyze(ASTNode var1) throws SemanticException;

    protected void addPartitionColsToSelect(List<FieldSchema> partCols, StringBuilder rewrittenQueryStr, ASTNode target) throws SemanticException {
        String targetName;
        String string = targetName = target != null ? this.getSimpleTableName(target) : null;
        if (partCols != null) {
            for (FieldSchema fschema : partCols) {
                rewrittenQueryStr.append(", ");
                if (targetName != null) {
                    rewrittenQueryStr.append(targetName).append('.');
                }
                rewrittenQueryStr.append(HiveUtils.unparseIdentifier(fschema.getName(), this.conf));
            }
        }
    }

    protected void checkValidSetClauseTarget(ASTNode colName, Table targetTable) throws SemanticException {
        String columnName = RewriteSemanticAnalyzer.normalizeColName(colName.getText());
        for (FieldSchema fschema : targetTable.getPartCols()) {
            if (!fschema.getName().equalsIgnoreCase(columnName)) continue;
            throw new SemanticException(ErrorMsg.UPDATE_CANNOT_UPDATE_PART_VALUE.getMsg());
        }
        if (targetTable.getBucketCols() != null && targetTable.getBucketCols().contains(columnName)) {
            throw new SemanticException(ErrorMsg.UPDATE_CANNOT_UPDATE_BUCKET_VALUE, columnName);
        }
        boolean foundColumnInTargetTable = false;
        for (FieldSchema col : targetTable.getCols()) {
            if (!columnName.equalsIgnoreCase(col.getName())) continue;
            foundColumnInTargetTable = true;
            break;
        }
        if (!foundColumnInTargetTable) {
            throw new SemanticException(ErrorMsg.INVALID_TARGET_COLUMN_IN_SET_CLAUSE, colName.getText(), targetTable.getFullyQualifiedName());
        }
    }

    protected ASTNode findLHSofAssignment(ASTNode assignment) {
        assert (assignment.getToken().getType() == 18) : "Expected set assignments to use equals operator but found " + assignment.getName();
        ASTNode tableOrColTok = (ASTNode)((ArrayList)assignment.getChildren()).get(0);
        assert (tableOrColTok.getToken().getType() == 1112) : "Expected left side of assignment to be table or column";
        ASTNode colName = (ASTNode)((ArrayList)tableOrColTok.getChildren()).get(0);
        assert (colName.getToken().getType() == 24) : "Expected column name";
        return colName;
    }

    protected Map<String, ASTNode> collectSetColumnsAndExpressions(ASTNode setClause, Set<String> setRCols, Table targetTable) throws SemanticException {
        assert (setClause.getToken().getType() == 1044) : "Expected second child of update token to be set token";
        List assignments = setClause.getChildren();
        LinkedHashMap<String, ASTNode> setCols = new LinkedHashMap<String, ASTNode>(assignments.size());
        for (Node a : assignments) {
            ASTNode assignment = (ASTNode)a;
            ASTNode colName = this.findLHSofAssignment(assignment);
            if (setRCols != null) {
                this.addSetRCols((ASTNode)((ArrayList)assignment.getChildren()).get(1), setRCols);
            }
            this.checkValidSetClauseTarget(colName, targetTable);
            String columnName = RewriteSemanticAnalyzer.normalizeColName(colName.getText());
            setCols.put(columnName, (ASTNode)((ArrayList)assignment.getChildren()).get(1));
        }
        return setCols;
    }

    protected Table getTargetTable(ASTNode tabRef) throws SemanticException {
        return RewriteSemanticAnalyzer.getTable(tabRef, this.db, true);
    }

    protected static Table getTable(ASTNode tabRef, Hive db, boolean throwException) throws SemanticException {
        Table mTable;
        TableName tableName;
        switch (tabRef.getType()) {
            case 1116: {
                tableName = RewriteSemanticAnalyzer.getQualifiedTableName((ASTNode)tabRef.getChild(0));
                break;
            }
            case 1115: {
                tableName = RewriteSemanticAnalyzer.getQualifiedTableName(tabRef);
                break;
            }
            default: {
                throw RewriteSemanticAnalyzer.raiseWrongType("TOK_TABREF|TOK_TABNAME", tabRef);
            }
        }
        try {
            mTable = db.getTable(tableName.getDb(), tableName.getTable(), throwException);
        }
        catch (InvalidTableException e) {
            LOG.error("Failed to find table " + tableName.getNotEmptyDbTable() + " got exception " + e.getMessage());
            throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(tableName.getNotEmptyDbTable()), e);
        }
        catch (HiveException e) {
            LOG.error("Failed to find table " + tableName.getNotEmptyDbTable() + " got exception " + e.getMessage());
            throw new SemanticException(e.getMessage(), e);
        }
        return mTable;
    }

    protected void markReadEntityForUpdate() {
        for (ReadEntity input : this.inputs) {
            if (!this.isWritten(input)) continue;
            input.setUpdateOrDelete(true);
        }
    }

    protected void setUpAccessControlInfoForUpdate(Table mTable, Map<String, ASTNode> setCols) {
        ColumnAccessInfo cai = new ColumnAccessInfo();
        for (String colName : setCols.keySet()) {
            cai.add(Table.getCompleteName(mTable.getDbName(), mTable.getTableName()), colName);
        }
        this.setUpdateColumnAccessInfo(cai);
    }

    private void cleanUpMetaColumnAccessControl() {
        if (this.columnAccessInfo != null) {
            this.columnAccessInfo.stripVirtualColumn(VirtualColumn.ROWID);
        }
    }

    protected ReparseResult parseRewrittenQuery(StringBuilder rewrittenQueryStr, String originalQuery) throws SemanticException {
        ASTNode rewrittenTree;
        Context rewrittenCtx;
        HiveConf.setVar(this.conf, HiveConf.ConfVars.DYNAMICPARTITIONINGMODE, "nonstrict");
        HiveConf.setBoolVar(this.conf, HiveConf.ConfVars.LLAP_IO_ROW_WRAPPER_ENABLED, false);
        try {
            rewrittenCtx = new Context(this.conf);
            rewrittenCtx.setHDFSCleanup(true);
            this.ctx.addRewrittenStatementContext(rewrittenCtx);
        }
        catch (IOException e) {
            throw new SemanticException(ErrorMsg.UPDATEDELETE_IO_ERROR.getMsg());
        }
        rewrittenCtx.setExplainConfig(this.ctx.getExplainConfig());
        rewrittenCtx.setExplainPlan(this.ctx.isExplainPlan());
        rewrittenCtx.setStatsSource(this.ctx.getStatsSource());
        rewrittenCtx.setPlanMapper(this.ctx.getPlanMapper());
        rewrittenCtx.setIsUpdateDeleteMerge(true);
        rewrittenCtx.setCmd(rewrittenQueryStr.toString());
        try {
            LOG.info("Going to reparse <" + originalQuery + "> as \n<" + rewrittenQueryStr.toString() + ">");
            rewrittenTree = ParseUtils.parse(rewrittenQueryStr.toString(), rewrittenCtx);
        }
        catch (ParseException e) {
            throw new SemanticException(ErrorMsg.UPDATEDELETE_PARSE_ERROR.getMsg(), e);
        }
        return new ReparseResult(rewrittenTree, rewrittenCtx);
    }

    protected void validateTargetTable(Table mTable) throws SemanticException {
        if (mTable.getTableType() == TableType.VIRTUAL_VIEW || mTable.getTableType() == TableType.MATERIALIZED_VIEW) {
            LOG.error("Table " + mTable.getFullyQualifiedName() + " is a view or materialized view");
            throw new SemanticException(ErrorMsg.UPDATE_DELETE_VIEW.getMsg());
        }
    }

    private boolean isWritten(Entity readEntity) {
        for (Entity writeEntity : this.outputs) {
            if (!writeEntity.toString().equalsIgnoreCase(readEntity.toString())) continue;
            return true;
        }
        return false;
    }

    private void addSetRCols(ASTNode node, Set<String> setRCols) {
        if (node.getToken().getType() == 1112) {
            ASTNode colName = (ASTNode)((ArrayList)node.getChildren()).get(0);
            assert (colName.getToken().getType() == 24) : "Expected column name";
            setRCols.add(RewriteSemanticAnalyzer.normalizeColName(colName.getText()));
        } else if (node.getChildren() != null) {
            for (Node n : node.getChildren()) {
                this.addSetRCols((ASTNode)n, setRCols);
            }
        }
    }

    private static String normalizeColName(String colName) {
        return colName.toLowerCase();
    }

    protected void updateOutputs(Table targetTable) {
        List<ReadEntity> partitionsRead;
        this.markReadEntityForUpdate();
        if (targetTable.isPartitioned() && !(partitionsRead = this.getRestrictedPartitionSet(targetTable)).isEmpty()) {
            ArrayList<WriteEntity> toRemove = new ArrayList<WriteEntity>();
            for (WriteEntity we : this.outputs) {
                WriteEntity.WriteType wt = we.getWriteType();
                if (!this.isTargetTable(we, targetTable) || wt != WriteEntity.WriteType.UPDATE && wt != WriteEntity.WriteType.DELETE) continue;
                toRemove.add(we);
            }
            this.outputs.removeAll(toRemove);
            for (ReadEntity re : partitionsRead) {
                for (WriteEntity original : toRemove) {
                    WriteEntity we = new WriteEntity(re.getPartition(), original.getWriteType());
                    we.setDynamicPartitionWrite(original.isDynamicPartitionWrite());
                    this.outputs.add(we);
                }
            }
        }
    }

    private List<ReadEntity> getRestrictedPartitionSet(Table targetTable) {
        ArrayList<ReadEntity> partitionsRead = new ArrayList<ReadEntity>();
        for (ReadEntity re : this.inputs) {
            if (!re.isFromTopLevelQuery || re.getType() != Entity.Type.PARTITION || !this.isTargetTable(re, targetTable)) continue;
            partitionsRead.add(re);
        }
        return partitionsRead;
    }

    private boolean isTargetTable(Entity entity, Table targetTable) {
        return targetTable.equals(entity.getTable());
    }

    protected String getSimpleTableName(ASTNode n) throws SemanticException {
        return HiveUtils.unparseIdentifier(this.getSimpleTableNameBase(n), this.conf);
    }

    protected String getSimpleTableNameBase(ASTNode n) throws SemanticException {
        switch (n.getType()) {
            case 1116: {
                int aliasIndex = this.findTabRefIdxs(n)[0];
                if (aliasIndex != 0) {
                    return n.getChild(aliasIndex).getText();
                }
                return this.getSimpleTableNameBase((ASTNode)n.getChild(0));
            }
            case 1115: {
                if (n.getChildCount() == 2) {
                    return n.getChild(1).getText();
                }
                return n.getChild(0).getText();
            }
            case 1079: {
                return n.getChild(1).getText();
            }
        }
        throw RewriteSemanticAnalyzer.raiseWrongType("TOK_TABREF|TOK_TABNAME|TOK_SUBQUERY", n);
    }

    protected static final class ReparseResult {
        final ASTNode rewrittenTree;
        final Context rewrittenCtx;

        ReparseResult(ASTNode n, Context c) {
            this.rewrittenTree = n;
            this.rewrittenCtx = c;
        }
    }
}

