/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.tree.Tree;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.repl.ReplScope;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.ReplChangeManager;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.repl.ExternalTableCopyTaskBuilder;
import org.apache.hadoop.hive.ql.exec.repl.ReplDumpWork;
import org.apache.hadoop.hive.ql.exec.repl.ReplExternalTables;
import org.apache.hadoop.hive.ql.exec.repl.ReplLoadWork;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.dump.Utils;
import org.apache.hadoop.hive.ql.parse.repl.load.DumpMetaData;
import org.apache.hadoop.hive.ql.plan.PlanUtils;

public class ReplicationSemanticAnalyzer
extends BaseSemanticAnalyzer {
    private ReplScope replScope = new ReplScope();
    private ReplScope oldReplScope = null;
    private Long eventFrom;
    private Long eventTo;
    private Integer maxEventLimit;
    private String path;
    private HiveConf conf;
    private Hive db;
    private static final String dumpSchema = "dump_dir,last_repl_id#string,string";

    ReplicationSemanticAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
        this.db = ((BaseSemanticAnalyzer)this).db;
        this.conf = new HiveConf(((BaseSemanticAnalyzer)this).conf);
    }

    @Override
    public void analyzeInternal(ASTNode ast) throws SemanticException {
        this.LOG.debug("ReplicationSemanticAanalyzer: analyzeInternal");
        this.LOG.debug(ast.getName() + ":" + ast.getToken().getText() + "=" + ast.getText());
        this.setTxnConfigs();
        switch (ast.getToken().getType()) {
            case 1015: {
                this.LOG.debug("ReplicationSemanticAnalyzer: analyzeInternal: dump");
                this.analyzeReplDump(ast);
                break;
            }
            case 1016: {
                this.LOG.debug("ReplicationSemanticAnalyzer: analyzeInternal: load");
                this.analyzeReplLoad(ast);
                break;
            }
            case 1017: {
                this.LOG.debug("ReplicationSemanticAnalyzer: analyzeInternal: status");
                this.analyzeReplStatus(ast);
                break;
            }
            default: {
                throw new SemanticException("Unexpected root token");
            }
        }
    }

    private void setTxnConfigs() {
        String validTxnList = this.queryState.getConf().get("hive.txn.valid.txns");
        if (validTxnList != null) {
            this.conf.set("hive.txn.valid.txns", validTxnList);
        }
    }

    private void setReplDumpTablesList(Tree replTablesNode, ReplScope replScope) throws HiveException {
        int childCount = replTablesNode.getChildCount();
        assert (childCount <= 2);
        String replScopeType = replScope == this.replScope ? "Current" : "Old";
        for (int listIdx = 0; listIdx < childCount; ++listIdx) {
            String tableList = ReplicationSemanticAnalyzer.unescapeSQLString(replTablesNode.getChild(listIdx).getText());
            if (tableList == null || tableList.isEmpty()) {
                throw new SemanticException(ErrorMsg.REPL_INVALID_DB_OR_TABLE_PATTERN, new String[0]);
            }
            if (listIdx == 0) {
                this.LOG.info("{} ReplScope: Set Included Tables List: {}", (Object)replScopeType, (Object)tableList);
                replScope.setIncludedTablePatterns(tableList);
                continue;
            }
            this.LOG.info("{} ReplScope: Set Excluded Tables List: {}", (Object)replScopeType, (Object)tableList);
            replScope.setExcludedTablePatterns(tableList);
        }
    }

    private void setOldReplPolicy(Tree oldReplPolicyTree) throws HiveException {
        this.oldReplScope = new ReplScope();
        int childCount = oldReplPolicyTree.getChildCount();
        assert (childCount <= 2);
        this.oldReplScope.setDbName(oldReplPolicyTree.getChild(0).getText());
        this.LOG.info("Old ReplScope: Set DB Name: {}", (Object)this.oldReplScope.getDbName());
        if (!this.oldReplScope.getDbName().equalsIgnoreCase(this.replScope.getDbName())) {
            this.LOG.error("DB name {} cannot be replaced to {} in the replication policy.", (Object)this.oldReplScope.getDbName(), (Object)this.replScope.getDbName());
            throw new SemanticException("DB name cannot be replaced in the replication policy.");
        }
        if (childCount <= 1) {
            return;
        }
        Tree oldPolicyTablesListNode = oldReplPolicyTree.getChild(1);
        assert (oldPolicyTablesListNode.getType() == 1018);
        this.setReplDumpTablesList(oldPolicyTablesListNode, this.oldReplScope);
    }

    private void initReplDump(ASTNode ast) throws HiveException {
        int numChildren = ast.getChildCount();
        boolean isMetaDataOnly = false;
        String dbNameOrPattern = PlanUtils.stripQuotes(ast.getChild(0).getText());
        this.LOG.info("Current ReplScope: Set DB Name: {}", (Object)dbNameOrPattern);
        this.replScope.setDbName(dbNameOrPattern);
        block6: for (int childIdx = 1; childIdx < numChildren; ++childIdx) {
            Tree currNode = ast.getChild(childIdx);
            switch (currNode.getType()) {
                case 1013: {
                    Map<String, String> replConfigs = ReplicationSemanticAnalyzer.getProps((ASTNode)currNode.getChild(0));
                    if (null == replConfigs) continue block6;
                    for (Map.Entry<String, String> config : replConfigs.entrySet()) {
                        this.conf.set(config.getKey(), config.getValue());
                    }
                    isMetaDataOnly = HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.REPL_DUMP_METADATA_ONLY);
                    continue block6;
                }
                case 1018: {
                    this.setReplDumpTablesList(currNode, this.replScope);
                    continue block6;
                }
                case 1011: {
                    this.setOldReplPolicy(currNode);
                    continue block6;
                }
                case 889: {
                    Tree fromNode = currNode;
                    this.eventFrom = Long.parseLong(PlanUtils.stripQuotes(fromNode.getChild(0).getText()));
                    for (int fromChildIdx = 1; fromChildIdx < fromNode.getChildCount(); ++fromChildIdx) {
                        if (fromNode.getChild(fromChildIdx).getType() == 1128) {
                            this.eventTo = Long.parseLong(PlanUtils.stripQuotes(fromNode.getChild(fromChildIdx + 1).getText()));
                            ++fromChildIdx;
                            continue;
                        }
                        if (fromNode.getChild(fromChildIdx).getType() != 935) continue;
                        this.maxEventLimit = Integer.parseInt(PlanUtils.stripQuotes(fromNode.getChild(fromChildIdx + 1).getText()));
                        ++fromChildIdx;
                    }
                    continue block6;
                }
                default: {
                    throw new SemanticException("Unrecognized token " + currNode.getType() + " in REPL DUMP statement.");
                }
            }
        }
        for (String dbName : Utils.matchesDb(this.db, dbNameOrPattern)) {
            Database database = this.db.getDatabase(dbName);
            if (database != null) {
                if (isMetaDataOnly || ReplChangeManager.isSourceOfReplication(database)) continue;
                this.LOG.error("Cannot dump database " + dbNameOrPattern + " as it is not a source of replication (repl.source.for)");
                throw new SemanticException(ErrorMsg.REPL_DATABASE_IS_NOT_SOURCE_OF_REPLICATION.getMsg());
            }
            throw new SemanticException("Cannot dump database " + dbNameOrPattern + " as it does not exist");
        }
    }

    private void analyzeReplDump(ASTNode ast) throws SemanticException {
        try {
            this.initReplDump(ast);
        }
        catch (HiveException e) {
            throw new SemanticException(e.getMessage(), e);
        }
        try {
            this.ctx.setResFile(this.ctx.getLocalTmpPath());
            Task<ReplDumpWork> replDumpWorkTask = TaskFactory.get(new ReplDumpWork(this.replScope, this.oldReplScope, this.eventFrom, this.eventTo, ErrorMsg.INVALID_PATH.getMsg(ast), this.maxEventLimit, this.ctx.getResFile().toUri().toString()), this.conf);
            this.rootTasks.add(replDumpWorkTask);
            for (String dbName : Utils.matchesDb(this.db, this.replScope.getDbName())) {
                if (!this.replScope.includeAllTables()) {
                    for (String tblName : Utils.matchesTbl(this.db, dbName, this.replScope)) {
                        this.inputs.add(new ReadEntity(this.db.getTable(dbName, tblName)));
                    }
                    continue;
                }
                this.inputs.add(new ReadEntity(this.db.getDatabase(dbName)));
            }
            this.setFetchTask(this.createFetchTask(dumpSchema));
        }
        catch (Exception e) {
            this.LOG.warn("Error during analyzeReplDump", (Throwable)e);
            throw new SemanticException(e);
        }
    }

    private boolean ifEnableMoveOptimization(Path filePath, Configuration conf) throws Exception {
        String[] schmeList;
        if (filePath == null) {
            throw new HiveException("filePath cannot be null");
        }
        URI uri = filePath.toUri();
        String scheme = uri.getScheme();
        String string = scheme = StringUtils.isBlank(scheme) ? FileSystem.get((URI)uri, (Configuration)conf).getScheme() : scheme;
        if (StringUtils.isBlank(scheme)) {
            throw new HiveException("Cannot get valid scheme for " + filePath);
        }
        this.LOG.info("scheme is " + scheme);
        for (String schemeIter : schmeList = conf.get(HiveConf.ConfVars.REPL_MOVE_OPTIMIZED_FILE_SCHEMES.varname).toLowerCase().split(",")) {
            if (!schemeIter.trim().equalsIgnoreCase(scheme.trim())) continue;
            return true;
        }
        return false;
    }

    private void initReplLoad(ASTNode ast) throws SemanticException {
        this.path = PlanUtils.stripQuotes(ast.getChild(0).getText());
        int numChildren = ast.getChildCount();
        block4: for (int i = 1; i < numChildren; ++i) {
            ASTNode childNode = (ASTNode)ast.getChild(i);
            switch (childNode.getToken().getType()) {
                case 843: {
                    this.replScope.setDbName(PlanUtils.stripQuotes(childNode.getChild(0).getText()));
                    continue block4;
                }
                case 1013: {
                    this.setConfigs((ASTNode)childNode.getChild(0));
                    continue block4;
                }
                default: {
                    throw new SemanticException("Unrecognized token in REPL LOAD statement.");
                }
            }
        }
    }

    private void analyzeReplLoad(ASTNode ast) throws SemanticException {
        this.initReplLoad(ast);
        try {
            assert (this.path != null);
            Path loadPath = new Path(this.path);
            FileSystem fs = loadPath.getFileSystem((Configuration)this.conf);
            if (!fs.exists(loadPath = fs.makeQualified(loadPath))) {
                this.LOG.error("File not found " + loadPath.toUri().toString());
                throw new FileNotFoundException(ErrorMsg.REPL_LOAD_PATH_NOT_FOUND.getMsg());
            }
            try {
                Warehouse wh = new Warehouse(this.conf);
                Path filePath = wh.getWhRoot();
                if (this.ifEnableMoveOptimization(filePath, this.conf)) {
                    this.conf.setBoolVar(HiveConf.ConfVars.REPL_ENABLE_MOVE_OPTIMIZATION, true);
                    this.LOG.info(" Set move optimization to true for warehouse " + filePath.toString());
                }
            }
            catch (Exception e) {
                throw new SemanticException(e.getMessage(), e);
            }
            DumpMetaData dmd = new DumpMetaData(loadPath, this.conf);
            boolean evDump = false;
            if (dmd.isIncrementalDump()) {
                this.LOG.debug("{} contains an incremental dump", (Object)loadPath);
                evDump = true;
            } else {
                this.LOG.debug("{} contains an bootstrap dump", (Object)loadPath);
            }
            ReplLoadWork replLoadWork = new ReplLoadWork(this.conf, loadPath.toString(), this.replScope.getDbName(), dmd.getReplScope(), this.queryState.getLineageState(), evDump, dmd.getEventTo(), this.dirLocationsToCopy(loadPath, evDump));
            this.rootTasks.add(TaskFactory.get(replLoadWork, this.conf));
        }
        catch (Exception e) {
            throw new SemanticException(e.getMessage(), e);
        }
    }

    private List<ExternalTableCopyTaskBuilder.DirCopyWork> dirLocationsToCopy(Path loadPath, boolean isIncrementalPhase) throws HiveException, IOException {
        ArrayList<ExternalTableCopyTaskBuilder.DirCopyWork> list = new ArrayList<ExternalTableCopyTaskBuilder.DirCopyWork>();
        String baseDir = this.conf.get(HiveConf.ConfVars.REPL_EXTERNAL_TABLE_BASE_DIR.varname);
        Path basePath = new Path(baseDir);
        for (String location : new ReplExternalTables.Reader(this.conf, loadPath, isIncrementalPhase).sourceLocationsToCopy()) {
            Path sourcePath = new Path(location);
            Path targetPath = ReplExternalTables.externalTableDataPath(this.conf, basePath, sourcePath);
            list.add(new ExternalTableCopyTaskBuilder.DirCopyWork(sourcePath, targetPath));
        }
        return list;
    }

    private void setConfigs(ASTNode node) throws SemanticException {
        Map<String, String> replConfigs = ReplicationSemanticAnalyzer.getProps(node);
        if (null != replConfigs) {
            for (Map.Entry<String, String> config : replConfigs.entrySet()) {
                String key = config.getKey();
                if (key.equalsIgnoreCase(HiveConf.ConfVars.HIVEQUERYID.varname)) {
                    String queryTag = config.getValue();
                    if (!StringUtils.isEmpty(queryTag)) {
                        QueryState.setApplicationTag(this.conf, queryTag);
                    }
                    this.queryState.setQueryTag(queryTag);
                    continue;
                }
                this.conf.set(key, config.getValue());
            }
            try {
                this.db = Hive.get(this.conf);
            }
            catch (HiveException e) {
                throw new SemanticException(e);
            }
        }
    }

    private void initReplStatus(ASTNode ast) throws SemanticException {
        this.replScope.setDbName(PlanUtils.stripQuotes(ast.getChild(0).getText()));
        int numChildren = ast.getChildCount();
        for (int i = 1; i < numChildren; ++i) {
            ASTNode childNode = (ASTNode)ast.getChild(i);
            if (childNode.getToken().getType() != 1013) {
                throw new SemanticException("Unrecognized token in REPL STATUS statement.");
            }
            this.setConfigs((ASTNode)childNode.getChild(0));
        }
    }

    private void analyzeReplStatus(ASTNode ast) throws SemanticException {
        this.initReplStatus(ast);
        String dbNameOrPattern = this.replScope.getDbName();
        String replLastId = null;
        try {
            Database database = this.db.getDatabase(dbNameOrPattern);
            if (database != null) {
                this.inputs.add(new ReadEntity(database));
                Map<String, String> params = database.getParameters();
                if (params != null && params.containsKey(ReplicationSpec.KEY.CURR_STATE_ID.toString())) {
                    replLastId = params.get(ReplicationSpec.KEY.CURR_STATE_ID.toString());
                }
            }
        }
        catch (HiveException e) {
            throw new SemanticException(e);
        }
        this.prepareReturnValues(Collections.singletonList(replLastId), "last_repl_id#string");
        this.setFetchTask(this.createFetchTask("last_repl_id#string"));
        this.LOG.debug("ReplicationSemanticAnalyzer.analyzeReplStatus: writing repl.last.id={} out to {}", new Object[]{replLastId, this.ctx.getResFile(), this.conf});
    }

    private void prepareReturnValues(List<String> values, String schema) throws SemanticException {
        this.LOG.debug("prepareReturnValues : " + schema);
        for (String s : values) {
            this.LOG.debug("    > " + s);
        }
        this.ctx.setResFile(this.ctx.getLocalTmpPath());
        Utils.writeOutput(Collections.singletonList(values), this.ctx.getResFile(), this.conf);
    }
}

