/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.runtime.TokenRewriteStream;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.RewriteSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.StorageFormat;
import org.apache.hadoop.hive.ql.session.SessionState;

public class MergeSemanticAnalyzer
extends RewriteSemanticAnalyzer {
    private static final String INDENT = "  ";
    private IdentifierQuoter quotedIdentifierHelper;

    MergeSemanticAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyze(ASTNode tree) throws SemanticException {
        if (tree.getToken().getType() != 942) {
            throw new RuntimeException("Asked to parse token " + tree.getName() + " in " + "MergeSemanticAnalyzer");
        }
        this.analyzeMerge(tree);
    }

    private String getMatchedText(ASTNode n) {
        this.quotedIdentifierHelper.visit(n);
        return this.ctx.getTokenRewriteStream().toString(n.getTokenStartIndex(), n.getTokenStopIndex() + 1).trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyzeMerge(ASTNode tree) throws SemanticException {
        this.quotedIdentifierHelper = new IdentifierQuoter(this.ctx.getTokenRewriteStream());
        ASTNode target = (ASTNode)tree.getChild(0);
        ASTNode source = (ASTNode)tree.getChild(1);
        String targetName = this.getSimpleTableName(target);
        String sourceName = this.getSimpleTableName(source);
        ASTNode onClause = (ASTNode)tree.getChild(2);
        String onClauseAsText = this.getMatchedText(onClause);
        int whenClauseBegins = 3;
        boolean hasHint = false;
        ASTNode qHint = (ASTNode)tree.getChild(3);
        if (qHint.getType() == 383) {
            hasHint = true;
            ++whenClauseBegins;
        }
        Table targetTable = this.getTargetTable(target);
        this.validateTargetTable(targetTable);
        List<ASTNode> whenClauses = this.findWhenClauses(tree, whenClauseBegins);
        StringBuilder rewrittenQueryStr = new StringBuilder("FROM\n");
        rewrittenQueryStr.append(INDENT).append(this.getFullTableNameForSQL(target));
        if (this.isAliased(target)) {
            rewrittenQueryStr.append(" ").append(targetName);
        }
        rewrittenQueryStr.append('\n');
        rewrittenQueryStr.append(INDENT).append(this.chooseJoinType(whenClauses)).append("\n");
        if (source.getType() == 1079) {
            rewrittenQueryStr.append(INDENT).append(this.getMatchedText(source));
        } else {
            rewrittenQueryStr.append(INDENT).append(this.getFullTableNameForSQL(source));
            if (this.isAliased(source)) {
                rewrittenQueryStr.append(" ").append(sourceName);
            }
        }
        rewrittenQueryStr.append('\n');
        rewrittenQueryStr.append(INDENT).append("ON ").append(onClauseAsText).append('\n');
        String hintStr = null;
        if (hasHint) {
            hintStr = " /*+ " + qHint.getText() + " */ ";
        }
        boolean splitUpdateEarly = HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.MERGE_SPLIT_UPDATE);
        String extraPredicate = null;
        int numWhenMatchedUpdateClauses = 0;
        int numWhenMatchedDeleteClauses = 0;
        int numInsertClauses = 0;
        boolean hintProcessed = false;
        for (ASTNode whenClause : whenClauses) {
            switch (this.getWhenClauseOperation(whenClause).getType()) {
                case 908: {
                    ++numInsertClauses;
                    this.handleInsert(whenClause, rewrittenQueryStr, target, onClause, targetTable, targetName, onClauseAsText, hintProcessed ? null : hintStr);
                    hintProcessed = true;
                    break;
                }
                case 1144: {
                    String s = this.handleUpdate(whenClause, rewrittenQueryStr, target, onClauseAsText, targetTable, extraPredicate, hintProcessed ? null : hintStr, splitUpdateEarly);
                    hintProcessed = true;
                    if (++numWhenMatchedUpdateClauses + numWhenMatchedDeleteClauses != 1) break;
                    extraPredicate = s;
                    break;
                }
                case 849: {
                    String s1 = this.handleDelete(whenClause, rewrittenQueryStr, target, onClauseAsText, targetTable, extraPredicate, hintProcessed ? null : hintStr, false);
                    hintProcessed = true;
                    if (numWhenMatchedUpdateClauses + ++numWhenMatchedDeleteClauses != 1) break;
                    extraPredicate = s1;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected WHEN clause type: " + whenClause.getType() + MergeSemanticAnalyzer.addParseInfo(whenClause));
                }
            }
            if (numWhenMatchedDeleteClauses > 1) {
                throw new SemanticException(ErrorMsg.MERGE_TOO_MANY_DELETE, this.ctx.getCmd());
            }
            if (numWhenMatchedUpdateClauses > 1) {
                throw new SemanticException(ErrorMsg.MERGE_TOO_MANY_UPDATE, this.ctx.getCmd());
            }
            assert (numInsertClauses < 2) : "too many Insert clauses";
        }
        if (numWhenMatchedDeleteClauses + numWhenMatchedUpdateClauses == 2 && extraPredicate == null) {
            throw new SemanticException(ErrorMsg.MERGE_PREDIACTE_REQUIRED, this.ctx.getCmd());
        }
        boolean validating = this.handleCardinalityViolation(rewrittenQueryStr, target, onClauseAsText, targetTable, numWhenMatchedDeleteClauses == 0 && numWhenMatchedUpdateClauses == 0);
        RewriteSemanticAnalyzer.ReparseResult rr = this.parseRewrittenQuery(rewrittenQueryStr, this.ctx.getCmd());
        Context rewrittenCtx = rr.rewrittenCtx;
        ASTNode rewrittenTree = rr.rewrittenTree;
        rewrittenCtx.setOperation(Context.Operation.MERGE);
        int insClauseIdx = 1;
        int whenClauseIdx = 0;
        while (insClauseIdx < rewrittenTree.getChildCount() - (validating ? 1 : 0)) {
            switch (this.getWhenClauseOperation(whenClauses.get(whenClauseIdx)).getType()) {
                case 908: {
                    rewrittenCtx.addDestNamePrefix(insClauseIdx, Context.DestClausePrefix.INSERT);
                    break;
                }
                case 1144: {
                    if (!splitUpdateEarly) {
                        rewrittenCtx.addDestNamePrefix(insClauseIdx, Context.DestClausePrefix.UPDATE);
                        break;
                    }
                    rewrittenCtx.addDestNamePrefix(insClauseIdx, Context.DestClausePrefix.INSERT);
                    rewrittenCtx.addDestNamePrefix(++insClauseIdx, Context.DestClausePrefix.DELETE);
                    break;
                }
                case 849: {
                    rewrittenCtx.addDestNamePrefix(insClauseIdx, Context.DestClausePrefix.DELETE);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            ++insClauseIdx;
            ++whenClauseIdx;
        }
        if (validating) {
            rewrittenCtx.addDestNamePrefix(rewrittenTree.getChildCount() - 1, Context.DestClausePrefix.INSERT);
        }
        try {
            this.useSuper = true;
            super.analyze(rewrittenTree, rewrittenCtx);
        }
        finally {
            this.useSuper = false;
        }
        this.updateOutputs(targetTable);
    }

    private String chooseJoinType(List<ASTNode> whenClauses) {
        for (ASTNode whenClause : whenClauses) {
            if (this.getWhenClauseOperation(whenClause).getType() != 908) continue;
            return "RIGHT OUTER JOIN";
        }
        return "INNER JOIN";
    }

    private boolean handleCardinalityViolation(StringBuilder rewrittenQueryStr, ASTNode target, String onClauseAsString, Table targetTable, boolean onlyHaveWhenNotMatchedClause) throws SemanticException {
        if (!this.conf.getBoolVar(HiveConf.ConfVars.MERGE_CARDINALITY_VIOLATION_CHECK)) {
            LOG.info("Merge statement cardinality violation check is disabled: " + HiveConf.ConfVars.MERGE_CARDINALITY_VIOLATION_CHECK.varname);
            return false;
        }
        if (onlyHaveWhenNotMatchedClause) {
            return false;
        }
        String tableName = "merge_tmp_table";
        rewrittenQueryStr.append("INSERT INTO ").append(tableName).append("\n  SELECT cardinality_violation(").append(this.getSimpleTableName(target)).append(".ROW__ID");
        this.addPartitionColsToSelect(targetTable.getPartCols(), rewrittenQueryStr, target);
        rewrittenQueryStr.append(")\n WHERE ").append(onClauseAsString).append(" GROUP BY ").append(this.getSimpleTableName(target)).append(".ROW__ID");
        this.addPartitionColsToSelect(targetTable.getPartCols(), rewrittenQueryStr, target);
        rewrittenQueryStr.append(" HAVING count(*) > 1");
        try {
            if (null == this.db.getTable(tableName, false)) {
                StorageFormat format = new StorageFormat(this.conf);
                format.processStorageFormat("TextFile");
                Table table = this.db.newTable(tableName);
                table.setSerializationLib(format.getSerde());
                ArrayList<FieldSchema> fields = new ArrayList<FieldSchema>();
                fields.add(new FieldSchema("val", "int", null));
                table.setFields(fields);
                table.setDataLocation(Warehouse.getDnsPath(new Path(SessionState.get().getTempTableSpace(), tableName), this.conf));
                table.getTTable().setTemporary(true);
                table.setStoredAsSubDirectories(false);
                table.setInputFormatClass(format.getInputFormat());
                table.setOutputFormatClass(format.getOutputFormat());
                this.db.createTable(table, true);
            }
        }
        catch (MetaException | HiveException e) {
            throw new SemanticException(e.getMessage(), e);
        }
        return true;
    }

    private String handleUpdate(ASTNode whenMatchedUpdateClause, StringBuilder rewrittenQueryStr, ASTNode target, String onClauseAsString, Table targetTable, String deleteExtraPredicate, String hintStr, boolean splitUpdateEarly) throws SemanticException {
        assert (whenMatchedUpdateClause.getType() == 941);
        assert (this.getWhenClauseOperation(whenMatchedUpdateClause).getType() == 1144);
        String targetName = this.getSimpleTableName(target);
        rewrittenQueryStr.append("INSERT INTO ").append(this.getFullTableNameForSQL(target));
        this.addPartitionColsToInsert(targetTable.getPartCols(), rewrittenQueryStr);
        rewrittenQueryStr.append("    -- update clause").append(splitUpdateEarly ? "(insert part)" : "").append("\n SELECT ");
        if (hintStr != null) {
            rewrittenQueryStr.append(hintStr);
        }
        if (!splitUpdateEarly) {
            rewrittenQueryStr.append(targetName).append(".ROW__ID, ");
        }
        ASTNode setClause = (ASTNode)this.getWhenClauseOperation(whenMatchedUpdateClause).getChild(0);
        Map<String, ASTNode> setColsExprs = this.collectSetColumnsAndExpressions(setClause, null, targetTable);
        List<FieldSchema> nonPartCols = targetTable.getCols();
        for (int i = 0; i < nonPartCols.size(); ++i) {
            String name;
            FieldSchema fs = nonPartCols.get(i);
            if (i > 0) {
                rewrittenQueryStr.append(", ");
            }
            if (setColsExprs.containsKey(name = fs.getName())) {
                String rhsExp = this.getMatchedText(setColsExprs.get(name));
                switch (rhsExp.charAt(rhsExp.length() - 1)) {
                    case '\n': 
                    case ',': {
                        rhsExp = rhsExp.substring(0, rhsExp.length() - 1);
                        break;
                    }
                }
                rewrittenQueryStr.append(rhsExp);
                continue;
            }
            rewrittenQueryStr.append(this.getSimpleTableName(target)).append(".").append(HiveUtils.unparseIdentifier(name, this.conf));
        }
        this.addPartitionColsToSelect(targetTable.getPartCols(), rewrittenQueryStr, target);
        rewrittenQueryStr.append("\n   WHERE ").append(onClauseAsString);
        String extraPredicate = this.getWhenClausePredicate(whenMatchedUpdateClause);
        if (extraPredicate != null) {
            rewrittenQueryStr.append(" AND ").append(extraPredicate);
        }
        if (deleteExtraPredicate != null) {
            rewrittenQueryStr.append(" AND NOT(").append(deleteExtraPredicate).append(")");
        }
        if (!splitUpdateEarly) {
            rewrittenQueryStr.append("\n SORT BY ");
            rewrittenQueryStr.append(targetName).append(".ROW__ID ");
        }
        rewrittenQueryStr.append("\n");
        this.setUpAccessControlInfoForUpdate(targetTable, setColsExprs);
        if (splitUpdateEarly) {
            this.handleDelete(whenMatchedUpdateClause, rewrittenQueryStr, target, onClauseAsString, targetTable, deleteExtraPredicate, hintStr, true);
        }
        return extraPredicate;
    }

    private String handleDelete(ASTNode whenMatchedDeleteClause, StringBuilder rewrittenQueryStr, ASTNode target, String onClauseAsString, Table targetTable, String updateExtraPredicate, String hintStr, boolean splitUpdateEarly) throws SemanticException {
        assert (whenMatchedDeleteClause.getType() == 941);
        assert (splitUpdateEarly && this.getWhenClauseOperation(whenMatchedDeleteClause).getType() == 1144 || this.getWhenClauseOperation(whenMatchedDeleteClause).getType() == 849);
        List<FieldSchema> partCols = targetTable.getPartCols();
        String targetName = this.getSimpleTableName(target);
        rewrittenQueryStr.append("INSERT INTO ").append(this.getFullTableNameForSQL(target));
        this.addPartitionColsToInsert(partCols, rewrittenQueryStr);
        if (splitUpdateEarly) {
            rewrittenQueryStr.append("    -- update clause (delete part)\n SELECT ");
        } else {
            rewrittenQueryStr.append("    -- delete clause\n SELECT ");
        }
        if (hintStr != null) {
            rewrittenQueryStr.append(hintStr);
        }
        rewrittenQueryStr.append(targetName).append(".ROW__ID ");
        this.addPartitionColsToSelect(partCols, rewrittenQueryStr, target);
        rewrittenQueryStr.append("\n   WHERE ").append(onClauseAsString);
        String extraPredicate = this.getWhenClausePredicate(whenMatchedDeleteClause);
        if (extraPredicate != null) {
            rewrittenQueryStr.append(" AND ").append(extraPredicate);
        }
        if (updateExtraPredicate != null) {
            rewrittenQueryStr.append(" AND NOT(").append(updateExtraPredicate).append(")");
        }
        rewrittenQueryStr.append("\n SORT BY ");
        rewrittenQueryStr.append(targetName).append(".ROW__ID \n");
        return extraPredicate;
    }

    private static String addParseInfo(ASTNode n) {
        return " at " + ErrorMsg.renderPosition(n);
    }

    private boolean isAliased(ASTNode n) {
        switch (n.getType()) {
            case 1116: {
                return this.findTabRefIdxs(n)[0] != 0;
            }
            case 1115: {
                return false;
            }
            case 1079: {
                assert (n.getChildCount() > 1) : "Expected Derived Table to be aliased";
                return true;
            }
        }
        throw MergeSemanticAnalyzer.raiseWrongType("TOK_TABREF|TOK_TABNAME", n);
    }

    private List<ASTNode> findWhenClauses(ASTNode tree, int start) throws SemanticException {
        assert (tree.getType() == 942);
        ArrayList<ASTNode> whenClauses = new ArrayList<ASTNode>();
        for (int idx = start; idx < tree.getChildCount(); ++idx) {
            ASTNode whenClause = (ASTNode)tree.getChild(idx);
            assert (whenClause.getType() == 941 || whenClause.getType() == 947) : "Unexpected node type found: " + whenClause.getType() + MergeSemanticAnalyzer.addParseInfo(whenClause);
            whenClauses.add(whenClause);
        }
        if (whenClauses.size() <= 0) {
            throw new SemanticException("Must have at least 1 WHEN clause in MERGE statement");
        }
        return whenClauses;
    }

    private ASTNode getWhenClauseOperation(ASTNode whenClause) {
        if (whenClause.getType() != 941 && whenClause.getType() != 947) {
            throw MergeSemanticAnalyzer.raiseWrongType("Expected TOK_MATCHED|TOK_NOT_MATCHED", whenClause);
        }
        return (ASTNode)whenClause.getChild(0);
    }

    private String getWhenClausePredicate(ASTNode whenClause) {
        if (whenClause.getType() != 941 && whenClause.getType() != 947) {
            throw MergeSemanticAnalyzer.raiseWrongType("Expected TOK_MATCHED|TOK_NOT_MATCHED", whenClause);
        }
        if (whenClause.getChildCount() == 2) {
            return this.getMatchedText((ASTNode)whenClause.getChild(1));
        }
        return null;
    }

    private void handleInsert(ASTNode whenNotMatchedClause, StringBuilder rewrittenQueryStr, ASTNode target, ASTNode onClause, Table targetTable, String targetTableNameInSourceQuery, String onClauseAsString, String hintStr) throws SemanticException {
        ASTNode whenClauseOperation = this.getWhenClauseOperation(whenNotMatchedClause);
        assert (whenNotMatchedClause.getType() == 947);
        assert (whenClauseOperation.getType() == 908);
        List children = whenClauseOperation.getChildren();
        ASTNode valuesNode = (ASTNode)children.stream().filter(n -> ((ASTNode)n).getType() == 891).findFirst().get();
        ASTNode columnListNode = children.stream().filter(n -> ((ASTNode)n).getType() == 1090).findFirst().orElse(null);
        if (columnListNode != null && columnListNode.getChildCount() != valuesNode.getChildCount() - 1) {
            throw new SemanticException(String.format("Column schema must have the same length as values (%d vs %d)", columnListNode.getChildCount(), valuesNode.getChildCount() - 1));
        }
        rewrittenQueryStr.append("INSERT INTO ").append(this.getFullTableNameForSQL(target));
        if (columnListNode != null) {
            rewrittenQueryStr.append(' ').append(this.getMatchedText(columnListNode));
        }
        this.addPartitionColsToInsert(targetTable.getPartCols(), rewrittenQueryStr);
        rewrittenQueryStr.append("    -- insert clause\n  SELECT ");
        if (hintStr != null) {
            rewrittenQueryStr.append(hintStr);
        }
        OnClauseAnalyzer oca = new OnClauseAnalyzer(onClause, targetTable, targetTableNameInSourceQuery, this.conf, onClauseAsString);
        oca.analyze();
        String valuesClause = this.getMatchedText(valuesNode);
        valuesClause = valuesClause.substring(1, valuesClause.length() - 1);
        valuesClause = this.replaceDefaultKeywordForMerge(valuesClause, targetTable, columnListNode);
        rewrittenQueryStr.append(valuesClause).append("\n   WHERE ").append(oca.getPredicate());
        String extraPredicate = this.getWhenClausePredicate(whenNotMatchedClause);
        if (extraPredicate != null) {
            rewrittenQueryStr.append(" AND ").append(this.getMatchedText((ASTNode)whenNotMatchedClause.getChild(1)));
        }
        rewrittenQueryStr.append('\n');
    }

    private String replaceDefaultKeywordForMerge(String valueClause, Table table, ASTNode columnListNode) throws SemanticException {
        if (!valueClause.toLowerCase().contains("`default`")) {
            return valueClause;
        }
        Map<String, String> colNameToDefaultConstraint = MergeSemanticAnalyzer.getColNameToDefaultValueMap(table);
        String[] values = valueClause.trim().split(",");
        Object[] replacedValues = new String[values.length];
        String[] columnNames = columnListNode == null ? (String[])table.getAllCols().stream().map(f -> f.getName()).toArray(String[]::new) : (String[])columnListNode.getChildren().stream().map(n -> ((ASTNode)n).toString()).toArray(String[]::new);
        for (int i = 0; i < values.length; ++i) {
            replacedValues[i] = values[i].trim().toLowerCase().equals("`default`") ? MapUtils.getString(colNameToDefaultConstraint, (Object)columnNames[i], (String)"null") : values[i];
        }
        return StringUtils.join(replacedValues, ',');
    }

    private static final class OnClauseAnalyzer {
        private final ASTNode onClause;
        private final Map<String, List<String>> table2column = new HashMap<String, List<String>>();
        private final List<String> unresolvedColumns = new ArrayList<String>();
        private final List<FieldSchema> allTargetTableColumns = new ArrayList<FieldSchema>();
        private final Set<String> tableNamesFound = new HashSet<String>();
        private final String targetTableNameInSourceQuery;
        private final HiveConf conf;
        private final String onClauseAsString;

        OnClauseAnalyzer(ASTNode onClause, Table targetTable, String targetTableNameInSourceQuery, HiveConf conf, String onClauseAsString) {
            this.onClause = onClause;
            this.allTargetTableColumns.addAll(targetTable.getCols());
            this.allTargetTableColumns.addAll(targetTable.getPartCols());
            this.targetTableNameInSourceQuery = BaseSemanticAnalyzer.unescapeIdentifier(targetTableNameInSourceQuery);
            this.conf = conf;
            this.onClauseAsString = onClauseAsString;
        }

        private void visit(ASTNode n) {
            if (n.getType() == 1112) {
                ASTNode parent = (ASTNode)n.getParent();
                if (parent != null && parent.getType() == 16) {
                    if (parent.getParent() != null && parent.getParent().getType() == 16) {
                        throw new IllegalArgumentException("Found unexpected db.table.col reference in " + this.onClauseAsString);
                    }
                    this.addColumn2Table(n.getChild(0).getText(), parent.getChild(1).getText());
                } else {
                    this.unresolvedColumns.add(n.getChild(0).getText());
                }
            }
            if (n.getChildCount() == 0) {
                return;
            }
            for (Node child : n.getChildren()) {
                this.visit((ASTNode)child);
            }
        }

        private void analyze() {
            this.visit(this.onClause);
            if (this.tableNamesFound.size() > 2) {
                throw new IllegalArgumentException("Found > 2 table refs in ON clause.  Found " + this.tableNamesFound + " in " + this.onClauseAsString);
            }
            this.handleUnresolvedColumns();
            if (this.tableNamesFound.size() > 2) {
                throw new IllegalArgumentException("Found > 2 table refs in ON clause (incl unresolved).  Found " + this.tableNamesFound + " in " + this.onClauseAsString);
            }
        }

        private void handleUnresolvedColumns() {
            if (this.unresolvedColumns.isEmpty()) {
                return;
            }
            block0: for (String c : this.unresolvedColumns) {
                for (FieldSchema fs : this.allTargetTableColumns) {
                    if (!c.equalsIgnoreCase(fs.getName())) continue;
                    this.addColumn2Table(this.targetTableNameInSourceQuery.toLowerCase(), c);
                    continue block0;
                }
            }
        }

        private void addColumn2Table(String tableName, String columnName) {
            tableName = tableName.toLowerCase();
            this.tableNamesFound.add(tableName);
            List<String> cols = this.table2column.get(tableName);
            if (cols == null) {
                cols = new ArrayList<String>();
                this.table2column.put(tableName, cols);
            }
            cols.add(columnName);
        }

        private String getPredicate() {
            List<String> targetCols = this.table2column.get(this.targetTableNameInSourceQuery.toLowerCase());
            if (targetCols == null) {
                throw new IllegalArgumentException(ErrorMsg.INVALID_TABLE_IN_ON_CLAUSE_OF_MERGE.format(this.targetTableNameInSourceQuery, this.onClauseAsString));
            }
            StringBuilder sb = new StringBuilder();
            for (String col : targetCols) {
                if (sb.length() > 0) {
                    sb.append(" AND ");
                }
                sb.append(HiveUtils.unparseIdentifier(this.targetTableNameInSourceQuery, this.conf)).append(".").append(HiveUtils.unparseIdentifier(col, this.conf)).append(" IS NULL");
            }
            return sb.toString();
        }
    }

    private static class IdentifierQuoter {
        private final TokenRewriteStream trs;
        private final IdentityHashMap<ASTNode, ASTNode> visitedNodes = new IdentityHashMap();

        IdentifierQuoter(TokenRewriteStream trs) {
            this.trs = trs;
            if (trs == null) {
                throw new IllegalArgumentException("Must have a TokenRewriteStream");
            }
        }

        private void visit(ASTNode n) {
            if (n.getType() == 24) {
                if (this.visitedNodes.containsKey(n)) {
                    return;
                }
                this.visitedNodes.put(n, n);
                this.trs.insertBefore(n.getToken(), (Object)"`");
                this.trs.insertAfter(n.getToken(), (Object)"`");
            }
            if (n.getChildCount() <= 0) {
                return;
            }
            for (Node c : n.getChildren()) {
                this.visit((ASTNode)c);
            }
        }
    }
}

