/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.antlr.runtime.tree.Tree;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.TaskQueue;
import org.apache.hadoop.hive.ql.ddl.DDLTask;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.create.like.CreateTableLikeDesc;
import org.apache.hadoop.hive.ql.ddl.table.drop.DropTableDesc;
import org.apache.hadoop.hive.ql.ddl.table.misc.properties.AlterTableSetPropertiesDesc;
import org.apache.hadoop.hive.ql.exec.StatsTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.repl.util.AddDependencyToLeaves;
import org.apache.hadoop.hive.ql.exec.util.DAGTraversal;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.HiveTableName;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.RewriteSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExportWork;
import org.apache.hadoop.hive.ql.session.SessionState;

public class AcidExportSemanticAnalyzer
extends RewriteSemanticAnalyzer {
    AcidExportSemanticAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    protected void analyze(ASTNode tree) throws SemanticException {
        if (tree.getToken().getType() != 881) {
            throw new RuntimeException("Asked to parse token " + tree.getName() + " in " + "AcidExportSemanticAnalyzer");
        }
        this.analyzeAcidExport(tree);
    }

    public static boolean isAcidExport(ASTNode tree) throws SemanticException {
        assert (tree != null && tree.getToken() != null && tree.getToken().getType() == 881);
        Tree tokTab = tree.getChild(0);
        assert (tokTab != null && tokTab.getType() == 1086);
        Table tableHandle = null;
        try {
            tableHandle = AcidExportSemanticAnalyzer.getTable((ASTNode)tokTab.getChild(0), Hive.get(), false);
        }
        catch (HiveException ex) {
            throw new SemanticException(ex);
        }
        return tableHandle != null && AcidUtils.isFullAcidTable(tableHandle);
    }

    private static String getTmptTableNameForExport(Table exportTable) {
        String tmpTableDb = exportTable.getDbName();
        String tmpTableName = exportTable.getTableName() + "_" + UUID.randomUUID().toString().replace('-', '_');
        return Warehouse.getQualifiedName(tmpTableDb, tmpTableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyzeAcidExport(ASTNode ast) throws SemanticException {
        Table newTable;
        String location;
        assert (ast != null && ast.getToken() != null && ast.getToken().getType() == 881);
        ASTNode tableTree = (ASTNode)ast.getChild(0);
        assert (tableTree != null && tableTree.getType() == 1086);
        ASTNode tokRefOrNameExportTable = (ASTNode)tableTree.getChild(0);
        Table exportTable = this.getTargetTable(tokRefOrNameExportTable);
        assert (AcidUtils.isFullAcidTable(exportTable));
        String newTableName = AcidExportSemanticAnalyzer.getTmptTableNameForExport(exportTable);
        TableName newTableNameRef = HiveTableName.of(newTableName);
        HashMap<String, String> tblProps = new HashMap<String, String>();
        tblProps.put("transactional", Boolean.FALSE.toString());
        try {
            Path path = new Path(SessionState.getTempTableSpace(this.conf), UUID.randomUUID().toString());
            path = Warehouse.getDnsPath(path, this.conf);
            location = path.toString();
        }
        catch (MetaException err) {
            throw new SemanticException("Error while generating temp table path:", err);
        }
        CreateTableLikeDesc ctlt = new CreateTableLikeDesc(newTableName, false, true, null, null, location, null, null, tblProps, true, Warehouse.getQualifiedName(exportTable.getTTable()), false);
        try {
            ReadEntity dbForTmpTable = new ReadEntity(this.db.getDatabase(exportTable.getDbName()));
            this.inputs.add(dbForTmpTable);
            DDLTask createTableTask = (DDLTask)TaskFactory.get(new DDLWork(new HashSet<ReadEntity>(), new HashSet<WriteEntity>(), ctlt), this.conf);
            createTableTask.setConf(this.conf);
            Context context = new Context(this.conf);
            createTableTask.initialize(null, null, new TaskQueue(context), context);
            createTableTask.execute();
            newTable = this.db.getTable(newTableName);
        }
        catch (IOException | HiveException ex) {
            throw new SemanticException(ex);
        }
        StringBuilder rewrittenQueryStr = this.generateExportQuery(newTable.getPartCols(), tokRefOrNameExportTable, tableTree, newTableName);
        RewriteSemanticAnalyzer.ReparseResult rr = this.parseRewrittenQuery(rewrittenQueryStr, this.ctx.getCmd());
        Context rewrittenCtx = rr.rewrittenCtx;
        rewrittenCtx.setIsUpdateDeleteMerge(false);
        ASTNode rewrittenTree = rr.rewrittenTree;
        try {
            this.useSuper = true;
            super.analyze(rewrittenTree, rewrittenCtx);
        }
        finally {
            this.useSuper = false;
        }
        this.removeStatsTasks(this.rootTasks);
        Task<ExportWork> exportTask = ExportSemanticAnalyzer.analyzeExport(ast, newTableName, this.db, this.conf, this.inputs, this.outputs);
        HashMap<String, String> mapProps = new HashMap<String, String>();
        mapProps.put("transactional", Boolean.TRUE.toString());
        AlterTableSetPropertiesDesc alterTblDesc = new AlterTableSetPropertiesDesc(newTableNameRef, null, null, false, mapProps, false, false, null);
        Task<DDLWork> alterTableTask = TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc));
        alterTableTask.addDependentTask(exportTask);
        DAGTraversal.traverse(this.rootTasks, new AddDependencyToLeaves(alterTableTask));
        ReplicationSpec replicationSpec = new ReplicationSpec();
        DropTableDesc dropTblDesc = new DropTableDesc(newTableName, false, true, replicationSpec);
        Task<DDLWork> dropTask = TaskFactory.get(new DDLWork(new HashSet<ReadEntity>(), new HashSet<WriteEntity>(), dropTblDesc), this.conf);
        exportTask.addDependentTask(dropTask);
        this.markReadEntityForUpdate();
        if (this.ctx.isExplainPlan()) {
            try {
                this.db.dropTable(newTable.getDbName(), newTable.getTableName(), true, true, true);
            }
            catch (HiveException ex) {
                LOG.warn("Unable to drop " + newTableName + " due to: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private StringBuilder generateExportQuery(List<FieldSchema> partCols, ASTNode tokRefOrNameExportTable, ASTNode tableTree, String newTableName) throws SemanticException {
        StringBuilder rewrittenQueryStr = new StringBuilder("insert into ").append(newTableName);
        this.addPartitionColsToInsert(partCols, rewrittenQueryStr);
        rewrittenQueryStr.append(" select * from ").append(this.getFullTableNameForSQL(tokRefOrNameExportTable));
        BaseSemanticAnalyzer.TableSpec exportTableSpec = new BaseSemanticAnalyzer.TableSpec(this.db, this.conf, tableTree, false, true);
        if (exportTableSpec.getPartSpec() != null) {
            StringBuilder whereClause = null;
            int partColsIdx = -1;
            for (Map.Entry<String, String> ent : exportTableSpec.getPartSpec().entrySet()) {
                ++partColsIdx;
                if (ent.getValue() == null) continue;
                if (whereClause == null) {
                    whereClause = new StringBuilder(" WHERE ");
                }
                if (whereClause.length() > " WHERE ".length()) {
                    whereClause.append(" AND ");
                }
                whereClause.append(HiveUtils.unparseIdentifier(ent.getKey(), this.conf)).append(" = ").append(AcidExportSemanticAnalyzer.genPartValueString(partCols.get(partColsIdx).getType(), ent.getValue()));
            }
            if (whereClause != null) {
                rewrittenQueryStr.append((CharSequence)whereClause);
            }
        }
        return rewrittenQueryStr;
    }

    private void removeStatsTasks(List<Task<? extends Serializable>> rootTasks) {
        List<Task<? extends Serializable>> statsTasks = this.findStatsTasks(rootTasks, null);
        if (statsTasks == null) {
            return;
        }
        for (Task<? extends Serializable> statsTask : new ArrayList<Task<? extends Serializable>>(statsTasks)) {
            if (statsTask.getParentTasks() == null) continue;
            List<Task<Serializable>> children = statsTask.getChildTasks();
            if (children != null) {
                for (Task<Serializable> child : children) {
                    statsTask.removeDependentTask(child);
                }
            }
            for (Task<Serializable> parent : new ArrayList<Task<Serializable>>(statsTask.getParentTasks())) {
                parent.removeDependentTask(statsTask);
                LOG.error("Parent " + parent + " Child " + statsTask);
                if (children == null) continue;
                for (Task<Serializable> child : new ArrayList<Task<Serializable>>(children)) {
                    parent.addDependentTask(child);
                }
            }
        }
    }

    private List<Task<? extends Serializable>> findStatsTasks(List<Task<? extends Serializable>> rootTasks, List<Task<? extends Serializable>> statsTasks) {
        for (Task<? extends Serializable> t : rootTasks) {
            if (t instanceof StatsTask) {
                if (statsTasks == null) {
                    statsTasks = new ArrayList<Task<? extends Serializable>>();
                }
                if (statsTasks.contains(t)) continue;
                statsTasks.add(t);
            }
            if (t.getDependentTasks() == null) continue;
            statsTasks = this.findStatsTasks(t.getDependentTasks(), statsTasks);
        }
        return statsTasks;
    }
}

