/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.physical;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.exec.ConditionalTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.MapRedTask;
import org.apache.hadoop.hive.ql.lib.Dispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.TaskGraphWalker;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.MapWork;

public abstract class AbstractJoinTaskDispatcher
implements Dispatcher {
    protected final PhysicalContext physicalContext;

    public AbstractJoinTaskDispatcher(PhysicalContext context) {
        this.physicalContext = context;
    }

    public abstract Task<? extends Serializable> processCurrentTask(MapRedTask var1, ConditionalTask var2, Context var3) throws SemanticException;

    protected void replaceTaskWithConditionalTask(Task<? extends Serializable> currTask, ConditionalTask cndTsk) {
        List<Task<Serializable>> parentTasks = currTask.getParentTasks();
        currTask.setParentTasks(null);
        if (parentTasks != null) {
            for (Task<Serializable> tsk : parentTasks) {
                tsk.addDependentTask(cndTsk);
                tsk.removeDependentTask(currTask);
            }
        } else {
            this.physicalContext.removeFromRootTask(currTask);
            this.physicalContext.addToRootTask(cndTsk);
        }
        List<Task<Serializable>> oldChildTasks = currTask.getChildTasks();
        if (oldChildTasks != null) {
            for (Task<? extends Serializable> tsk : cndTsk.getListTasks()) {
                if (tsk.equals(currTask)) continue;
                for (Task<Serializable> oldChild : oldChildTasks) {
                    tsk.addDependentTask(oldChild);
                }
            }
        }
    }

    protected void replaceTask(Task<? extends Serializable> currTask, Task<? extends Serializable> newTask) {
        List<Task<Serializable>> parentTasks = currTask.getParentTasks();
        currTask.setParentTasks(null);
        if (parentTasks != null) {
            for (Task<Serializable> tsk : parentTasks) {
                tsk.removeDependentTask(currTask);
                tsk.addDependentTask(newTask);
            }
        } else {
            this.physicalContext.removeFromRootTask(currTask);
            this.physicalContext.addToRootTask(newTask);
        }
        List<Task<Serializable>> oldChildTasks = currTask.getChildTasks();
        currTask.setChildTasks(null);
        if (oldChildTasks != null) {
            for (Task<Serializable> tsk : oldChildTasks) {
                tsk.getParentTasks().remove(currTask);
                newTask.addDependentTask(tsk);
            }
        }
    }

    public long getTotalKnownInputSize(Context context, MapWork currWork, Map<Path, List<String>> pathToAliases, Map<String, Long> aliasToSize) throws SemanticException {
        try {
            Utilities.getInputSummary(context, currWork, null).getLength();
            long aliasTotalKnownInputSize = 0L;
            for (Map.Entry<Path, List<String>> entry : pathToAliases.entrySet()) {
                Path path = entry.getKey();
                List<String> aliasList = entry.getValue();
                ContentSummary cs = context.getCS(path);
                if (cs == null) continue;
                long size = cs.getLength();
                for (String alias : aliasList) {
                    aliasTotalKnownInputSize += size;
                    Long es = aliasToSize.get(alias);
                    if (es == null) {
                        es = new Long(0L);
                    }
                    es = es + size;
                    aliasToSize.put(alias, es);
                }
            }
            return aliasTotalKnownInputSize;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SemanticException("Generate Map Join Task Error: " + e.getMessage());
        }
    }

    @Override
    public Object dispatch(Node nd, Stack<Node> stack, Object ... nodeOutputs) throws SemanticException {
        if (nodeOutputs == null || nodeOutputs.length == 0) {
            throw new SemanticException("No Dispatch Context");
        }
        TaskGraphWalker.TaskGraphWalkerContext walkerCtx = (TaskGraphWalker.TaskGraphWalkerContext)nodeOutputs[0];
        Task currTask = (Task)nd;
        if (currTask.isMapRedTask()) {
            if (currTask instanceof ConditionalTask) {
                List<Task<? extends Serializable>> taskList = ((ConditionalTask)currTask).getListTasks();
                for (Task<? extends Serializable> tsk : taskList) {
                    if (!tsk.isMapRedTask()) continue;
                    Task<? extends Serializable> newTask = this.processCurrentTask((MapRedTask)tsk, (ConditionalTask)currTask, this.physicalContext.getContext());
                    walkerCtx.addToDispatchList(newTask);
                }
            } else {
                Task<? extends Serializable> newTask = this.processCurrentTask((MapRedTask)currTask, null, this.physicalContext.getContext());
                walkerCtx.addToDispatchList(newTask);
            }
        }
        return null;
    }
}

