/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.translator.opconventer;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.RelOptHiveTable;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableScan;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.opconventer.HiveOpConverter;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.opconventer.HiveRelNodeVisitor;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;

class HiveTableScanVisitor
extends HiveRelNodeVisitor<HiveTableScan> {
    HiveTableScanVisitor(HiveOpConverter hiveOpConverter) {
        super(hiveOpConverter);
    }

    @Override
    HiveOpConverter.OpAttr visit(HiveTableScan scanRel) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Translating operator rel#" + scanRel.getId() + ":" + scanRel.getRelTypeName() + " with row type: [" + scanRel.getRowType() + "]");
        }
        RelOptHiveTable ht = (RelOptHiveTable)scanRel.getTable();
        ArrayList<ColumnInfo> colInfos = new ArrayList<ColumnInfo>();
        ArrayList<VirtualColumn> virtualCols = new ArrayList<VirtualColumn>();
        ArrayList<Integer> neededColumnIDs = new ArrayList<Integer>();
        ArrayList<String> neededColumnNames = new ArrayList<String>();
        HashSet<Integer> vcolsInCalcite = new HashSet<Integer>();
        ArrayList<String> partColNames = new ArrayList<String>();
        ImmutableMap<Integer, VirtualColumn> vColsMap = HiveCalciteUtil.getVColsMap(ht.getVirtualCols(), ht.getNoOfNonVirtualCols());
        Map<Integer, ColumnInfo> posToPartColInfo = ht.getPartColInfoMap();
        Map<Integer, ColumnInfo> posToNonPartColInfo = ht.getNonPartColInfoMap();
        List<Integer> neededColIndxsFrmReloptHT = scanRel.getNeededColIndxsFrmReloptHT();
        List scanColNames = scanRel.getRowType().getFieldNames();
        String tableAlias = scanRel.getConcatQbIDAlias();
        for (int index = 0; index < scanRel.getRowType().getFieldList().size(); ++index) {
            ColumnInfo colInfo;
            String colName = (String)scanColNames.get(index);
            if (vColsMap.containsKey(index)) {
                VirtualColumn vc = (VirtualColumn)((Object)vColsMap.get(index));
                virtualCols.add(vc);
                colInfo = new ColumnInfo(vc.getName(), vc.getTypeInfo(), tableAlias, true, vc.getIsHidden());
                vcolsInCalcite.add(index);
            } else if (posToPartColInfo.containsKey(index)) {
                partColNames.add(colName);
                colInfo = posToPartColInfo.get(index);
                vcolsInCalcite.add(index);
            } else {
                colInfo = posToNonPartColInfo.get(index);
            }
            colInfos.add(colInfo);
            if (!neededColIndxsFrmReloptHT.contains(index)) continue;
            neededColumnIDs.add(index);
            neededColumnNames.add(colName);
        }
        TableScanDesc tsd = new TableScanDesc(tableAlias, virtualCols, ht.getHiveTableMD());
        tsd.setPartColumns(partColNames);
        tsd.setNeededColumnIDs(neededColumnIDs);
        tsd.setNeededColumns(neededColumnNames);
        TableScanOperator ts = (TableScanOperator)OperatorFactory.get(this.hiveOpConverter.getSemanticAnalyzer().getOpContext(), tsd, new RowSchema(colInfos));
        ts.setBucketingVersion(tsd.getTableMetadata().getBucketingVersion());
        if (this.hiveOpConverter.getTopOps().get(tableAlias) != null) {
            tableAlias = tableAlias + this.hiveOpConverter.getUniqueCounter();
        }
        this.hiveOpConverter.getTopOps().put(tableAlias, ts);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Generated " + ts + " with row schema: [" + ts.getSchema() + "]");
        }
        return new HiveOpConverter.OpAttr(tableAlias, vcolsInCalcite, ts);
    }
}

