/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.translator.opconventer;

import java.util.ArrayList;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rex.RexNode;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSortExchange;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.opconventer.HiveOpConverter;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.opconventer.HiveOpConverterUtils;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.opconventer.HiveRelNodeVisitor;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;

class HiveSortExchangeVisitor
extends HiveRelNodeVisitor<HiveSortExchange> {
    HiveSortExchangeVisitor(HiveOpConverter hiveOpConverter) {
        super(hiveOpConverter);
    }

    @Override
    HiveOpConverter.OpAttr visit(HiveSortExchange exchangeRel) throws SemanticException {
        RelDistribution distribution;
        HiveOpConverter.OpAttr inputOpAf = this.hiveOpConverter.dispatch(exchangeRel.getInput());
        String tabAlias = inputOpAf.tabAlias;
        if (tabAlias == null || tabAlias.length() == 0) {
            tabAlias = this.hiveOpConverter.getHiveDerivedTableAlias();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Translating operator rel#" + exchangeRel.getId() + ":" + exchangeRel.getRelTypeName() + " with row type: [" + exchangeRel.getRowType() + "]");
        }
        if ((distribution = exchangeRel.getDistribution()).getType() != RelDistribution.Type.HASH_DISTRIBUTED) {
            throw new SemanticException("Only hash distribution supported for LogicalExchange");
        }
        ExprNodeDesc[] expressions = new ExprNodeDesc[exchangeRel.getJoinKeys().size()];
        for (int index = 0; index < exchangeRel.getJoinKeys().size(); ++index) {
            expressions[index] = HiveOpConverterUtils.convertToExprNode((RexNode)exchangeRel.getJoinKeys().get(index), exchangeRel.getInput(), inputOpAf.tabAlias, inputOpAf.vcolsInCalcite);
        }
        exchangeRel.setJoinExpressions(expressions);
        ReduceSinkOperator rsOp = HiveSortExchangeVisitor.genReduceSink((Operator)inputOpAf.inputs.get(0), tabAlias, expressions, -1, -1, AcidUtils.Operation.NOT_ACID, this.hiveOpConverter.getHiveConf());
        return new HiveOpConverter.OpAttr(tabAlias, inputOpAf.vcolsInCalcite, rsOp);
    }

    private static ReduceSinkOperator genReduceSink(Operator<?> input, String tableAlias, ExprNodeDesc[] keys, int tag, int numReducers, AcidUtils.Operation acidOperation, HiveConf hiveConf) throws SemanticException {
        return HiveOpConverterUtils.genReduceSink(input, tableAlias, keys, tag, new ArrayList<ExprNodeDesc>(), "", "", numReducers, acidOperation, hiveConf);
    }
}

