/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.translator.opconventer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.SemiJoin;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.LimitOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveAggregate;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveFilter;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveMultiJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveProject;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSortExchange;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSortLimit;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableFunctionScan;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableScan;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveUnion;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.opconventer.HiveAggregateVisitor;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.opconventer.HiveFilterVisitor;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.opconventer.HiveProjectVisitor;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.opconventer.HiveSortExchangeVisitor;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.opconventer.HiveSortLimitVisitor;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.opconventer.HiveTableFunctionScanVisitor;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.opconventer.HiveTableScanVisitor;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.opconventer.HiveUnionVisitor;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.opconventer.JoinVisitor;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.UnparseTranslator;
import org.apache.hadoop.hive.ql.plan.LimitDesc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveOpConverter {
    private static final Logger LOG = LoggerFactory.getLogger(HiveOpConverter.class);
    private final SemanticAnalyzer semanticAnalyzer;
    private final HiveConf hiveConf;
    private final UnparseTranslator unparseTranslator;
    private final Map<String, TableScanOperator> topOps;
    private int uniqueCounter;

    public HiveOpConverter(SemanticAnalyzer semanticAnalyzer, HiveConf hiveConf, UnparseTranslator unparseTranslator, Map<String, TableScanOperator> topOps) {
        this.semanticAnalyzer = semanticAnalyzer;
        this.hiveConf = hiveConf;
        this.unparseTranslator = unparseTranslator;
        this.topOps = topOps;
        this.uniqueCounter = 0;
    }

    public Operator<?> convert(RelNode root) throws SemanticException {
        OpAttr opAf = this.dispatch(root);
        Operator rootOp = (Operator)opAf.inputs.get(0);
        this.handleTopLimit(rootOp);
        return rootOp;
    }

    OpAttr dispatch(RelNode rn) throws SemanticException {
        if (rn instanceof HiveTableScan) {
            return new HiveTableScanVisitor(this).visit((HiveTableScan)rn);
        }
        if (rn instanceof HiveProject) {
            return new HiveProjectVisitor(this).visit((HiveProject)rn);
        }
        if (rn instanceof HiveMultiJoin) {
            return new JoinVisitor(this).visit((RelNode)((HiveMultiJoin)rn));
        }
        if (rn instanceof HiveJoin) {
            return new JoinVisitor(this).visit((HiveJoin)rn);
        }
        if (rn instanceof SemiJoin) {
            return new JoinVisitor(this).visit((RelNode)((SemiJoin)rn));
        }
        if (rn instanceof HiveFilter) {
            return new HiveFilterVisitor(this).visit((HiveFilter)rn);
        }
        if (rn instanceof HiveSortLimit) {
            return new HiveSortLimitVisitor(this).visit((HiveSortLimit)rn);
        }
        if (rn instanceof HiveUnion) {
            return new HiveUnionVisitor(this).visit((HiveUnion)rn);
        }
        if (rn instanceof HiveSortExchange) {
            return new HiveSortExchangeVisitor(this).visit((HiveSortExchange)rn);
        }
        if (rn instanceof HiveAggregate) {
            return new HiveAggregateVisitor(this).visit((HiveAggregate)rn);
        }
        if (rn instanceof HiveTableFunctionScan) {
            return new HiveTableFunctionScanVisitor(this).visit((HiveTableFunctionScan)rn);
        }
        LOG.error(rn.getClass().getCanonicalName() + "operator translation not supported yet in return path.");
        return null;
    }

    private void handleTopLimit(Operator<?> rootOp) {
        if (rootOp instanceof LimitOperator) {
            this.semanticAnalyzer.getQB().getParseInfo().setOuterQueryLimit(((LimitDesc)((LimitOperator)rootOp).getConf()).getLimit());
        }
    }

    String getHiveDerivedTableAlias() {
        return "$hdt$_" + this.uniqueCounter++;
    }

    SemanticAnalyzer getSemanticAnalyzer() {
        return this.semanticAnalyzer;
    }

    HiveConf getHiveConf() {
        return this.hiveConf;
    }

    UnparseTranslator getUnparseTranslator() {
        return this.unparseTranslator;
    }

    Map<String, TableScanOperator> getTopOps() {
        return this.topOps;
    }

    int getUniqueCounter() {
        return this.uniqueCounter;
    }

    static class OpAttr {
        final String tabAlias;
        ImmutableList<Operator<?>> inputs;
        ImmutableSet<Integer> vcolsInCalcite;

        OpAttr(String tabAlias, Set<Integer> vcols, Operator<?> ... inputs) {
            this.tabAlias = tabAlias;
            this.inputs = ImmutableList.copyOf(inputs);
            this.vcolsInCalcite = ImmutableSet.copyOf(vcols);
        }

        OpAttr clone(Operator<?> ... inputs) {
            return new OpAttr(this.tabAlias, this.vcolsInCalcite, inputs);
        }
    }
}

