/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules.jdbc;

import org.apache.calcite.adapter.jdbc.JdbcRules;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rex.RexNode;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.jdbc.HiveJdbcConverter;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.jdbc.JDBCRexCallValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCJoinPushDownRule
extends RelOptRule {
    private static final Logger LOG = LoggerFactory.getLogger(JDBCJoinPushDownRule.class);
    public static final JDBCJoinPushDownRule INSTANCE = new JDBCJoinPushDownRule();

    public JDBCJoinPushDownRule() {
        super(JDBCJoinPushDownRule.operand(HiveJoin.class, (RelOptRuleOperand)JDBCJoinPushDownRule.operand(HiveJdbcConverter.class, (RelOptRuleOperandChildren)JDBCJoinPushDownRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[]{JDBCJoinPushDownRule.operand(HiveJdbcConverter.class, (RelOptRuleOperandChildren)JDBCJoinPushDownRule.any())}));
    }

    public boolean matches(RelOptRuleCall call) {
        HiveJoin join = (HiveJoin)call.rel(0);
        RexNode cond = join.getCondition();
        HiveJdbcConverter converter1 = (HiveJdbcConverter)call.rel(1);
        HiveJdbcConverter converter2 = (HiveJdbcConverter)call.rel(2);
        if (!converter1.getJdbcConvention().getName().equals(converter2.getJdbcConvention().getName())) {
            return false;
        }
        if (!converter1.getConnectionUrl().equals(converter2.getConnectionUrl())) {
            return false;
        }
        if (!converter1.getConnectionUser().equals(converter2.getConnectionUser())) {
            return false;
        }
        if (cond.isAlwaysTrue()) {
            return false;
        }
        return JDBCRexCallValidator.isValidJdbcOperation(cond, converter1.getJdbcDialect());
    }

    public void onMatch(RelOptRuleCall call) {
        JdbcRules.JdbcJoin jdbcJoin;
        LOG.debug("JDBCJoinPushDownRule has been called");
        HiveJoin join = (HiveJoin)call.rel(0);
        HiveJdbcConverter converter1 = (HiveJdbcConverter)call.rel(1);
        RelNode input1 = converter1.getInput();
        HiveJdbcConverter converter2 = (HiveJdbcConverter)call.rel(2);
        RelNode input2 = converter2.getInput();
        try {
            jdbcJoin = new JdbcRules.JdbcJoin(join.getCluster(), join.getTraitSet().replace((RelTrait)converter1.getJdbcConvention()), input1, input2, join.getCondition(), join.getVariablesSet(), join.getJoinType());
        }
        catch (InvalidRelException e) {
            LOG.warn(e.toString());
            return;
        }
        call.transformTo(converter1.copy(converter1.getTraitSet(), (RelNode)jdbcJoin));
    }
}

