/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import java.util.Collections;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.Pair;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.optimizer.calcite.RelOptHiveTable;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveFilter;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableScan;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.PartitionPrune;

public class HivePartitionPruneRule
extends RelOptRule {
    HiveConf conf;

    public HivePartitionPruneRule(HiveConf conf) {
        super(HivePartitionPruneRule.operand(HiveFilter.class, (RelOptRuleOperand)HivePartitionPruneRule.operand(HiveTableScan.class, (RelOptRuleOperandChildren)HivePartitionPruneRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]));
        this.conf = conf;
    }

    public void onMatch(RelOptRuleCall call) {
        HiveFilter filter = (HiveFilter)call.rel(0);
        HiveTableScan tScan = (HiveTableScan)call.rel(1);
        this.perform(call, filter, tScan);
    }

    protected void perform(RelOptRuleCall call, Filter filter, HiveTableScan tScan) {
        RelOptHiveTable hiveTable = (RelOptHiveTable)tScan.getTable();
        HiveTableScan tScanCopy = tScan.copyIncludingTable(tScan.getRowType());
        RelOptHiveTable hiveTableCopy = (RelOptHiveTable)tScanCopy.getTable();
        RexNode predicate = filter.getCondition();
        Pair<RexNode, RexNode> predicates = PartitionPrune.extractPartitionPredicates(filter.getCluster(), hiveTableCopy, predicate);
        RexNode partColExpr = (RexNode)predicates.left;
        hiveTableCopy.computePartitionList(this.conf, partColExpr, tScanCopy.getPartOrVirtualCols());
        if (StringUtils.equals(hiveTableCopy.getPartitionListKey(), hiveTable.getPartitionListKey())) {
            return;
        }
        call.transformTo(filter.copy(filter.getTraitSet(), Collections.singletonList(tScanCopy)));
    }
}

