/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

public class FullOuterMapJoinOptimization {
    FullOuterMapJoinOptimization() {
    }

    public static void removeFilterMap(MapJoinDesc mapJoinDesc) throws SemanticException {
        int[][] filterMaps = mapJoinDesc.getFilterMap();
        if (filterMaps == null) {
            return;
        }
        byte posBigTable = (byte)mapJoinDesc.getPosBigTable();
        int numAliases = mapJoinDesc.getExprs().size();
        List<TableDesc> valueFilteredTblDescs = mapJoinDesc.getValueFilteredTblDescs();
        for (int pos = 0; pos < numAliases; pos = (int)((byte)(pos + 1))) {
            if (pos == posBigTable) continue;
            int[] filterMap = filterMaps[pos];
            TableDesc tableDesc = valueFilteredTblDescs.get(pos);
            Properties properties = tableDesc.getProperties();
            String columnNameProperty = properties.getProperty("columns");
            String columnNameDelimiter = properties.containsKey("column.name.delimiter") ? properties.getProperty("column.name.delimiter") : String.valueOf(',');
            String columnTypeProperty = properties.getProperty("columns.types");
            List<Object> columnNameList = columnNameProperty.length() == 0 ? new ArrayList() : Arrays.asList(columnNameProperty.split(columnNameDelimiter));
            List<Object> truncatedColumnNameList = columnNameList.subList(0, columnNameList.size() - 1);
            String truncatedColumnNameProperty = Joiner.on(columnNameDelimiter).join(truncatedColumnNameList);
            ArrayList<TypeInfo> columnTypeList = columnTypeProperty.length() == 0 ? new ArrayList() : TypeInfoUtils.getTypeInfosFromTypeString(columnTypeProperty);
            if (!((TypeInfo)columnTypeList.get(columnTypeList.size() - 1)).equals(TypeInfoFactory.shortTypeInfo)) {
                throw new SemanticException("Expecting filterTag smallint as last column type");
            }
            List truncatedColumnTypeList = columnTypeList.subList(0, columnTypeList.size() - 1);
            String truncatedColumnTypeProperty = Joiner.on(",").join(truncatedColumnTypeList);
            properties.setProperty("columns", truncatedColumnNameProperty);
            properties.setProperty("columns.types", truncatedColumnTypeProperty);
        }
        mapJoinDesc.setFilterMap(null);
    }
}

