/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.metadata.PartitionTree;

public final class TempTable {
    private final Table tTable;
    private final PartitionTree pTree;
    private static final String EXTERNAL_PARAM = "EXTERNAL";

    TempTable(Table t) {
        assert (t != null);
        this.tTable = t;
        this.pTree = t.getPartitionKeysSize() > 0 ? new PartitionTree(this.tTable) : null;
    }

    Partition addPartition(Partition p) throws AlreadyExistsException, MetaException {
        String partName = Warehouse.makePartName(this.tTable.getPartitionKeys(), p.getValues());
        Partition partition = this.pTree.addPartition(p, partName, false);
        return partition == null ? this.pTree.getPartition(partName) : partition;
    }

    boolean isExternal() {
        return this.tTable.getParameters() != null && "true".equals(this.tTable.getParameters().get(EXTERNAL_PARAM));
    }

    Partition getPartition(String partName) throws MetaException {
        if (partName == null || partName.isEmpty()) {
            throw new MetaException("Partition name cannot be null or empty");
        }
        return this.pTree.getPartition(partName);
    }

    Partition getPartition(List<String> partVals) throws MetaException {
        if (partVals == null) {
            throw new MetaException("Partition values cannot be null");
        }
        return this.pTree.getPartition(partVals);
    }

    List<Partition> addPartitions(List<Partition> partitions, boolean ifNotExists) throws MetaException, AlreadyExistsException {
        return this.pTree.addPartitions(partitions, ifNotExists);
    }

    List<Partition> getPartitionsByNames(List<String> partNames) throws MetaException {
        if (partNames == null) {
            throw new MetaException("Partition names cannot be null");
        }
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        for (String partName : partNames) {
            Partition partition = this.getPartition(partName);
            if (partition == null) continue;
            partitions.add(partition);
        }
        return partitions;
    }

    List<Partition> getPartitionsByPartitionVals(List<String> partialPartVals) throws MetaException {
        return this.pTree.getPartitionsByPartitionVals(partialPartVals);
    }

    Partition getPartitionWithAuthInfo(List<String> partionVals, String userName, List<String> groupNames) throws MetaException {
        Partition partition = this.getPartition(partionVals);
        if (partition == null) {
            return null;
        }
        return this.checkPrivilegesForPartition(partition, userName, groupNames) ? partition : null;
    }

    List<Partition> listPartitions() {
        return this.pTree.listPartitions();
    }

    List<Partition> listPartitionsWithAuthInfo(String userName, List<String> groupNames) {
        List<Partition> partitions = this.listPartitions();
        ArrayList<Partition> result = new ArrayList<Partition>();
        partitions.forEach(p -> {
            if (this.checkPrivilegesForPartition((Partition)p, userName, groupNames)) {
                result.add((Partition)p);
            }
        });
        return result;
    }

    List<Partition> listPartitionsByPartitionValsWithAuthInfo(List<String> partialVals, String userName, List<String> groupNames) throws MetaException {
        List<Partition> partitions = this.pTree.getPartitionsByPartitionVals(partialVals);
        ArrayList<Partition> result = new ArrayList<Partition>();
        partitions.forEach(p -> {
            if (this.checkPrivilegesForPartition((Partition)p, userName, groupNames)) {
                result.add((Partition)p);
            }
        });
        return result;
    }

    private boolean checkPrivilegesForPartition(Partition partition, String userName, List<String> groupNames) {
        if (userName == null || userName.isEmpty()) {
            return true;
        }
        if (groupNames == null || groupNames.isEmpty()) {
            return true;
        }
        PrincipalPrivilegeSet privileges = partition.getPrivileges();
        if (privileges == null) {
            return true;
        }
        if (privileges.isSetUserPrivileges() && !privileges.getUserPrivileges().containsKey(userName)) {
            return false;
        }
        if (privileges.isSetGroupPrivileges()) {
            for (String group : groupNames) {
                if (privileges.getGroupPrivileges().containsKey(group)) continue;
                return false;
            }
        }
        return true;
    }

    Partition dropPartition(List<String> partVals) throws MetaException, NoSuchObjectException {
        return this.pTree.dropPartition(partVals);
    }

    Partition dropPartition(String partitionName) throws MetaException, NoSuchObjectException {
        LinkedHashMap<String, String> specFromName = Warehouse.makeSpecFromName(partitionName);
        if (specFromName.isEmpty()) {
            throw new NoSuchObjectException("Invalid partition name " + partitionName);
        }
        ArrayList<String> pVals = new ArrayList<String>();
        for (FieldSchema field : this.tTable.getPartitionKeys()) {
            String val = (String)specFromName.get(field.getName());
            if (val == null) {
                throw new NoSuchObjectException("Partition name " + partitionName + " and table partition keys " + Arrays.toString(this.tTable.getPartitionKeys().toArray()) + " does not match");
            }
            pVals.add(val);
        }
        return this.pTree.dropPartition(pVals);
    }

    void alterPartition(Partition partition) throws MetaException, InvalidOperationException, NoSuchObjectException {
        this.pTree.alterPartition(partition.getValues(), partition, false);
    }

    void alterPartitions(List<Partition> newParts) throws MetaException, InvalidOperationException, NoSuchObjectException {
        this.pTree.alterPartitions(newParts);
    }

    void renamePartition(List<String> partitionVals, Partition newPart) throws MetaException, InvalidOperationException, NoSuchObjectException {
        this.pTree.renamePartition(partitionVals, newPart);
    }

    int getNumPartitionsByFilter(String filter) throws MetaException {
        return this.pTree.getPartitionsByFilter(filter).size();
    }

    List<Partition> listPartitionsByFilter(String filter) throws MetaException {
        return this.pTree.getPartitionsByFilter(filter);
    }
}

