/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PartitionTree {
    private static final Logger LOG = LoggerFactory.getLogger(PartitionTree.class);
    private Map<String, Partition> parts = new LinkedHashMap<String, Partition>();
    private final Table tTable;

    PartitionTree(Table t) {
        this.tTable = t;
    }

    Partition addPartition(Partition partition, String partName, boolean ifNotExists) throws AlreadyExistsException {
        partition.setDbName(partition.getDbName().toLowerCase());
        partition.setTableName(partition.getTableName().toLowerCase());
        if (!ifNotExists && this.parts.containsKey(partName)) {
            throw new AlreadyExistsException("Partition " + partName + " already exists");
        }
        return this.parts.putIfAbsent(partName, partition);
    }

    Partition getPartition(String partName) {
        return this.parts.get(partName);
    }

    Partition getPartition(List<String> partVals) throws MetaException {
        String partName = Warehouse.makePartName(this.tTable.getPartitionKeys(), partVals);
        return this.getPartition(partName);
    }

    List<Partition> addPartitions(List<Partition> partitions, boolean ifNotExists) throws MetaException, AlreadyExistsException {
        ArrayList<Partition> partitionsAdded = new ArrayList<Partition>();
        HashMap<String, Partition> partNameToPartition = new HashMap<String, Partition>();
        for (Partition partition : partitions) {
            String partName = Warehouse.makePartName(this.tTable.getPartitionKeys(), partition.getValues());
            if (!ifNotExists && this.parts.containsKey(partName)) {
                throw new AlreadyExistsException("Partition " + partName + " already exists");
            }
            partNameToPartition.put(partName, partition);
        }
        for (Map.Entry entry : partNameToPartition.entrySet()) {
            if (this.addPartition((Partition)entry.getValue(), (String)entry.getKey(), ifNotExists) != null) continue;
            partitionsAdded.add((Partition)entry.getValue());
        }
        return partitionsAdded;
    }

    List<Partition> getPartitionsByPartitionVals(List<String> partialPartVals) throws MetaException {
        if (partialPartVals == null || partialPartVals.isEmpty()) {
            throw new MetaException("Partition partial vals cannot be null or empty");
        }
        String partNameMatcher = MetaStoreUtils.makePartNameMatcher(this.tTable, partialPartVals);
        ArrayList<Partition> matchedPartitions = new ArrayList<Partition>();
        for (Map.Entry<String, Partition> entry : this.parts.entrySet()) {
            if (!entry.getKey().matches(partNameMatcher)) continue;
            matchedPartitions.add(entry.getValue());
        }
        return matchedPartitions;
    }

    List<Partition> listPartitions() {
        return new ArrayList<Partition>(this.parts.values());
    }

    Partition dropPartition(List<String> partVals) throws MetaException, NoSuchObjectException {
        String partName = Warehouse.makePartName(this.tTable.getPartitionKeys(), partVals);
        if (!this.parts.containsKey(partName)) {
            throw new NoSuchObjectException("Partition with partition values " + Arrays.toString(partVals.toArray()) + " is not found.");
        }
        return this.parts.remove(partName);
    }

    void alterPartition(List<String> oldPartitionVals, Partition newPartition, boolean isRename) throws MetaException, InvalidOperationException, NoSuchObjectException {
        if (oldPartitionVals == null || oldPartitionVals.isEmpty()) {
            throw new InvalidOperationException("Old partition values cannot be null or empty.");
        }
        if (newPartition == null) {
            throw new InvalidOperationException("New partition cannot be null.");
        }
        Partition oldPartition = this.getPartition(oldPartitionVals);
        if (oldPartition == null) {
            throw new InvalidOperationException("Partition with partition values " + Arrays.toString(oldPartitionVals.toArray()) + " is not found.");
        }
        if (!oldPartition.getDbName().equals(newPartition.getDbName())) {
            throw new MetaException("Db name cannot be altered.");
        }
        if (!oldPartition.getTableName().equals(newPartition.getTableName())) {
            throw new MetaException("Table name cannot be altered.");
        }
        if (isRename) {
            newPartition.getSd().setLocation(oldPartition.getSd().getLocation());
        }
        this.dropPartition(oldPartitionVals);
        String partName = Warehouse.makePartName(this.tTable.getPartitionKeys(), newPartition.getValues());
        if (this.parts.containsKey(partName)) {
            throw new InvalidOperationException("Partition " + partName + " already exists");
        }
        this.parts.put(partName, newPartition);
    }

    void alterPartitions(List<Partition> newParts) throws MetaException, InvalidOperationException, NoSuchObjectException {
        LinkedHashMap<String, Partition> clonedPartitions = new LinkedHashMap<String, Partition>();
        this.parts.forEach((key, value) -> clonedPartitions.put((String)key, new Partition((Partition)value)));
        for (Partition partition : newParts) {
            try {
                if (partition == null) {
                    throw new InvalidOperationException("New partition cannot be null.");
                }
                this.alterPartition(partition.getValues(), partition, false);
            }
            catch (InvalidOperationException | MetaException | NoSuchObjectException e) {
                this.parts = clonedPartitions;
                throw e;
            }
        }
    }

    void renamePartition(List<String> oldPartitionVals, Partition newPart) throws MetaException, InvalidOperationException, NoSuchObjectException {
        this.alterPartition(oldPartitionVals, newPart, true);
    }

    List<Partition> getPartitionsByFilter(String filter) throws MetaException {
        if (filter == null || filter.isEmpty()) {
            return new ArrayList<Partition>(this.parts.values());
        }
        ArrayList<Partition> result = new ArrayList<Partition>();
        ScriptEngine se = new ScriptEngineManager().getEngineByName("JavaScript");
        if (se == null) {
            LOG.error("JavaScript script engine is not found, therefore partition filtering for temporary tables is disabled.");
            return result;
        }
        for (Map.Entry<String, Partition> entry : this.parts.entrySet()) {
            se.put("partitionName", entry.getKey());
            se.put("values", entry.getValue().getValues());
            try {
                if (!((Boolean)se.eval(filter)).booleanValue()) continue;
                result.add(entry.getValue());
            }
            catch (ScriptException e) {
                throw new MetaException("Incorrect partition filter");
            }
        }
        return result;
    }
}

