/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.log.syslog;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.hadoop.hive.common.type.Timestamp;

public class SyslogParser
implements Closeable {
    private static final int EXPECTED_COLUMNS = 11;
    private static final String[] FACILITIES = new String[]{"KERN", "USER", "MAIL", "DAEMON", "AUTH", "SYSLOG", "LPR", "NEWS", "UUCP", "CRON", "AUTHPRIV", "FTP", "NTP", "AUDIT", "ALERT", "CLOCK", "LOCAL0", "LOCAL1", "LOCAL2", "LOCAL3", "LOCAL4", "LOCAL5", "LOCAL6", "LOCAL7"};
    private static final int MAX_SUPPORTED_VERSION = 1;
    private InputStream in;
    private boolean parseTag;
    private static final Charset UTF8 = StandardCharsets.UTF_8;
    private Charset charset;
    private int pushBack = -1;

    public SyslogParser() {
        this(null);
    }

    public SyslogParser(InputStream in) {
        this(in, true, UTF8);
    }

    public SyslogParser(InputStream in, boolean parseTag, Charset encoding) {
        this.in = in;
        this.parseTag = parseTag;
        this.charset = encoding;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    public List<Object> readEvent() throws IOException {
        GregorianCalendar cal;
        int priority;
        int c = this.read(false);
        ArrayList<Object> row = new ArrayList<Object>(11);
        if (c == -1) {
            return null;
        }
        if (c == 60) {
            priority = this.readInt();
            if (priority == -1) {
                return this.unmatchedEvent(c);
            }
        } else {
            return this.unmatchedEvent(c);
        }
        this.expect(62);
        int version = 0;
        if (Character.isDigit(this.peek())) {
            int y = this.readInt();
            c = this.read(true);
            if (c == 32) {
                version = y;
                if (version > 1) {
                    throw new IOException("Unsupported syslog version: " + version);
                }
                this.skipSpaces();
                y = this.readInt();
                this.expect(45);
            } else if (c != 45) {
                throw new IOException("Unexpected syslog character: " + (char)c);
            }
            int m = this.readInt();
            this.expect(45);
            int d = this.readInt();
            c = this.read(true);
            if (c != 84 && c != 32) {
                throw new IOException("Unexpected syslog character: " + (char)c);
            }
            int hh = this.readInt();
            this.expect(58);
            int mm = this.readInt();
            this.expect(58);
            int ss = this.readInt();
            double subss = 0.0;
            c = this.read(true);
            if (c == 46) {
                subss = this.readFractions();
                c = this.read(true);
            }
            int tz = 0;
            if (c != 90) {
                if (c == 45) {
                    tz = this.readInt();
                    if (this.peek() == 58) {
                        this.read(true);
                        tz = -(tz * 60 + this.readInt());
                    }
                } else if (c == 43) {
                    tz = this.readInt();
                    if (this.peek() == 58) {
                        this.read(true);
                        tz = tz * 60 + this.readInt();
                    }
                }
            }
            cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"), Locale.getDefault());
            cal.set(y, m - 1, d, hh, mm, ss);
            cal.set(14, (int)(subss * 1000.0));
            ((Calendar)cal).add(12, tz);
        } else {
            int m = this.readMonthAbbreviation();
            this.expect(32);
            this.skipSpaces();
            int d = this.readInt();
            this.expect(32);
            this.skipSpaces();
            int hh = this.readInt();
            this.expect(58);
            int mm = this.readInt();
            this.expect(58);
            int ss = this.readInt();
            cal = new GregorianCalendar(Locale.ROOT);
            cal.set(2, m);
            cal.set(5, d);
            cal.set(11, hh);
            cal.set(12, mm);
            cal.set(13, ss);
        }
        this.expect(32);
        this.skipSpaces();
        String hostname = this.readWordString();
        this.expect(32);
        byte[] appname = null;
        byte[] procId = null;
        byte[] msgId = null;
        Map<String, String> structuredData = null;
        if (version >= 1) {
            appname = this.readWordOrNil(48);
            this.expect(32);
            procId = this.readWordOrNil(12);
            this.expect(32);
            msgId = this.readWordOrNil(32);
            this.expect(32);
            structuredData = this.readAndParseStructuredData();
        } else if (version == 0 && this.parseTag) {
            appname = this.readTag();
            if (this.peek() == 91) {
                procId = this.readPid();
            }
            this.expect(58);
        }
        c = this.skipSpaces();
        byte[] msg = null;
        if (c != -1) {
            msg = this.readLine();
        }
        this.createEvent(version, priority, cal, hostname, appname, procId, msgId, structuredData, msg, row);
        return row;
    }

    private List<Object> unmatchedEvent(int c) throws IOException {
        ArrayList<Object> row = new ArrayList<Object>(11);
        byte[] msg = this.readLine();
        for (int i = 0; i < 11; ++i) {
            row.add(null);
        }
        row.set(10, ((char)c + new String(msg)).getBytes(this.charset));
        return row;
    }

    private void createEvent(int version, int priority, Calendar cal, String hostname, byte[] appname, byte[] procId, byte[] msgId, Map<String, String> structuredData, byte[] body, List<Object> row) {
        row.add(FACILITIES[priority / 8]);
        row.add(this.getEventPriorityBySyslog(priority));
        row.add(version == 0 ? "RFC3164" : "RFC5424");
        row.add(Timestamp.ofEpochMilli(cal.getTimeInMillis()));
        row.add(hostname);
        row.add(new String(appname));
        row.add(new String(procId));
        row.add(new String(msgId));
        row.add(structuredData);
        row.add(body);
    }

    private String getEventPriorityBySyslog(int priority) {
        switch (priority % 8) {
            case 0: 
            case 1: 
            case 2: {
                return "FATAL";
            }
            case 3: {
                return "ERROR";
            }
            case 4: {
                return "WARN";
            }
            case 5: 
            case 6: {
                return "INFO";
            }
            case 7: {
                return "DEBUG";
            }
        }
        throw new RuntimeException("Failed to look up Syslog priority");
    }

    private int readMonthAbbreviation() throws IOException {
        switch (this.read(true)) {
            case 65: {
                switch (this.read(true)) {
                    case 112: {
                        this.skipWord();
                        return 3;
                    }
                    case 117: {
                        this.skipWord();
                        return 7;
                    }
                }
                return -1;
            }
            case 68: {
                this.skipWord();
                return 11;
            }
            case 70: {
                this.skipWord();
                return 1;
            }
            case 74: {
                this.read(true);
                this.read(true);
                switch (this.read(true)) {
                    case 101: {
                        this.skipWord();
                        return 5;
                    }
                    case 117: {
                        this.skipWord();
                        return 0;
                    }
                    case 121: {
                        this.skipWord();
                        return 6;
                    }
                }
                return -1;
            }
            case 77: {
                this.read(true);
                switch (this.read(true)) {
                    case 114: {
                        this.skipWord();
                        return 2;
                    }
                    case 121: {
                        this.skipWord();
                        return 4;
                    }
                }
                return -1;
            }
            case 78: {
                this.skipWord();
                return 10;
            }
            case 79: {
                this.skipWord();
                return 9;
            }
            case 83: {
                this.skipWord();
                return 8;
            }
        }
        return -1;
    }

    private void expect(int c) throws IOException {
        int d = this.read(true);
        if (d != c) {
            throw new IOException("Unexpected syslog character: " + (char)d);
        }
    }

    private int skipSpaces() throws IOException {
        int c;
        while ((c = this.read(false)) == 32) {
        }
        if (c != -1) {
            this.unread(c);
        }
        return c;
    }

    private int peek() throws IOException {
        int c = this.read(true);
        this.unread(c);
        return c;
    }

    private int read(boolean checkEof) throws IOException {
        if (this.pushBack != -1) {
            int c = this.pushBack;
            this.pushBack = -1;
            return c;
        }
        int c = this.in.read();
        if (checkEof && c == -1) {
            throw new EOFException("Unexpected end of syslog stream");
        }
        return c;
    }

    private void unread(int c) {
        assert (c != -1) : "Trying to push back EOF";
        assert (this.pushBack == -1) : "Trying to push back two bytes";
        this.pushBack = c;
    }

    private int readInt() throws IOException {
        int c;
        int ret = 0;
        boolean foundDigit = false;
        while (Character.isDigit(c = this.read(false))) {
            foundDigit = true;
            ret = ret * 10 + (c - 48);
        }
        if (!foundDigit) {
            this.unread(c);
            return -1;
        }
        if (c != -1) {
            this.unread(c);
        }
        return ret;
    }

    private double readFractions() throws IOException {
        int c;
        int ret = 0;
        int order = 1;
        while (Character.isDigit(c = this.read(false))) {
            ret = ret * 10 + (c - 48);
            order *= 10;
        }
        if (c != -1) {
            this.unread(c);
        }
        return (double)ret / (double)order;
    }

    private void skipWord() throws IOException {
        int c;
        while ((c = this.read(false)) != 32 && c != -1) {
        }
        if (c != -1) {
            this.unread(c);
        }
    }

    private void readWord(OutputStream out) throws IOException {
        int c;
        while ((c = this.read(false)) != 32 && c != -1) {
            out.write(c);
        }
        if (c != -1) {
            this.unread(c);
        }
    }

    private String readWordString() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(256);
        this.readWord(out);
        return out.toString(this.charset.name());
    }

    private byte[] readWord(int sizeHint) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(sizeHint);
        this.readWord(out);
        return out.toByteArray();
    }

    private byte[] readWordOrNil(int sizeHint) throws IOException {
        byte[] ret = this.readWord(sizeHint);
        if (ret.length == 1 && ret[0] == 45) {
            return null;
        }
        return ret;
    }

    private byte[] readLine() throws IOException {
        int c;
        ByteArrayOutputStream ret = new ByteArrayOutputStream(1024);
        while ((c = this.read(false)) != 10 && c != -1) {
            if (c != 13) {
                ret.write(c);
                continue;
            }
            ret.write(10);
        }
        return ret.toByteArray();
    }

    private byte[] readTag() throws IOException {
        int c;
        ByteArrayOutputStream ret = new ByteArrayOutputStream(16);
        while ((c = this.read(true)) != 58 && c != 91 && c != 13 && c != 10) {
            ret.write(c);
        }
        this.unread(c);
        return ret.toByteArray();
    }

    private byte[] readPid() throws IOException {
        int c;
        ByteArrayOutputStream ret = new ByteArrayOutputStream(8);
        this.expect(91);
        while ((c = this.read(true)) != 93 && c != 13 && c != 10) {
            ret.write(c);
        }
        return ret.toByteArray();
    }

    private Map<String, String> readAndParseStructuredData() throws IOException {
        int c = this.read(true);
        if (c == 45) {
            return null;
        }
        ByteArrayOutputStream ret = new ByteArrayOutputStream(128);
        if (c != 91) {
            throw new IOException("Unexpected syslog character: " + (char)c);
        }
        HashMap<String, String> structuredData = new HashMap<String, String>();
        while (c == 91) {
            while ((c = this.read(true)) != 32 && c != 93) {
                ret.write(c);
            }
            String sdId = new String(ret.toByteArray());
            structuredData.put("sdId", sdId);
            ret.reset();
            while (c == 32) {
                while ((c = this.read(true)) != 61) {
                    ret.write(c);
                }
                String sdKey = new String(ret.toByteArray());
                ret.reset();
                this.expect(34);
                while ((c = this.read(true)) != 34) {
                    ret.write(c);
                    if (c != 92) continue;
                    c = this.read(true);
                    ret.write(c);
                }
                String sdValue = new String(ret.toByteArray());
                ret.reset();
                structuredData.put(sdKey, StringEscapeUtils.unescapeHtml4(sdValue));
                c = this.read(true);
            }
            if (c != 93) {
                throw new IOException("Unexpected syslog character: " + (char)c);
            }
            c = this.read(false);
        }
        if (c != -1) {
            this.unread(c);
        }
        return structuredData;
    }

    public void setInputStream(InputStream in) {
        this.in = in;
    }
}

