/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.lib;

import java.util.ArrayDeque;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.Dispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.parse.SemanticException;

public class ExpressionWalker
extends DefaultGraphWalker {
    public ExpressionWalker(Dispatcher disp) {
        super(disp);
    }

    protected boolean shouldByPass(Node childNode, Node parentNode) {
        return false;
    }

    @Override
    protected void walk(Node nd) throws SemanticException {
        ArrayDeque<NodeLabeled> traversalStack = new ArrayDeque<NodeLabeled>();
        traversalStack.push(new NodeLabeled(nd));
        this.opStack.push(nd);
        while (!traversalStack.isEmpty()) {
            NodeLabeled currLabeledNode = (NodeLabeled)traversalStack.peek();
            Node currNode = currLabeledNode.getNd();
            int currIdx = currLabeledNode.getCurrChildIdx();
            if (currNode.getChildren() != null && currNode.getChildren().size() > currIdx + 1) {
                Node nextChild = currNode.getChildren().get(currIdx + 1);
                if (this.shouldByPass(nextChild, currNode)) {
                    this.retMap.put(nextChild, null);
                    currLabeledNode.incrementChildIdx();
                    continue;
                }
                traversalStack.push(new NodeLabeled(nextChild));
                this.opStack.push(nextChild);
                currLabeledNode.incrementChildIdx();
                continue;
            }
            this.dispatch(currNode, this.opStack);
            this.opQueue.add(currNode);
            this.opStack.pop();
            traversalStack.pop();
        }
    }

    private static class NodeLabeled {
        private final Node nd;
        private int currChildIdx;

        NodeLabeled(Node nd) {
            this.nd = nd;
            this.currChildIdx = -1;
        }

        public void incrementChildIdx() {
            ++this.currChildIdx;
        }

        public int getCurrChildIdx() {
            return this.currChildIdx;
        }

        public Node getNd() {
            return this.nd;
        }
    }
}

